/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.metadata.location;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.hibernate.validator.metadata.location.ConstraintLocation;
import org.hibernate.validator.util.Contracts;
import org.hibernate.validator.util.ReflectionHelper;

public class MethodParameterConstraintLocation
implements ConstraintLocation {
    private final Method method;
    private final int parameterIndex;

    public MethodParameterConstraintLocation(Method method, int parameterIndex) {
        Contracts.assertNotNull(method, "Method must not be null");
        this.method = method;
        this.parameterIndex = parameterIndex;
    }

    public Type typeOfAnnotatedElement() {
        Class<?> t = null;
        t = ReflectionHelper.typeOf(this.method, this.parameterIndex);
        if (t instanceof Class && ((Class)t).isPrimitive()) {
            t = ReflectionHelper.boxedType(t);
        }
        return t;
    }

    public String toString() {
        return "MethodConstraintLocation [method=" + this.method + ", parameterIndex=" + this.parameterIndex + "]";
    }
}

