/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.metadata;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.hibernate.validator.metadata.BeanMetaConstraint;
import org.hibernate.validator.metadata.ParameterMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodMetaData
implements Iterable<BeanMetaConstraint<?, ? extends Annotation>> {
    private final Method method;
    private final List<ParameterMetaData> parameterMetaData;
    private final List<BeanMetaConstraint<?, ? extends Annotation>> constraints;
    private final boolean isCascading;
    private final boolean hasParameterConstraints;

    public MethodMetaData(Method method, List<BeanMetaConstraint<?, ? extends Annotation>> constraints, boolean isCascading) {
        this(method, Collections.emptyList(), constraints, isCascading);
    }

    public MethodMetaData(Method method, List<ParameterMetaData> parameterMetaData, List<BeanMetaConstraint<?, ? extends Annotation>> constraints, boolean isCascading) {
        this.method = method;
        this.parameterMetaData = Collections.unmodifiableList(parameterMetaData);
        this.constraints = Collections.unmodifiableList(constraints);
        this.isCascading = isCascading;
        this.hasParameterConstraints = this.hasParameterConstraints(parameterMetaData);
    }

    private boolean hasParameterConstraints(List<ParameterMetaData> parameterMetaData) {
        for (ParameterMetaData oneParameter : parameterMetaData) {
            if (!oneParameter.isConstrained()) continue;
            return true;
        }
        return false;
    }

    public Method getMethod() {
        return this.method;
    }

    public ParameterMetaData getParameterMetaData(int parameterIndex) {
        if (parameterIndex < 0 || parameterIndex > this.parameterMetaData.size() - 1) {
            throw new IllegalArgumentException("Method " + this.method + " doesn't have a parameter with index " + parameterIndex);
        }
        return this.parameterMetaData.get(parameterIndex);
    }

    public List<ParameterMetaData> getAllParameterMetaData() {
        return this.parameterMetaData;
    }

    @Override
    public Iterator<BeanMetaConstraint<?, ? extends Annotation>> iterator() {
        return this.constraints.iterator();
    }

    public boolean isCascading() {
        return this.isCascading;
    }

    public boolean isConstrained() {
        return this.isCascading || !this.constraints.isEmpty() || this.hasParameterConstraints;
    }

    public boolean hasParameterConstraints() {
        return this.hasParameterConstraints;
    }

    public String toString() {
        return "MethodMetaData [method=" + this.method + ", parameterMetaData=" + this.parameterMetaData + ", constraints=" + this.constraints + ", isCascading=" + this.isCascading + ", hasParameterConstraints=" + this.hasParameterConstraints + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.method == null ? 0 : this.method.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MethodMetaData other = (MethodMetaData)obj;
        return !(this.method == null ? other.method != null : !this.method.equals(other.method));
    }
}

