/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.metadata;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import javax.validation.metadata.BeanDescriptor;
import javax.validation.metadata.PropertyDescriptor;
import org.hibernate.validator.metadata.AggregatedMethodMetaData;
import org.hibernate.validator.metadata.BeanMetaData;
import org.hibernate.validator.metadata.ElementDescriptorImpl;
import org.hibernate.validator.metadata.MethodDescriptorImpl;
import org.hibernate.validator.method.metadata.MethodDescriptor;
import org.hibernate.validator.method.metadata.TypeDescriptor;
import org.hibernate.validator.util.CollectionHelper;
import org.hibernate.validator.util.Contracts;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanDescriptorImpl<T>
extends ElementDescriptorImpl
implements BeanDescriptor,
TypeDescriptor {
    public BeanDescriptorImpl(BeanMetaData<T> beanMetaData) {
        super(beanMetaData.getBeanClass(), beanMetaData);
    }

    public final boolean isBeanConstrained() {
        return this.getMetaDataBean().getMetaConstraintsAsMap().size() > 0;
    }

    public final PropertyDescriptor getConstraintsForProperty(String propertyName) {
        if (propertyName == null) {
            throw new IllegalArgumentException("The property name cannot be null");
        }
        return this.getMetaDataBean().getPropertyDescriptor(propertyName);
    }

    public final Set<PropertyDescriptor> getConstrainedProperties() {
        return this.getMetaDataBean().getConstrainedProperties();
    }

    @Override
    public boolean isTypeConstrained() {
        if (this.isBeanConstrained()) {
            return true;
        }
        for (AggregatedMethodMetaData oneMethodMetaData : this.getMetaDataBean().getAllMethodMetaData()) {
            if (!oneMethodMetaData.isConstrained()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<MethodDescriptor> getConstrainedMethods() {
        BeanMetaData<?> beanMetaData = this.getMetaDataBean();
        HashSet<MethodDescriptor> theValue = CollectionHelper.newHashSet();
        for (AggregatedMethodMetaData oneMethodMetaData : beanMetaData.getAllMethodMetaData()) {
            if (!oneMethodMetaData.isConstrained()) continue;
            theValue.add(new MethodDescriptorImpl(beanMetaData, oneMethodMetaData));
        }
        return theValue;
    }

    @Override
    public MethodDescriptor getConstraintsForMethod(String methodName, Class<?> ... parameterTypes) {
        Method method;
        Contracts.assertNotNull(methodName, "The method name must not be null");
        try {
            method = this.getMetaDataBean().getBeanClass().getMethod(methodName, parameterTypes);
        }
        catch (Exception e) {
            return null;
        }
        return new MethodDescriptorImpl(this.getMetaDataBean(), this.getMetaDataBean().getMetaDataFor(method));
    }

    @Override
    public BeanDescriptor getBeanDescriptor() {
        return this;
    }
}

