/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.engine;

import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.MessageInterpolator;
import javax.validation.TraversableResolver;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.spi.ConfigurationState;
import org.hibernate.validator.HibernateValidatorContext;
import org.hibernate.validator.HibernateValidatorFactory;
import org.hibernate.validator.cfg.CascadeDef;
import org.hibernate.validator.cfg.ConstraintDefAccessor;
import org.hibernate.validator.cfg.ConstraintMapping;
import org.hibernate.validator.engine.ConfigurationImpl;
import org.hibernate.validator.engine.ValidatorContextImpl;
import org.hibernate.validator.metadata.AnnotationIgnores;
import org.hibernate.validator.metadata.BeanMetaConstraint;
import org.hibernate.validator.metadata.BeanMetaDataCache;
import org.hibernate.validator.metadata.BeanMetaDataImpl;
import org.hibernate.validator.metadata.ConstraintDescriptorImpl;
import org.hibernate.validator.metadata.ConstraintHelper;
import org.hibernate.validator.metadata.ConstraintOrigin;
import org.hibernate.validator.metadata.MetaConstraint;
import org.hibernate.validator.util.CollectionHelper;
import org.hibernate.validator.util.ReflectionHelper;
import org.hibernate.validator.util.annotationfactory.AnnotationDescriptor;
import org.hibernate.validator.util.annotationfactory.AnnotationFactory;
import org.hibernate.validator.xml.XmlMappingParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidatorFactoryImpl
implements HibernateValidatorFactory {
    private final MessageInterpolator messageInterpolator;
    private final TraversableResolver traversableResolver;
    private final ConstraintValidatorFactory constraintValidatorFactory;
    private final ConstraintHelper constraintHelper;
    private final boolean failFast;
    private final BeanMetaDataCache beanMetaDataCache;

    public ValidatorFactoryImpl(ConfigurationState configurationState) {
        this.messageInterpolator = configurationState.getMessageInterpolator();
        this.constraintValidatorFactory = configurationState.getConstraintValidatorFactory();
        this.traversableResolver = configurationState.getTraversableResolver();
        this.constraintHelper = new ConstraintHelper();
        this.beanMetaDataCache = new BeanMetaDataCache();
        boolean tmpFailFast = false;
        if (!configurationState.getMappingStreams().isEmpty()) {
            this.initXmlConfiguration(configurationState.getMappingStreams());
        }
        if (configurationState instanceof ConfigurationImpl) {
            ConfigurationImpl hibernateSpecificConfig = (ConfigurationImpl)configurationState;
            if (hibernateSpecificConfig.getMapping() != null) {
                this.initProgrammaticConfiguration(hibernateSpecificConfig.getMapping());
            }
            tmpFailFast = hibernateSpecificConfig.getFailFast();
        }
        this.failFast = tmpFailFast = this.checkPropertiesForFailFast(configurationState, tmpFailFast);
    }

    public Validator getValidator() {
        return this.usingContext().getValidator();
    }

    public MessageInterpolator getMessageInterpolator() {
        return this.messageInterpolator;
    }

    public TraversableResolver getTraversableResolver() {
        return this.traversableResolver;
    }

    public ConstraintValidatorFactory getConstraintValidatorFactory() {
        return this.constraintValidatorFactory;
    }

    public <T> T unwrap(Class<T> type) {
        if (HibernateValidatorFactory.class.equals(type)) {
            return type.cast(this);
        }
        throw new ValidationException("Type " + type + " not supported");
    }

    @Override
    public HibernateValidatorContext usingContext() {
        return new ValidatorContextImpl(this.constraintValidatorFactory, this.messageInterpolator, this.traversableResolver, this.constraintHelper, this.beanMetaDataCache, this.failFast);
    }

    private <T> void initProgrammaticConfiguration(ConstraintMapping mapping) {
        Map<Class<?>, List<ConstraintDefAccessor<?>>> constraintsByType = mapping.getConstraintConfig();
        Map<Class<?>, List<CascadeDef>> cascadeConfigByType = mapping.getCascadeConfig();
        Iterator<Class<?>> i$ = mapping.getConfiguredClasses().iterator();
        while (i$.hasNext()) {
            Class<?> clazz;
            Class<?> beanClass = clazz = i$.next();
            List<Class<?>> classes = ReflectionHelper.computeClassHierarchy(beanClass);
            HashMap<Class<?>, List<BeanMetaConstraint<T, ?>>> constraints = CollectionHelper.newHashMap();
            HashSet<Member> cascadedMembers = new HashSet<Member>();
            for (Class<?> classInHierarchy : classes) {
                List<CascadeDef> cascadesOfType;
                List<ConstraintDefAccessor<?>> constraintsOfType = constraintsByType.get(classInHierarchy);
                if (constraintsOfType != null) {
                    this.addProgrammaticConfiguredConstraints(constraintsOfType, beanClass, classInHierarchy, constraints);
                }
                if ((cascadesOfType = cascadeConfigByType.get(classInHierarchy)) == null) continue;
                this.addProgrammaticConfiguredCascade(cascadesOfType, cascadedMembers);
            }
            BeanMetaDataImpl metaData = new BeanMetaDataImpl(beanClass, this.constraintHelper, mapping.getDefaultSequence(beanClass), mapping.getDefaultGroupSequenceProvider(beanClass), constraints, cascadedMembers, new AnnotationIgnores(), this.beanMetaDataCache);
            this.beanMetaDataCache.addBeanMetaData(beanClass, metaData);
        }
    }

    private <T> void initXmlConfiguration(Set<InputStream> mappingStreams) {
        XmlMappingParser mappingParser = new XmlMappingParser(this.constraintHelper);
        mappingParser.parse(mappingStreams);
        Set<Class<?>> xmlConfiguredClasses = mappingParser.getXmlConfiguredClasses();
        AnnotationIgnores annotationIgnores = mappingParser.getAnnotationIgnores();
        Iterator<Class<?>> i$ = xmlConfiguredClasses.iterator();
        while (i$.hasNext()) {
            Class<?> clazz;
            Class<?> beanClass = clazz = i$.next();
            List<Class<?>> classes = ReflectionHelper.computeClassHierarchy(beanClass);
            HashMap<Class<?>, List<BeanMetaConstraint<T, ?>>> constraints = CollectionHelper.newHashMap();
            HashSet<Member> cascadedMembers = new HashSet<Member>();
            for (Class<?> classInHierarchy : classes) {
                if (!xmlConfiguredClasses.contains(classInHierarchy)) continue;
                this.addXmlConfiguredConstraints(mappingParser, beanClass, classInHierarchy, constraints);
                this.addXmlCascadedMember(mappingParser, classInHierarchy, cascadedMembers);
            }
            BeanMetaDataImpl metaData = new BeanMetaDataImpl(beanClass, this.constraintHelper, mappingParser.getDefaultSequenceForClass(beanClass), null, constraints, cascadedMembers, annotationIgnores, this.beanMetaDataCache);
            this.beanMetaDataCache.addBeanMetaData(beanClass, metaData);
        }
    }

    private <T, A extends Annotation> void addXmlConfiguredConstraints(XmlMappingParser mappingParser, Class<T> rootClass, Class<?> hierarchyClass, Map<Class<?>, List<BeanMetaConstraint<T, ?>>> constraints) {
        for (MetaConstraint<?, Annotation> constraint : mappingParser.getConstraintsForClass(hierarchyClass)) {
            ConstraintOrigin definedIn = this.definedIn(rootClass, hierarchyClass);
            ConstraintDescriptorImpl<Annotation> descriptor = new ConstraintDescriptorImpl<Annotation>(constraint.getDescriptor().getAnnotation(), this.constraintHelper, constraint.getElementType(), definedIn);
            BeanMetaConstraint asBeanMetaConstraint = (BeanMetaConstraint)constraint;
            BeanMetaConstraint newMetaConstraint = new BeanMetaConstraint(descriptor, asBeanMetaConstraint.getLocation().getBeanClass(), asBeanMetaConstraint.getLocation().getMember());
            this.addConstraintToMap(hierarchyClass, newMetaConstraint, constraints);
        }
    }

    private <T, A extends Annotation> void addProgrammaticConfiguredConstraints(List<ConstraintDefAccessor<?>> definitions, Class<T> rootClass, Class<?> hierarchyClass, Map<Class<?>, List<BeanMetaConstraint<T, ?>>> constraints) {
        for (ConstraintDefAccessor<?> config : definitions) {
            Object annotation = this.createAnnotationProxy(config);
            ConstraintOrigin definedIn = this.definedIn(rootClass, hierarchyClass);
            ConstraintDescriptorImpl constraintDescriptor = new ConstraintDescriptorImpl(annotation, this.constraintHelper, config.getElementType(), definedIn);
            Member member = null;
            if (config.getProperty().length() != 0) {
                member = ReflectionHelper.getMember(config.getBeanType(), config.getProperty(), config.getElementType());
            }
            BeanMetaConstraint metaConstraint = new BeanMetaConstraint(constraintDescriptor, config.getBeanType(), member);
            this.addConstraintToMap(hierarchyClass, metaConstraint, constraints);
        }
    }

    private <M extends MetaConstraint<?, ? extends Annotation>> void addConstraintToMap(Class<?> hierarchyClass, M constraint, Map<Class<?>, List<M>> constraints) {
        List<M> constraintList = constraints.get(hierarchyClass);
        if (constraintList == null) {
            constraintList = new ArrayList<M>();
            constraints.put(hierarchyClass, constraintList);
        }
        constraintList.add(constraint);
    }

    private void addXmlCascadedMember(XmlMappingParser mappingParser, Class<?> hierarchyClass, Set<Member> cascadedMembers) {
        for (Member m : mappingParser.getCascadedMembersForClass(hierarchyClass)) {
            cascadedMembers.add(m);
        }
    }

    private void addProgrammaticConfiguredCascade(List<CascadeDef> cascades, Set<Member> cascadedMembers) {
        for (CascadeDef cascade : cascades) {
            Member m = ReflectionHelper.getMember(cascade.getBeanType(), cascade.getProperty(), cascade.getElementType());
            cascadedMembers.add(m);
        }
    }

    private ConstraintOrigin definedIn(Class<?> rootClass, Class<?> hierarchyClass) {
        if (hierarchyClass.equals(rootClass)) {
            return ConstraintOrigin.DEFINED_LOCALLY;
        }
        return ConstraintOrigin.DEFINED_IN_HIERARCHY;
    }

    private <A extends Annotation> A createAnnotationProxy(ConstraintDefAccessor<A> config) {
        A annotation;
        Class<A> constraintType = config.getConstraintType();
        AnnotationDescriptor<A> annotationDescriptor = new AnnotationDescriptor<A>(constraintType);
        for (Map.Entry<String, Object> parameter : config.getParameters().entrySet()) {
            annotationDescriptor.setValue(parameter.getKey(), parameter.getValue());
        }
        try {
            annotation = AnnotationFactory.create(annotationDescriptor);
        }
        catch (RuntimeException e) {
            throw new ValidationException("Unable to create annotation for configured constraint: " + e.getMessage(), (Throwable)e);
        }
        return annotation;
    }

    private boolean checkPropertiesForFailFast(ConfigurationState configurationState, boolean programmaticConfiguredFailFast) {
        boolean failFast = programmaticConfiguredFailFast;
        String failFastPropValue = (String)configurationState.getProperties().get("hibernate.validator.fail_fast");
        if (failFastPropValue != null) {
            boolean tmpFailFast = Boolean.valueOf(failFastPropValue);
            if (programmaticConfiguredFailFast && !tmpFailFast) {
                throw new ValidationException("Inconsistent fail fast configuration. Fail fast enabled via programmatic API, but explicitly disabled via properties");
            }
            failFast = tmpFailFast;
        }
        return failFast;
    }
}

