/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.metadata;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.hibernate.validator.metadata.BeanMetaConstraint;
import org.hibernate.validator.metadata.ParameterMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodMetaData
implements Iterable<BeanMetaConstraint<?, ? extends Annotation>> {
    private final Method method;
    private final Map<Integer, ParameterMetaData> parameterMetaData;
    private final List<BeanMetaConstraint<?, ? extends Annotation>> constraints;
    private final boolean isCascading;

    public MethodMetaData(Method method, List<BeanMetaConstraint<?, ? extends Annotation>> constraints, boolean isCascading) {
        this(method, Collections.emptyMap(), constraints, isCascading);
    }

    public MethodMetaData(Method method, Map<Integer, ParameterMetaData> parameterMetaData, List<BeanMetaConstraint<?, ? extends Annotation>> constraints, boolean isCascading) {
        this.method = method;
        this.parameterMetaData = parameterMetaData;
        this.constraints = constraints;
        this.isCascading = isCascading;
    }

    public Method getMethod() {
        return this.method;
    }

    public ParameterMetaData getParameterMetaData(int parameterIndex) {
        ParameterMetaData theValue = this.parameterMetaData.get(parameterIndex);
        return theValue != null ? theValue : ParameterMetaData.NULL;
    }

    @Override
    public Iterator<BeanMetaConstraint<?, ? extends Annotation>> iterator() {
        return this.constraints.iterator();
    }

    public boolean isCascading() {
        return this.isCascading;
    }

    public String toString() {
        return "MethodMetaData [method=" + this.method + ", parameterMetaData=" + this.parameterMetaData + ", constraints=" + this.constraints + ", isCascading=" + this.isCascading + "]";
    }
}

