/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.metadata;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.reflect.Type;
import java.util.Set;
import org.hibernate.validator.engine.ConstraintTree;
import org.hibernate.validator.engine.ValidationContext;
import org.hibernate.validator.engine.ValueContext;
import org.hibernate.validator.metadata.ConstraintDescriptorImpl;
import org.hibernate.validator.metadata.location.ConstraintLocation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MetaConstraint<T, A extends Annotation> {
    private final ConstraintTree<A> constraintTree;
    private final ConstraintDescriptorImpl<A> constraintDescriptor;
    protected final ConstraintLocation location;

    public MetaConstraint(ConstraintDescriptorImpl<A> constraintDescriptor, ConstraintLocation location) {
        this.constraintTree = new ConstraintTree<A>(constraintDescriptor);
        this.constraintDescriptor = constraintDescriptor;
        this.location = location;
    }

    public final Set<Class<?>> getGroupList() {
        return this.constraintDescriptor.getGroups();
    }

    public final ConstraintDescriptorImpl<A> getDescriptor() {
        return this.constraintDescriptor;
    }

    public final ElementType getElementType() {
        return this.constraintDescriptor.getElementType();
    }

    public <T, U, V> boolean validateConstraint(ValidationContext<T, ?> executionContext, ValueContext<U, V> valueContext) {
        valueContext.setElementType(this.getElementType());
        valueContext.setTypeOfAnnotatedElement(this.typeOfAnnotatedElement());
        return this.constraintTree.validateConstraints(executionContext, valueContext);
    }

    public ConstraintLocation getLocation() {
        return this.location;
    }

    protected final Type typeOfAnnotatedElement() {
        return this.location.typeOfAnnotatedElement();
    }

    public String toString() {
        return "MetaConstraint [constraintTree=" + this.constraintTree + ", location=" + this.location + "]";
    }
}

