/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.engine;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.ConstraintViolation;
import javax.validation.MessageInterpolator;
import javax.validation.Path;
import javax.validation.TraversableResolver;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.groups.Default;
import javax.validation.metadata.BeanDescriptor;
import org.hibernate.validator.MethodConstraintViolation;
import org.hibernate.validator.MethodValidator;
import org.hibernate.validator.engine.MethodValidationContext;
import org.hibernate.validator.engine.PathImpl;
import org.hibernate.validator.engine.ValidationContext;
import org.hibernate.validator.engine.ValueContext;
import org.hibernate.validator.engine.groups.Group;
import org.hibernate.validator.engine.groups.GroupChain;
import org.hibernate.validator.engine.groups.GroupChainGenerator;
import org.hibernate.validator.engine.resolver.SingleThreadCachedTraversableResolver;
import org.hibernate.validator.jtype.TypeUtils;
import org.hibernate.validator.metadata.BeanMetaConstraint;
import org.hibernate.validator.metadata.BeanMetaData;
import org.hibernate.validator.metadata.BeanMetaDataCache;
import org.hibernate.validator.metadata.BeanMetaDataImpl;
import org.hibernate.validator.metadata.ConstraintHelper;
import org.hibernate.validator.metadata.MetaConstraint;
import org.hibernate.validator.metadata.MethodMetaData;
import org.hibernate.validator.metadata.ParameterMetaData;
import org.hibernate.validator.util.Contracts;
import org.hibernate.validator.util.ReflectionHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidatorImpl
implements Validator,
MethodValidator {
    private static final Class<?>[] DEFAULT_GROUP_ARRAY = new Class[]{Default.class};
    private final transient GroupChainGenerator groupChainGenerator;
    private final ConstraintValidatorFactory constraintValidatorFactory;
    private final MessageInterpolator messageInterpolator;
    private final TraversableResolver traversableResolver;
    private final ConstraintHelper constraintHelper;
    private final BeanMetaDataCache beanMetaDataCache;

    public ValidatorImpl(ConstraintValidatorFactory constraintValidatorFactory, MessageInterpolator messageInterpolator, TraversableResolver traversableResolver, ConstraintHelper constraintHelper, BeanMetaDataCache beanMetaDataCache) {
        this.constraintValidatorFactory = constraintValidatorFactory;
        this.messageInterpolator = messageInterpolator;
        this.traversableResolver = traversableResolver;
        this.constraintHelper = constraintHelper;
        this.beanMetaDataCache = beanMetaDataCache;
        this.groupChainGenerator = new GroupChainGenerator();
    }

    public final <T> Set<ConstraintViolation<T>> validate(T object, Class<?> ... groups) {
        if (object == null) {
            throw new IllegalArgumentException("Validation of a null object");
        }
        GroupChain groupChain = this.determineGroupExecutionOrder(groups);
        ValidationContext<T, ConstraintViolation<T>> validationContext = ValidationContext.getContextForValidate(object, this.messageInterpolator, this.constraintValidatorFactory, this.getCachingTraversableResolver());
        ValueContext valueContext = ValueContext.getLocalExecutionContext(object, PathImpl.createRootPath());
        return this.validateInContext(valueContext, validationContext, groupChain);
    }

    public final <T> Set<ConstraintViolation<T>> validateProperty(T object, String propertyName, Class<?> ... groups) {
        if (object == null) {
            throw new IllegalArgumentException("Validated object cannot be null.");
        }
        this.sanityCheckPropertyPath(propertyName);
        GroupChain groupChain = this.determineGroupExecutionOrder(groups);
        HashSet<ConstraintViolation<T>> failingConstraintViolations = new HashSet<ConstraintViolation<T>>();
        this.validateProperty(object, PathImpl.createPathFromString(propertyName), failingConstraintViolations, groupChain);
        return failingConstraintViolations;
    }

    public final <T> Set<ConstraintViolation<T>> validateValue(Class<T> beanType, String propertyName, Object value, Class<?> ... groups) {
        if (beanType == null) {
            throw new IllegalArgumentException("The bean type cannot be null.");
        }
        this.sanityCheckPropertyPath(propertyName);
        GroupChain groupChain = this.determineGroupExecutionOrder(groups);
        HashSet<ConstraintViolation<T>> failingConstraintViolations = new HashSet<ConstraintViolation<T>>();
        this.validateValue(beanType, value, PathImpl.createPathFromString(propertyName), failingConstraintViolations, groupChain);
        return failingConstraintViolations;
    }

    @Override
    public final <T> Set<MethodConstraintViolation<T>> validateParameter(T object, Method method, Object parameterValue, int parameterIndex, Class<?> ... groups) {
        Contracts.assertNotNull(object, "The object to be validated must not be null");
        Contracts.assertNotNull(method, "The method to be validated must not be null");
        GroupChain groupChain = this.determineGroupExecutionOrder(groups);
        MethodValidationContext<T> context = ValidationContext.getContextForValidateParameter(method, parameterIndex, object, this.messageInterpolator, this.constraintValidatorFactory, this.getCachingTraversableResolver());
        Object[] parameterValues = new Object[method.getParameterTypes().length];
        parameterValues[parameterIndex] = parameterValue;
        this.validateParametersInContext(context, object, parameterValues, groupChain);
        return context.getFailingConstraints();
    }

    @Override
    public final <T> Set<MethodConstraintViolation<T>> validateParameters(T object, Method method, Object[] parameterValues, Class<?> ... groups) {
        Contracts.assertNotNull(object, "The object to be validated must not be null");
        Contracts.assertNotNull(method, "The method to be validated must not be null");
        if (parameterValues == null) {
            return Collections.emptySet();
        }
        GroupChain groupChain = this.determineGroupExecutionOrder(groups);
        MethodValidationContext<T> context = ValidationContext.getContextForValidateParameters(method, object, this.messageInterpolator, this.constraintValidatorFactory, this.getCachingTraversableResolver());
        this.validateParametersInContext(context, object, parameterValues, groupChain);
        return context.getFailingConstraints();
    }

    @Override
    public <T> Set<MethodConstraintViolation<T>> validateReturnValue(T object, Method method, Object returnValue, Class<?> ... groups) {
        Contracts.assertNotNull(method, "The method to be validated must not be null");
        GroupChain groupChain = this.determineGroupExecutionOrder(groups);
        MethodValidationContext<T> context = ValidationContext.getContextForValidateParameters(method, object, this.messageInterpolator, this.constraintValidatorFactory, this.getCachingTraversableResolver());
        this.validateReturnValueInContext(context, object, method, returnValue, groupChain);
        return context.getFailingConstraints();
    }

    public final BeanDescriptor getConstraintsForClass(Class<?> clazz) {
        return this.getBeanMetaData(clazz).getBeanDescriptor();
    }

    public final <T> T unwrap(Class<T> type) {
        if (type.isAssignableFrom(this.getClass())) {
            return type.cast(this);
        }
        throw new ValidationException("Type " + type + " not supported");
    }

    private void sanityCheckPropertyPath(String propertyName) {
        if (propertyName == null || propertyName.length() == 0) {
            throw new IllegalArgumentException("Invalid property path.");
        }
    }

    private GroupChain determineGroupExecutionOrder(Class<?>[] groups) {
        if (groups == null) {
            throw new IllegalArgumentException("null passed as group name");
        }
        Class<?>[] tmpGroups = groups;
        if (tmpGroups.length == 0) {
            tmpGroups = DEFAULT_GROUP_ARRAY;
        }
        return this.groupChainGenerator.getGroupChainFor(Arrays.asList(tmpGroups));
    }

    private <T, U, V, E extends ConstraintViolation<T>> Set<E> validateInContext(ValueContext<U, V> valueContext, ValidationContext<T, E> context, GroupChain groupChain) {
        Group group;
        if (valueContext.getCurrentBean() == null) {
            return Collections.emptySet();
        }
        BeanMetaData<U> beanMetaData = this.getBeanMetaData(valueContext.getCurrentBeanType());
        if (beanMetaData.defaultGroupSequenceIsRedefined()) {
            groupChain.assertDefaultGroupSequenceIsExpandable(beanMetaData.getDefaultGroupSequence());
        }
        Iterator<Group> groupIterator = groupChain.getGroupIterator();
        while (groupIterator.hasNext()) {
            group = groupIterator.next();
            valueContext.setCurrentGroup(group.getGroup());
            this.validateConstraintsForCurrentGroup(context, valueContext);
        }
        groupIterator = groupChain.getGroupIterator();
        while (groupIterator.hasNext()) {
            group = groupIterator.next();
            valueContext.setCurrentGroup(group.getGroup());
            this.validateCascadedConstraints(context, valueContext);
        }
        Iterator<List<Group>> sequenceIterator = groupChain.getSequenceIterator();
        block2: while (sequenceIterator.hasNext()) {
            List<Group> sequence = sequenceIterator.next();
            for (Group group2 : sequence) {
                int numberOfViolations = context.getFailingConstraints().size();
                valueContext.setCurrentGroup(group2.getGroup());
                this.validateConstraintsForCurrentGroup(context, valueContext);
                this.validateCascadedConstraints(context, valueContext);
                if (context.getFailingConstraints().size() <= numberOfViolations) continue;
                continue block2;
            }
        }
        return context.getFailingConstraints();
    }

    private <T, U, V, E extends ConstraintViolation<T>> void validateConstraintsForCurrentGroup(ValidationContext<T, E> validationContext, ValueContext<U, V> valueContext) {
        BeanMetaData<U> beanMetaData = this.getBeanMetaData(valueContext.getCurrentBeanType());
        boolean validatingDefault = valueContext.validatingDefault();
        boolean validatedBeanRedefinesDefault = beanMetaData.defaultGroupSequenceIsRedefined();
        if (!validatingDefault) {
            this.validateConstraintsForNonDefaultGroup(validationContext, valueContext);
            return;
        }
        if (validatedBeanRedefinesDefault) {
            this.validateConstraintsForRedefinedDefaultGroupOnMainEntity(validationContext, valueContext, beanMetaData);
        } else {
            this.validateConstraintsForRedefinedDefaultGroup(validationContext, valueContext, beanMetaData);
        }
    }

    private <T, U, V, E extends ConstraintViolation<T>> void validateConstraintsForRedefinedDefaultGroup(ValidationContext<T, E> validationContext, ValueContext<U, V> valueContext, BeanMetaData<U> beanMetaData) {
        for (Map.Entry<Class<?>, List<BeanMetaConstraint<U, Annotation>>> entry : beanMetaData.getMetaConstraintsAsMap().entrySet()) {
            Class<?> hostingBeanClass = entry.getKey();
            List<BeanMetaConstraint<U, Annotation>> constraints = entry.getValue();
            List<Class<?>> defaultGroupSequence = this.getBeanMetaData(hostingBeanClass).getDefaultGroupSequence();
            PathImpl currentPath = valueContext.getPropertyPath();
            for (Class<?> defaultSequenceMember : defaultGroupSequence) {
                valueContext.setCurrentGroup(defaultSequenceMember);
                boolean validationSuccessful = true;
                for (BeanMetaConstraint<U, Annotation> metaConstraint : constraints) {
                    boolean tmp = this.validateConstraint(validationContext, valueContext, metaConstraint);
                    validationSuccessful = validationSuccessful && tmp;
                    valueContext.setPropertyPath(currentPath);
                }
                if (validationSuccessful) continue;
                break;
            }
            validationContext.markProcessed(valueContext.getCurrentBean(), valueContext.getCurrentGroup(), valueContext.getPropertyPath());
        }
    }

    private <T, U, V, E extends ConstraintViolation<T>> void validateConstraintsForRedefinedDefaultGroupOnMainEntity(ValidationContext<T, E> validationContext, ValueContext<U, V> valueContext, BeanMetaData<U> beanMetaData) {
        List<Class<?>> defaultGroupSequence = beanMetaData.getDefaultGroupSequence();
        PathImpl currentPath = valueContext.getPropertyPath();
        for (Class<?> defaultSequenceMember : defaultGroupSequence) {
            valueContext.setCurrentGroup(defaultSequenceMember);
            boolean validationSuccessful = true;
            for (BeanMetaConstraint<U, Annotation> metaConstraint : beanMetaData.getMetaConstraintsAsList()) {
                boolean tmp = this.validateConstraint(validationContext, valueContext, metaConstraint);
                validationSuccessful = validationSuccessful && tmp;
                valueContext.setPropertyPath(currentPath);
            }
            if (validationSuccessful) continue;
            break;
        }
        validationContext.markProcessed(valueContext.getCurrentBean(), valueContext.getCurrentGroup(), valueContext.getPropertyPath());
    }

    private <T, U, V> void validateConstraintsForNonDefaultGroup(ValidationContext<T, ?> validationContext, ValueContext<U, V> valueContext) {
        BeanMetaData<U> beanMetaData = this.getBeanMetaData(valueContext.getCurrentBeanType());
        PathImpl currentPath = valueContext.getPropertyPath();
        for (BeanMetaConstraint<U, Annotation> metaConstraint : beanMetaData.getMetaConstraintsAsList()) {
            this.validateConstraint(validationContext, valueContext, metaConstraint);
            valueContext.setPropertyPath(currentPath);
        }
        validationContext.markProcessed(valueContext.getCurrentBean(), valueContext.getCurrentGroup(), valueContext.getPropertyPath());
    }

    private <T, U, V> boolean validateConstraint(ValidationContext<T, ?> validationContext, ValueContext<U, V> valueContext, BeanMetaConstraint<U, ?> metaConstraint) {
        boolean validationSuccessful = true;
        if (metaConstraint.getElementType() != ElementType.TYPE) {
            valueContext.appendNode(metaConstraint.getLocation().getPropertyName());
        }
        if (this.isValidationRequired(validationContext, valueContext, metaConstraint)) {
            Object valueToValidate = metaConstraint.getValue(valueContext.getCurrentBean());
            valueContext.setCurrentValidatedValue(valueToValidate);
            validationSuccessful = metaConstraint.validateConstraint(validationContext, valueContext);
        }
        return validationSuccessful;
    }

    private <T, U, V> void validateCascadedConstraints(ValidationContext<T, ?> validationContext, ValueContext<U, V> valueContext) {
        List<Member> cascadedMembers = this.getBeanMetaData(valueContext.getCurrentBeanType()).getCascadedMembers();
        PathImpl currentPath = valueContext.getPropertyPath();
        for (Member member : cascadedMembers) {
            Object value;
            Type type = ReflectionHelper.typeOf(member);
            String newNode = ReflectionHelper.getPropertyName(member);
            valueContext.appendNode(newNode);
            if (this.isCascadeRequired(validationContext, valueContext, member) && (value = ReflectionHelper.getValue(member, valueContext.getCurrentBean())) != null) {
                Iterator<?> iter = this.createIteratorForCascadedValue(type, value, valueContext);
                boolean isIndexable = this.isIndexable(type);
                this.validateCascadedConstraint(validationContext, iter, isIndexable, valueContext);
            }
            valueContext.setPropertyPath(currentPath);
        }
    }

    private <T, U, V> void validateCascadedMethodConstraints(MethodValidationContext<T> validationContext, ValueContext<U, V> valueContext) {
        U value = valueContext.getCurrentBean();
        Class<U> type = valueContext.getCurrentBeanType();
        Iterator<?> iter = this.createIteratorForCascadedValue(type, value, valueContext);
        boolean isIndexable = this.isIndexable(type);
        this.validateCascadedConstraint(validationContext, iter, isIndexable, valueContext);
    }

    private Iterator<?> createIteratorForCascadedValue(Type type, Object value, ValueContext<?, ?> valueContext) {
        Iterator<Object> iter;
        if (ReflectionHelper.isIterable(type)) {
            iter = ((Iterable)value).iterator();
            valueContext.markCurrentPropertyAsIterable();
        } else if (ReflectionHelper.isMap(type)) {
            Map map = (Map)value;
            iter = map.entrySet().iterator();
            valueContext.markCurrentPropertyAsIterable();
        } else if (TypeUtils.isArray(type)) {
            List<Object> arrayList = Arrays.asList((Object[])value);
            iter = arrayList.iterator();
            valueContext.markCurrentPropertyAsIterable();
        } else {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(value);
            iter = list.iterator();
        }
        return iter;
    }

    private boolean isIndexable(Type type) {
        boolean isIndexable = false;
        if (ReflectionHelper.isList(type)) {
            isIndexable = true;
        } else if (ReflectionHelper.isMap(type)) {
            isIndexable = true;
        } else if (TypeUtils.isArray(type)) {
            isIndexable = true;
        }
        return isIndexable;
    }

    private <T> void validateCascadedConstraint(ValidationContext<T, ?> context, Iterator<?> iter, boolean isIndexable, ValueContext<?, ?> valueContext) {
        int i = 0;
        while (iter.hasNext()) {
            Object value = iter.next();
            if (value instanceof Map.Entry) {
                Object mapKey = ((Map.Entry)value).getKey();
                valueContext.setKey(mapKey);
                value = ((Map.Entry)value).getValue();
            } else if (isIndexable) {
                valueContext.setIndex(i);
            }
            if (!context.isAlreadyValidated(value, valueContext.getCurrentGroup(), valueContext.getPropertyPath())) {
                GroupChain groupChain = this.groupChainGenerator.getGroupChainFor(Arrays.asList(valueContext.getCurrentGroup()));
                ValueContext newValueContext = value != null ? ValueContext.getLocalExecutionContext(value, valueContext.getPropertyPath()) : ValueContext.getLocalExecutionContext(valueContext.getCurrentBeanType(), valueContext.getPropertyPath());
                if (valueContext.getParameterIndex() != null) {
                    newValueContext.setParameterIndex(valueContext.getParameterIndex());
                    newValueContext.setParameterName(valueContext.getParameterName());
                }
                this.validateInContext(newValueContext, context, groupChain);
            }
            ++i;
        }
    }

    private <T> void validateProperty(T object, PathImpl propertyPath, Set<ConstraintViolation<T>> failingConstraintViolations, GroupChain groupChain) {
        Class<?> beanType = object.getClass();
        HashSet metaConstraints = new HashSet();
        Iterator<Path.Node> propertyIter = propertyPath.iterator();
        Object hostingBeanInstance = this.collectMetaConstraintsForPath(beanType, object, propertyIter, metaConstraints);
        if (hostingBeanInstance == null) {
            throw new IllegalArgumentException("Invalid property path.");
        }
        if (metaConstraints.size() == 0) {
            return;
        }
        TraversableResolver cachedResolver = this.getCachingTraversableResolver();
        Iterator<Group> groupIterator = groupChain.getGroupIterator();
        while (groupIterator.hasNext()) {
            Group group = groupIterator.next();
            this.validatePropertyForGroup(object, propertyPath, failingConstraintViolations, metaConstraints, hostingBeanInstance, group, cachedResolver);
        }
        Iterator<List<Group>> sequenceIterator = groupChain.getSequenceIterator();
        block1: while (sequenceIterator.hasNext()) {
            List<Group> sequence = sequenceIterator.next();
            int numberOfConstraintViolationsBefore = failingConstraintViolations.size();
            for (Group group : sequence) {
                this.validatePropertyForGroup(object, propertyPath, failingConstraintViolations, metaConstraints, hostingBeanInstance, group, cachedResolver);
                if (failingConstraintViolations.size() <= numberOfConstraintViolationsBefore) continue;
                continue block1;
            }
        }
    }

    private <T, U, V> void validatePropertyForGroup(T object, PathImpl path, Set<ConstraintViolation<T>> failingConstraintViolations, Set<BeanMetaConstraint<T, ?>> metaConstraints, U hostingBeanInstance, Group group, TraversableResolver cachedTraversableResolver) {
        List<Class<?>> groupList;
        int numberOfConstraintViolationsBefore = failingConstraintViolations.size();
        BeanMetaData<?> beanMetaData = this.getBeanMetaData(object.getClass());
        if (group.isDefaultGroup()) {
            groupList = beanMetaData.getDefaultGroupSequence();
        } else {
            groupList = new ArrayList();
            groupList.add(group.getGroup());
        }
        for (Class<?> groupClass : groupList) {
            for (BeanMetaConstraint<T, ConstraintViolation<T>> beanMetaConstraint : metaConstraints) {
                ValidationContext<T, ConstraintViolation<T>> context = ValidationContext.getContextForValidateProperty(object, this.messageInterpolator, this.constraintValidatorFactory, cachedTraversableResolver);
                ValueContext<U, Object> valueContext = ValueContext.getLocalExecutionContext(hostingBeanInstance, path);
                valueContext.setCurrentGroup(groupClass);
                if (!this.isValidationRequired(context, valueContext, beanMetaConstraint)) continue;
                Object valueToValidate = beanMetaConstraint.getValue(valueContext.getCurrentBean());
                valueContext.setCurrentValidatedValue(valueToValidate);
                beanMetaConstraint.validateConstraint(context, valueContext);
                failingConstraintViolations.addAll(context.getFailingConstraints());
            }
            if (failingConstraintViolations.size() <= numberOfConstraintViolationsBefore) continue;
            break;
        }
    }

    private <T> void validateValue(Class<T> beanType, Object value, PathImpl propertyPath, Set<ConstraintViolation<T>> failingConstraintViolations, GroupChain groupChain) {
        HashSet metaConstraints = new HashSet();
        this.collectMetaConstraintsForPath(beanType, null, propertyPath.iterator(), metaConstraints);
        if (metaConstraints.size() == 0) {
            return;
        }
        TraversableResolver cachedTraversableResolver = this.getCachingTraversableResolver();
        Iterator<Group> groupIterator = groupChain.getGroupIterator();
        while (groupIterator.hasNext()) {
            Group group = groupIterator.next();
            this.validateValueForGroup(beanType, value, propertyPath, failingConstraintViolations, metaConstraints, group, cachedTraversableResolver);
        }
        Iterator<List<Group>> sequenceIterator = groupChain.getSequenceIterator();
        block1: while (sequenceIterator.hasNext()) {
            List<Group> sequence = sequenceIterator.next();
            int numberOfConstraintViolations = failingConstraintViolations.size();
            for (Group group : sequence) {
                this.validateValueForGroup(beanType, value, propertyPath, failingConstraintViolations, metaConstraints, group, cachedTraversableResolver);
                if (failingConstraintViolations.size() <= numberOfConstraintViolations) continue;
                continue block1;
            }
        }
    }

    private <U, V> void validateValueForGroup(Class<U> beanType, V value, PathImpl path, Set<ConstraintViolation<U>> failingConstraintViolations, Set<BeanMetaConstraint<U, ?>> metaConstraints, Group group, TraversableResolver cachedTraversableResolver) {
        List<Class<?>> groupList;
        int numberOfConstraintViolations = failingConstraintViolations.size();
        BeanMetaData<U> beanMetaData = this.getBeanMetaData(beanType);
        if (group.isDefaultGroup()) {
            groupList = beanMetaData.getDefaultGroupSequence();
        } else {
            groupList = new ArrayList();
            groupList.add(group.getGroup());
        }
        for (Class<?> groupClass : groupList) {
            for (BeanMetaConstraint<U, ConstraintViolation<U>> beanMetaConstraint : metaConstraints) {
                ValidationContext<U, ConstraintViolation<U>> context = ValidationContext.getContextForValidateValue(beanType, this.messageInterpolator, this.constraintValidatorFactory, cachedTraversableResolver);
                ValueContext<U, V> valueContext = ValueContext.getLocalExecutionContext(beanType, path);
                valueContext.setCurrentGroup(groupClass);
                valueContext.setCurrentValidatedValue(value);
                if (!this.isValidationRequired(context, valueContext, beanMetaConstraint)) continue;
                beanMetaConstraint.validateConstraint(context, valueContext);
                failingConstraintViolations.addAll(context.getFailingConstraints());
            }
            if (failingConstraintViolations.size() <= numberOfConstraintViolations) continue;
            break;
        }
    }

    private <T> void validateParametersInContext(MethodValidationContext<T> validationContext, T object, Object[] parameterValues, GroupChain groupChain) {
        Method method = validationContext.getMethod();
        BeanMetaData<?> beanMetaData = this.getBeanMetaData(method.getDeclaringClass());
        if (beanMetaData.defaultGroupSequenceIsRedefined()) {
            groupChain.assertDefaultGroupSequenceIsExpandable(beanMetaData.getDefaultGroupSequence());
        }
        Iterator<Group> groupIterator = groupChain.getGroupIterator();
        while (groupIterator.hasNext()) {
            this.validateParametersForGroup(validationContext, object, parameterValues, groupIterator.next());
        }
        Iterator<List<Group>> sequenceIterator = groupChain.getSequenceIterator();
        while (sequenceIterator.hasNext()) {
            Group group;
            int numberOfFailingConstraint;
            List<Group> sequence = sequenceIterator.next();
            Iterator<Group> i$ = sequence.iterator();
            while (i$.hasNext() && (numberOfFailingConstraint = this.validateParametersForGroup(validationContext, object, parameterValues, group = i$.next())) <= 0) {
            }
        }
    }

    private <T> int validateParametersForGroup(MethodValidationContext<T> validationContext, T object, Object[] parameterValues, Group group) {
        int numberOfViolationsBefore = validationContext.getFailingConstraints().size();
        Method method = validationContext.getMethod();
        BeanMetaData<?> beanMetaData = this.getBeanMetaData(method.getDeclaringClass());
        Map<Class<?>, MethodMetaData> methodMetaDataByType = beanMetaData.getMetaDataForMethod(method);
        MethodMetaData methodMetaDataOfDeclaringType = methodMetaDataByType.get(method.getDeclaringClass());
        List<Class<Object>> groupList = group.isDefaultGroup() ? beanMetaData.getDefaultGroupSequence() : Arrays.asList(group.getGroup());
        for (Class<?> oneGroup : groupList) {
            int numberOfViolationsOfCurrentGroup = 0;
            for (Map.Entry<Class<?>, MethodMetaData> constraintsOfOneClass : methodMetaDataByType.entrySet()) {
                for (int i = 0; i < parameterValues.length; ++i) {
                    if (validationContext.getParameterIndex() != null && !validationContext.getParameterIndex().equals(i)) continue;
                    Object value = parameterValues[i];
                    String parameterName = methodMetaDataOfDeclaringType.getParameterMetaData(i).getParameterName();
                    ValueContext<T, Object> valueContext = ValueContext.getLocalExecutionContext(object, PathImpl.createPathForMethodParameter(method, parameterName), i, parameterName);
                    valueContext.setCurrentValidatedValue(value);
                    valueContext.setCurrentGroup(oneGroup);
                    ParameterMetaData parameterMetaData = constraintsOfOneClass.getValue().getParameterMetaData(valueContext.getParameterIndex());
                    numberOfViolationsOfCurrentGroup += this.validateParameterForGroup(validationContext, valueContext, parameterMetaData);
                }
            }
            if (numberOfViolationsOfCurrentGroup <= 0) continue;
            break;
        }
        for (int i = 0; i < parameterValues.length; ++i) {
            if (validationContext.getParameterIndex() != null && !validationContext.getParameterIndex().equals(i)) continue;
            Object value = parameterValues[i];
            String parameterName = methodMetaDataOfDeclaringType.getParameterMetaData(i).getParameterName();
            if (!this.isCascadeRequired(method, i) || value == null) continue;
            ValueContext cascadingvalueContext = ValueContext.getLocalExecutionContext(value, PathImpl.createPathForMethodParameter(method, parameterName), i, parameterName);
            cascadingvalueContext.setCurrentGroup(group.getGroup());
            this.validateCascadedMethodConstraints(validationContext, cascadingvalueContext);
        }
        return validationContext.getFailingConstraints().size() - numberOfViolationsBefore;
    }

    private <T, U, V> int validateParameterForGroup(MethodValidationContext<T> validationContext, ValueContext<U, V> valueContext, ParameterMetaData parameterMetaData) {
        int numberOfViolationsBefore = validationContext.getFailingConstraints().size();
        for (MetaConstraint<?, Annotation> metaConstraint : parameterMetaData) {
            if (!metaConstraint.getGroupList().contains(valueContext.getCurrentGroup())) continue;
            metaConstraint.validateConstraint(validationContext, valueContext);
        }
        return validationContext.getFailingConstraints().size() - numberOfViolationsBefore;
    }

    private <V, T> void validateReturnValueInContext(MethodValidationContext<T> context, T bean, Method method, V value, GroupChain groupChain) {
        BeanMetaData<?> beanMetaData = this.getBeanMetaData(method.getDeclaringClass());
        if (beanMetaData.defaultGroupSequenceIsRedefined()) {
            groupChain.assertDefaultGroupSequenceIsExpandable(beanMetaData.getDefaultGroupSequence());
        }
        Iterator<Group> groupIterator = groupChain.getGroupIterator();
        while (groupIterator.hasNext()) {
            this.validateReturnValueForGroup(context, bean, value, groupIterator.next());
        }
        Iterator<List<Group>> sequenceIterator = groupChain.getSequenceIterator();
        while (sequenceIterator.hasNext()) {
            Group group;
            int numberOfFailingConstraint;
            List<Group> sequence = sequenceIterator.next();
            Iterator<Group> i$ = sequence.iterator();
            while (i$.hasNext() && (numberOfFailingConstraint = this.validateReturnValueForGroup(context, bean, value, group = i$.next())) <= 0) {
            }
        }
    }

    private <T, U, V> int validateReturnValueForGroup(MethodValidationContext<T> validationContext, T bean, V value, Group group) {
        int numberOfViolationsBefore = validationContext.getFailingConstraints().size();
        Method method = validationContext.getMethod();
        BeanMetaData<?> beanMetaData = this.getBeanMetaData(method.getDeclaringClass());
        Map<Class<?>, MethodMetaData> methodMetaDataByType = beanMetaData.getMetaDataForMethod(method);
        List<Class<Object>> groupList = group.isDefaultGroup() ? beanMetaData.getDefaultGroupSequence() : Arrays.asList(group.getGroup());
        for (Class<?> oneGroup : groupList) {
            int numberOfViolationsOfCurrentGroup = 0;
            ValueContext<T, V> valueContext = ValueContext.getLocalExecutionContext(bean, PathImpl.createPathForMethodReturnValue(method));
            valueContext.setCurrentValidatedValue(value);
            valueContext.setCurrentGroup(oneGroup);
            for (Map.Entry<Class<?>, MethodMetaData> constraintsOfOneClass : methodMetaDataByType.entrySet()) {
                numberOfViolationsOfCurrentGroup += this.validateReturnValueForGroup(validationContext, valueContext, constraintsOfOneClass.getValue());
            }
            if (numberOfViolationsOfCurrentGroup <= 0) continue;
            break;
        }
        if (this.isCascadeRequired(method) && value != null) {
            ValueContext cascadingvalueContext = ValueContext.getLocalExecutionContext(value, PathImpl.createPathForMethodReturnValue(method));
            cascadingvalueContext.setCurrentGroup(group.getGroup());
            this.validateCascadedMethodConstraints(validationContext, cascadingvalueContext);
        }
        return validationContext.getFailingConstraints().size() - numberOfViolationsBefore;
    }

    private <T, V> int validateReturnValueForGroup(MethodValidationContext<T> validationContext, ValueContext<T, V> valueContext, MethodMetaData constraintsOfOneClass) {
        int numberOfViolationsBefore = validationContext.getFailingConstraints().size();
        for (BeanMetaConstraint<?, Annotation> metaConstraint : constraintsOfOneClass) {
            if (!metaConstraint.getGroupList().contains(valueContext.getCurrentGroup())) continue;
            metaConstraint.validateConstraint(validationContext, valueContext);
        }
        return validationContext.getFailingConstraints().size() - numberOfViolationsBefore;
    }

    private <T> Object collectMetaConstraintsForPath(Class<T> clazz, Object value, Iterator<Path.Node> propertyIter, Set<BeanMetaConstraint<T, ?>> metaConstraints) {
        Path.Node elem = propertyIter.next();
        Object newValue = value;
        BeanMetaData<T> metaData = this.getBeanMetaData(clazz);
        if (!metaData.isPropertyPresent(elem.getName())) {
            throw new IllegalArgumentException("Invalid property path. There is no property " + elem.getName() + " in entity " + metaData.getBeanClass().getName());
        }
        if (!propertyIter.hasNext()) {
            List<BeanMetaConstraint<T, Annotation>> metaConstraintList = metaData.getMetaConstraintsAsList();
            for (BeanMetaConstraint<T, Annotation> metaConstraint : metaConstraintList) {
                if (elem.getName() == null || !elem.getName().equals(metaConstraint.getLocation().getPropertyName())) continue;
                metaConstraints.add(metaConstraint);
            }
        } else {
            List<Member> cascadedMembers = metaData.getCascadedMembers();
            for (Member m : cascadedMembers) {
                if (!ReflectionHelper.getPropertyName(m).equals(elem.getName())) continue;
                Type type = ReflectionHelper.typeOf(m);
                Object object = newValue = newValue == null ? null : ReflectionHelper.getValue(m, newValue);
                if (elem.isInIterable()) {
                    if (newValue != null && elem.getIndex() != null) {
                        newValue = ReflectionHelper.getIndexedValue(newValue, elem.getIndex());
                    } else if (newValue != null && elem.getKey() != null) {
                        newValue = ReflectionHelper.getMappedValue(newValue, elem.getKey());
                    } else if (newValue != null) {
                        throw new IllegalArgumentException("Property path must provide index or map key");
                    }
                    type = ReflectionHelper.getIndexedType(type);
                }
                Class<?> valueClass = newValue == null ? type : newValue.getClass();
                return this.collectMetaConstraintsForPath(valueClass, newValue, propertyIter, metaConstraints);
            }
        }
        return newValue;
    }

    private <U> BeanMetaData<U> getBeanMetaData(Class<U> beanClass) {
        BeanMetaDataImpl<U> beanMetaData = this.beanMetaDataCache.getBeanMetaData(beanClass);
        if (beanMetaData == null) {
            beanMetaData = new BeanMetaDataImpl<U>(beanClass, this.constraintHelper, this.beanMetaDataCache);
            this.beanMetaDataCache.addBeanMetaData(beanClass, beanMetaData);
        }
        return beanMetaData;
    }

    private TraversableResolver getCachingTraversableResolver() {
        return new SingleThreadCachedTraversableResolver(this.traversableResolver);
    }

    private boolean isValidationRequired(ValidationContext<?, ?> validationContext, ValueContext<?, ?> valueContext, MetaConstraint<?, ?> metaConstraint) {
        boolean isReachable;
        if (!metaConstraint.getGroupList().contains(valueContext.getCurrentGroup())) {
            return false;
        }
        PathImpl path = valueContext.getPropertyPath();
        PathImpl pathToObject = path.getPathWithoutLeafNode();
        try {
            isReachable = validationContext.getTraversableResolver().isReachable(valueContext.getCurrentBean(), (Path.Node)path.getLeafNode(), validationContext.getRootBeanClass(), (Path)pathToObject, metaConstraint.getElementType());
        }
        catch (RuntimeException e) {
            throw new ValidationException("Call to TraversableResolver.isReachable() threw an exception", (Throwable)e);
        }
        return isReachable;
    }

    private boolean isCascadeRequired(ValidationContext<?, ?> validationContext, ValueContext<?, ?> valueContext, Member member) {
        boolean isCascadable;
        boolean isReachable;
        ElementType type = member instanceof Field ? ElementType.FIELD : ElementType.METHOD;
        PathImpl path = valueContext.getPropertyPath();
        PathImpl pathToObject = path.getPathWithoutLeafNode();
        try {
            isReachable = validationContext.getTraversableResolver().isReachable(valueContext.getCurrentBean(), (Path.Node)path.getLeafNode(), validationContext.getRootBeanClass(), (Path)pathToObject, type);
        }
        catch (RuntimeException e) {
            throw new ValidationException("Call to TraversableResolver.isReachable() threw an exception", (Throwable)e);
        }
        try {
            isCascadable = validationContext.getTraversableResolver().isCascadable(valueContext.getCurrentBean(), (Path.Node)path.getLeafNode(), validationContext.getRootBeanClass(), (Path)pathToObject, type);
        }
        catch (RuntimeException e) {
            throw new ValidationException("Call to TraversableResolver.isCascadable() threw an exception", (Throwable)e);
        }
        return isReachable && isCascadable;
    }

    private boolean isCascadeRequired(Method method, int parameterIndex) {
        BeanMetaData<?> beanMetaData = this.getBeanMetaData(method.getDeclaringClass());
        Map<Class<?>, MethodMetaData> methodMetaData = beanMetaData.getMetaDataForMethod(method);
        for (MethodMetaData oneMethodMetaData : methodMetaData.values()) {
            if (!oneMethodMetaData.getParameterMetaData(parameterIndex).isCascading()) continue;
            return true;
        }
        return false;
    }

    private boolean isCascadeRequired(Method method) {
        BeanMetaData<?> beanMetaData = this.getBeanMetaData(method.getDeclaringClass());
        Map<Class<?>, MethodMetaData> methodMetaData = beanMetaData.getMetaDataForMethod(method);
        for (MethodMetaData oneMethodMetaData : methodMetaData.values()) {
            if (!oneMethodMetaData.isCascading()) continue;
            return true;
        }
        return false;
    }
}

