/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validation.util;

import javax.validation.Configuration;
import javax.validation.MessageInterpolator;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorContext;
import javax.validation.ValidatorFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LazyValidatorFactory
implements ValidatorFactory {
    private final Configuration<?> configuration;
    private volatile ValidatorFactory delegate;

    public LazyValidatorFactory() {
        this(null);
    }

    public LazyValidatorFactory(Configuration<?> configuration) {
        this.configuration = configuration;
    }

    public Validator getValidator() {
        if (this.delegate == null) {
            this.initFactory();
        }
        return this.delegate.getValidator();
    }

    private void initFactory() {
        this.delegate = this.configuration == null ? Validation.buildDefaultValidatorFactory() : this.configuration.buildValidatorFactory();
    }

    public ValidatorContext usingContext() {
        if (this.delegate == null) {
            this.initFactory();
        }
        return this.delegate.usingContext();
    }

    public MessageInterpolator getMessageInterpolator() {
        if (this.delegate == null) {
            this.initFactory();
        }
        return this.delegate.getMessageInterpolator();
    }

    public <T> T unwrap(Class<T> clazz) {
        if (this.delegate == null) {
            this.initFactory();
        }
        return (T)this.delegate.unwrap(clazz);
    }
}

