/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validation.metadata;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.validation.metadata.ConstraintDescriptor;
import javax.validation.metadata.ElementDescriptor;
import org.hibernate.validation.engine.groups.Group;
import org.hibernate.validation.engine.groups.GroupChain;
import org.hibernate.validation.engine.groups.GroupChainGenerator;
import org.hibernate.validation.metadata.ConstraintDescriptorImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementDescriptorImpl
implements ElementDescriptor {
    private final Class<?> type;
    private final Set<ConstraintDescriptor<?>> constraintDescriptors = new HashSet();

    public ElementDescriptorImpl(Class<?> type) {
        this.type = type;
    }

    public void addConstraintDescriptor(ConstraintDescriptorImpl constraintDescriptor) {
        this.constraintDescriptors.add(constraintDescriptor);
    }

    public boolean hasConstraints() {
        return this.constraintDescriptors.size() != 0;
    }

    public Class<?> getElementClass() {
        return this.type;
    }

    public Set<ConstraintDescriptor<?>> getConstraintDescriptors() {
        return Collections.unmodifiableSet(this.constraintDescriptors);
    }

    public Set<ConstraintDescriptor<?>> getUnorderdConstraintDescriptorsMatchingGroups(Class<?> ... groups) {
        return this.getUnorderedConstraintDescriptorsMatchingGroups(groups);
    }

    public Set<ConstraintDescriptor<?>> getUnorderedConstraintDescriptorsMatchingGroups(Class<?> ... groups) {
        HashSet matchingDescriptors = new HashSet();
        GroupChain groupChain = new GroupChainGenerator().getGroupChainFor(Arrays.asList(groups));
        Iterator<Group> groupIterator = groupChain.getGroupIterator();
        while (groupIterator.hasNext()) {
            Group g = groupIterator.next();
            this.addMatchingDescriptorsForGroup(g.getGroup(), matchingDescriptors);
        }
        return Collections.unmodifiableSet(matchingDescriptors);
    }

    private void addMatchingDescriptorsForGroup(Class<?> group, Set<ConstraintDescriptor<?>> matchingDescriptors) {
        for (ConstraintDescriptor<?> descriptor : this.constraintDescriptors) {
            if (!descriptor.getGroups().contains(group)) continue;
            matchingDescriptors.add(descriptor);
        }
    }
}

