/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validation.metadata;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.Constraint;
import javax.validation.ConstraintDefinitionException;
import javax.validation.ConstraintPayload;
import javax.validation.ConstraintValidator;
import javax.validation.OverridesAttribute;
import javax.validation.ReportAsSingleViolation;
import javax.validation.ValidationException;
import javax.validation.groups.Default;
import javax.validation.metadata.ConstraintDescriptor;
import org.hibernate.validation.metadata.ConstraintHelper;
import org.hibernate.validation.util.GetAnnotationParameter;
import org.hibernate.validation.util.GetDeclaredMethods;
import org.hibernate.validation.util.GetMethod;
import org.hibernate.validation.util.GetMethods;
import org.hibernate.validation.util.LoggerFactory;
import org.hibernate.validation.util.annotationfactory.AnnotationDescriptor;
import org.hibernate.validation.util.annotationfactory.AnnotationFactory;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstraintDescriptorImpl<T extends Annotation>
implements ConstraintDescriptor<T> {
    private static final Logger log = LoggerFactory.make();
    private static final int OVERRIDES_PARAMETER_DEFAULT_INDEX = -1;
    private static final String GROUPS = "groups";
    private static final String PAYLOAD = "payload";
    private final T annotation;
    private final List<Class<? extends ConstraintValidator<T, ?>>> constraintValidatorDefinitonClasses;
    private final Set<Class<?>> groups;
    private final Map<String, Object> attributes;
    private final Set<Class<ConstraintPayload>> payloads;
    private final Set<ConstraintDescriptor<?>> composingConstraints;
    private final boolean isReportAsSingleInvalidConstraint;
    private final ConstraintHelper constraintHelper;

    public ConstraintDescriptorImpl(T annotation, ConstraintHelper constraintHelper, Class<?> implicitGroup) {
        this.annotation = annotation;
        this.constraintHelper = constraintHelper;
        this.isReportAsSingleInvalidConstraint = annotation.annotationType().isAnnotationPresent(ReportAsSingleViolation.class);
        this.attributes = this.buildAnnotationParameterMap((Annotation)annotation);
        this.groups = this.buildGroupSet(implicitGroup);
        this.payloads = this.buildPayloadSet(annotation);
        this.constraintValidatorDefinitonClasses = this.findConstraintValidatorClasses();
        this.composingConstraints = this.parseComposingConstraints();
    }

    public ConstraintDescriptorImpl(T annotation, ConstraintHelper constraintHelper) {
        this(annotation, constraintHelper, null);
    }

    private Set<Class<ConstraintPayload>> buildPayloadSet(T annotation) {
        Class[] payloadFromAnnotation;
        HashSet payloadSet = new HashSet();
        try {
            GetAnnotationParameter<Class[]> action = GetAnnotationParameter.action(annotation, PAYLOAD, Class[].class);
            payloadFromAnnotation = System.getSecurityManager() != null ? AccessController.doPrivileged(action) : action.run();
        }
        catch (ValidationException e) {
            payloadFromAnnotation = null;
        }
        if (payloadFromAnnotation != null) {
            payloadSet.addAll(Arrays.asList(payloadFromAnnotation));
        }
        return Collections.unmodifiableSet(payloadSet);
    }

    private Set<Class<?>> buildGroupSet(Class<?> implicitGroup) {
        HashSet groupSet = new HashSet();
        GetAnnotationParameter<Class[]> action = GetAnnotationParameter.action(this.annotation, GROUPS, Class[].class);
        Class[] groupsFromAnnotation = System.getSecurityManager() != null ? AccessController.doPrivileged(action) : action.run();
        if (groupsFromAnnotation.length == 0) {
            groupSet.add(Default.class);
        } else {
            groupSet.addAll(Arrays.asList(groupsFromAnnotation));
        }
        if (implicitGroup != null && groupSet.contains(Default.class)) {
            groupSet.add(implicitGroup);
        }
        return Collections.unmodifiableSet(groupSet);
    }

    private List<Class<? extends ConstraintValidator<T, ?>>> findConstraintValidatorClasses() {
        Class<T> annotationType = this.getAnnotationType();
        ArrayList<Class> constraintValidatorClasses = new ArrayList<Class>();
        if (this.constraintHelper.containsConstraintValidatorDefinition(annotationType)) {
            for (Class<ConstraintValidator<T, ?>> validator : this.constraintHelper.getConstraintValidatorDefinition(annotationType)) {
                constraintValidatorClasses.add(validator);
            }
            return Collections.unmodifiableList(constraintValidatorClasses);
        }
        ArrayList constraintDefinitonClasses = new ArrayList();
        if (this.constraintHelper.isBuiltinConstraint(this.annotation.annotationType())) {
            constraintDefinitonClasses.addAll(this.constraintHelper.getBuiltInConstraints(annotationType));
        } else {
            Class[] validatedBy = annotationType.getAnnotation(Constraint.class).validatedBy();
            constraintDefinitonClasses.addAll(Arrays.asList(validatedBy));
        }
        this.constraintHelper.addConstraintValidatorDefinition(this.annotation.annotationType(), constraintDefinitonClasses);
        Iterator i$ = constraintDefinitonClasses.iterator();
        while (i$.hasNext()) {
            Class validator;
            Class safeValidator = validator = (Class)i$.next();
            constraintValidatorClasses.add(safeValidator);
        }
        return Collections.unmodifiableList(constraintValidatorClasses);
    }

    private Class<T> getAnnotationType() {
        return this.annotation.annotationType();
    }

    public T getAnnotation() {
        return this.annotation;
    }

    public Set<Class<?>> getGroups() {
        return this.groups;
    }

    public Set<Class<ConstraintPayload>> getPayload() {
        return this.payloads;
    }

    public List<Class<? extends ConstraintValidator<T, ?>>> getConstraintValidatorClasses() {
        return this.constraintValidatorDefinitonClasses;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public Set<ConstraintDescriptor<?>> getComposingConstraints() {
        return this.composingConstraints;
    }

    public boolean isReportAsSingleViolation() {
        return this.isReportAsSingleInvalidConstraint;
    }

    public String toString() {
        return "ConstraintDescriptorImpl{annotation=" + this.annotation + ", constraintValidatorDefinitonClasses=" + this.constraintValidatorDefinitonClasses.toString() + ", groups=" + this.groups + ", attributes=" + this.attributes + ", composingConstraints=" + this.composingConstraints + ", isReportAsSingleInvalidConstraint=" + this.isReportAsSingleInvalidConstraint + '}';
    }

    private Map<String, Object> buildAnnotationParameterMap(Annotation annotation) {
        GetDeclaredMethods action = GetDeclaredMethods.action(annotation.annotationType());
        Method[] declaredMethods = System.getSecurityManager() != null ? AccessController.doPrivileged(action) : action.run();
        HashMap<String, Object> parameters = new HashMap<String, Object>(declaredMethods.length);
        for (Method m : declaredMethods) {
            try {
                parameters.put(m.getName(), m.invoke((Object)annotation, new Object[0]));
            }
            catch (IllegalAccessException e) {
                throw new ValidationException("Unable to read annotation attributes: " + annotation.getClass(), (Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new ValidationException("Unable to read annotation attributes: " + annotation.getClass(), (Throwable)e);
            }
        }
        return Collections.unmodifiableMap(parameters);
    }

    private Object getMethodValue(Annotation annotation, Method m) {
        Object value;
        try {
            value = m.invoke((Object)annotation, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new ValidationException("Unable to retrieve annotation parameter value.");
        }
        catch (InvocationTargetException e) {
            throw new ValidationException("Unable to retrieve annotation parameter value.");
        }
        return value;
    }

    private Map<ClassIndexWrapper, Map<String, Object>> parseOverrideParameters() {
        HashMap<ClassIndexWrapper, Map<String, Object>> overrideParameters = new HashMap<ClassIndexWrapper, Map<String, Object>>();
        GetMethods getMethods = GetMethods.action(this.annotation.annotationType());
        Method[] methods = System.getSecurityManager() != null ? AccessController.doPrivileged(getMethods) : getMethods.run();
        for (Method m : methods) {
            if (m.getAnnotation(OverridesAttribute.class) != null) {
                this.addOverrideAttributes(overrideParameters, m, m.getAnnotation(OverridesAttribute.class));
                continue;
            }
            if (m.getAnnotation(OverridesAttribute.List.class) == null) continue;
            this.addOverrideAttributes(overrideParameters, m, m.getAnnotation(OverridesAttribute.List.class).value());
        }
        return overrideParameters;
    }

    private void addOverrideAttributes(Map<ClassIndexWrapper, Map<String, Object>> overrideParameters, Method m, OverridesAttribute ... attributes) {
        Object value = this.getMethodValue((Annotation)this.annotation, m);
        for (OverridesAttribute overridesAttribute : attributes) {
            this.ensureAttributeIsOverridable(m, overridesAttribute);
            ClassIndexWrapper wrapper = new ClassIndexWrapper(overridesAttribute.constraint(), overridesAttribute.constraintIndex());
            Map<String, Object> map = overrideParameters.get(wrapper);
            if (map == null) {
                map = new HashMap<String, Object>();
                overrideParameters.put(wrapper, map);
            }
            map.put(overridesAttribute.name(), value);
        }
    }

    private void ensureAttributeIsOverridable(Method m, OverridesAttribute overridesAttribute) {
        GetMethod getMethod = GetMethod.action(overridesAttribute.constraint(), overridesAttribute.name());
        Method method = System.getSecurityManager() != null ? AccessController.doPrivileged(getMethod) : getMethod.run();
        if (method == null) {
            throw new ConstraintDefinitionException("Overriden constraint does not define an attribute with name " + overridesAttribute.name());
        }
        Class<?> returnTypeOfOverridenConstraint = method.getReturnType();
        if (!returnTypeOfOverridenConstraint.equals(m.getReturnType())) {
            String message = "The overiding type of a composite constraint must be identical to the overwridden one. Expected " + returnTypeOfOverridenConstraint.getName() + " found " + m.getReturnType();
            throw new ConstraintDefinitionException(message);
        }
    }

    private Set<ConstraintDescriptor<?>> parseComposingConstraints() {
        HashSet<ConstraintDescriptorImpl<Annotation>> composingConstraintsSet = new HashSet<ConstraintDescriptorImpl<Annotation>>();
        Map<ClassIndexWrapper, Map<String, Object>> overrideParameters = this.parseOverrideParameters();
        for (Annotation declaredAnnotation : this.annotation.annotationType().getDeclaredAnnotations()) {
            if (this.constraintHelper.isConstraintAnnotation(declaredAnnotation) || this.constraintHelper.isBuiltinConstraint(declaredAnnotation.annotationType())) {
                ConstraintDescriptorImpl<Annotation> descriptor = this.createComposingConstraintDescriptor(declaredAnnotation, overrideParameters, -1);
                composingConstraintsSet.add(descriptor);
                log.debug("Adding composing constraint: " + descriptor);
                continue;
            }
            if (!this.constraintHelper.isMultiValueConstraint(declaredAnnotation)) continue;
            List<Annotation> multiValueConstraints = this.constraintHelper.getMultiValueConstraints(declaredAnnotation);
            int index = 0;
            for (Annotation constraintAnnotation : multiValueConstraints) {
                ConstraintDescriptorImpl<Annotation> descriptor = this.createComposingConstraintDescriptor(constraintAnnotation, overrideParameters, index);
                composingConstraintsSet.add(descriptor);
                log.debug("Adding composing constraint: " + descriptor);
                ++index;
            }
        }
        return Collections.unmodifiableSet(composingConstraintsSet);
    }

    private <U extends Annotation> ConstraintDescriptorImpl<U> createComposingConstraintDescriptor(U declaredAnnotation, Map<ClassIndexWrapper, Map<String, Object>> overrideParameters, int index) {
        Class<? extends Annotation> annotationType = declaredAnnotation.annotationType();
        return this.createComposingConstraintDescriptor(overrideParameters, index, declaredAnnotation, annotationType);
    }

    private <U extends Annotation> ConstraintDescriptorImpl<U> createComposingConstraintDescriptor(Map<ClassIndexWrapper, Map<String, Object>> overrideParameters, int index, U constraintAnnotation, Class<U> annotationType) {
        AnnotationDescriptor<U> annotationDescriptor = new AnnotationDescriptor<U>(annotationType, this.buildAnnotationParameterMap(constraintAnnotation));
        Map<String, Object> overrides = overrideParameters.get(new ClassIndexWrapper(annotationType, index));
        if (overrides != null) {
            for (Map.Entry<String, Object> entry : overrides.entrySet()) {
                annotationDescriptor.setValue(entry.getKey(), entry.getValue());
            }
        }
        annotationDescriptor.setValue(GROUPS, this.groups.toArray(new Class[this.groups.size()]));
        U annotationProxy = AnnotationFactory.create(annotationDescriptor);
        return new ConstraintDescriptorImpl<U>(annotationProxy, this.constraintHelper);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ClassIndexWrapper {
        final Class<?> clazz;
        final int index;

        ClassIndexWrapper(Class<?> clazz, int index) {
            this.clazz = clazz;
            this.index = index;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClassIndexWrapper that = (ClassIndexWrapper)o;
            if (this.index != that.index) {
                return false;
            }
            if (this.clazz != null && !this.clazz.equals(that.clazz)) {
                return false;
            }
            return this.clazz != null || that.clazz == null;
        }

        public int hashCode() {
            int result = this.clazz != null ? this.clazz.hashCode() : 0;
            result = 31 * result + this.index;
            return result;
        }
    }
}

