/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validation.constraints.impl;

import java.math.BigDecimal;
import javax.validation.ConstraintDeclarationException;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.constraints.DecimalMax;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DecimalMaxValidatorForString
implements ConstraintValidator<DecimalMax, String> {
    private BigDecimal maxValue;

    public void initialize(DecimalMax maxValue) {
        try {
            this.maxValue = new BigDecimal(maxValue.value());
        }
        catch (NumberFormatException nfe) {
            throw new ConstraintDeclarationException(maxValue.value() + " does not represent a valid BigDemcimal formt");
        }
    }

    public boolean isValid(String value, ConstraintValidatorContext constraintValidatorContext) {
        if (value == null) {
            return true;
        }
        try {
            return new BigDecimal(value).compareTo(this.maxValue) != 1;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }
}

