/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validation.constraints.impl;

import java.math.BigDecimal;
import java.math.BigInteger;
import javax.validation.ConstraintDeclarationException;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.constraints.DecimalMin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DecimalMinValidatorForNumber
implements ConstraintValidator<DecimalMin, Number> {
    private BigDecimal minValue;

    public void initialize(DecimalMin minValue) {
        try {
            this.minValue = new BigDecimal(minValue.value());
        }
        catch (NumberFormatException nfe) {
            throw new ConstraintDeclarationException(minValue.value() + " does not represent a valid BigDemcimal formt");
        }
    }

    public boolean isValid(Number value, ConstraintValidatorContext constraintValidatorContext) {
        if (value == null) {
            return true;
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).compareTo(this.minValue) != -1;
        }
        if (value instanceof BigInteger) {
            return new BigDecimal((BigInteger)value).compareTo(this.minValue) != -1;
        }
        return new BigDecimal(value.doubleValue()).compareTo(this.minValue) != -1;
    }
}

