/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validation.engine;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.BeanDescriptor;
import javax.validation.GroupSequence;
import javax.validation.PropertyDescriptor;
import javax.validation.Valid;
import javax.validation.ValidationException;
import javax.validation.groups.Default;
import org.hibernate.validation.engine.BeanDescriptorImpl;
import org.hibernate.validation.engine.BeanMetaData;
import org.hibernate.validation.engine.ConstraintDescriptorImpl;
import org.hibernate.validation.engine.ConstraintHelper;
import org.hibernate.validation.engine.ElementDescriptorImpl;
import org.hibernate.validation.engine.MetaConstraint;
import org.hibernate.validation.util.LoggerFactory;
import org.hibernate.validation.util.ReflectionHelper;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanMetaDataImpl<T>
implements BeanMetaData<T> {
    private static final Logger log = LoggerFactory.make();
    private final Class<T> beanClass;
    private BeanDescriptorImpl<T> beanDescriptor;
    private List<MetaConstraint<T, ?>> metaConstraintList = new ArrayList();
    private List<Field> cascadedFields = new ArrayList<Field>();
    private List<Method> cascadedMethods = new ArrayList<Method>();
    private Map<String, PropertyDescriptor> propertyDescriptors = new HashMap<String, PropertyDescriptor>();
    private List<Class<?>> defaultGroupSequence = new ArrayList();
    private final ConstraintHelper constraintHelper;

    public BeanMetaDataImpl(Class<T> beanClass, ConstraintHelper constraintHelper) {
        this.beanClass = beanClass;
        this.constraintHelper = constraintHelper;
        this.createMetaData();
    }

    private void createMetaData() {
        this.beanDescriptor = new BeanDescriptorImpl<T>(this.beanClass, this);
        this.initDefaultGroupSequence(this.beanClass);
        ArrayList<Class> classes = new ArrayList<Class>();
        this.computeClassHierarchy(this.beanClass, classes);
        for (Class current : classes) {
            this.initClass(current);
        }
    }

    private void computeClassHierarchy(Class clazz, List<Class> classes) {
        if (log.isTraceEnabled()) {
            log.trace("Processing: {}", (Object)clazz);
        }
        for (Class current = clazz; current != null; current = current.getSuperclass()) {
            if (classes.contains(current)) {
                return;
            }
            classes.add(current);
            for (Class<?> currentInterface : current.getInterfaces()) {
                this.computeClassHierarchy(currentInterface, classes);
            }
        }
    }

    private void initClass(Class clazz) {
        this.initClassConstraints(clazz);
        this.initMethodConstraints(clazz);
        this.initFieldConstraints(clazz);
    }

    private void initDefaultGroupSequence(Class<?> clazz) {
        GroupSequence groupSequenceAnnotation = clazz.getAnnotation(GroupSequence.class);
        if (groupSequenceAnnotation == null) {
            this.defaultGroupSequence.add(Default.class);
        } else {
            List<Class> groupSequenceList = Arrays.asList(groupSequenceAnnotation.value());
            for (Class group : groupSequenceList) {
                if (group.getName().equals(clazz.getName())) {
                    this.defaultGroupSequence.add(Default.class);
                    continue;
                }
                if (group.getName().equals(Default.class.getName())) {
                    throw new ValidationException("'Default.class' cannot appear in default group sequence list.");
                }
                this.defaultGroupSequence.add(group);
            }
            if (log.isDebugEnabled()) {
                log.debug("Bean {} redefines the Default group. Members of the default group sequence are: {}", (Object)clazz.getName(), this.defaultGroupSequence);
            }
        }
    }

    private <A extends Annotation> void initFieldConstraints(Class clazz) {
        for (Field field : clazz.getDeclaredFields()) {
            List<ConstraintDescriptorImpl> fieldMetadata = this.findFieldLevelConstraints(field);
            for (ConstraintDescriptorImpl constraintDescription : fieldMetadata) {
                ReflectionHelper.setAccessibility(field);
                MetaConstraint metaConstraint = new MetaConstraint(field, this.beanClass, constraintDescription);
                this.metaConstraintList.add(metaConstraint);
            }
            if (!field.isAnnotationPresent(Valid.class)) continue;
            ReflectionHelper.setAccessibility(field);
            this.cascadedFields.add(field);
        }
    }

    private <A extends Annotation> void initMethodConstraints(Class clazz) {
        for (Method method : clazz.getDeclaredMethods()) {
            List<ConstraintDescriptorImpl> methodMetadata = this.findMethodLevelConstraints(method);
            for (ConstraintDescriptorImpl constraintDescription : methodMetadata) {
                ReflectionHelper.setAccessibility(method);
                MetaConstraint metaConstraint = new MetaConstraint(method, this.beanClass, constraintDescription);
                this.metaConstraintList.add(metaConstraint);
            }
            if (!method.isAnnotationPresent(Valid.class)) continue;
            ReflectionHelper.setAccessibility(method);
            this.cascadedMethods.add(method);
        }
    }

    private <A extends Annotation> void initClassConstraints(Class clazz) {
        List<ConstraintDescriptorImpl> classMetadata = this.findClassLevelConstraints(clazz);
        for (ConstraintDescriptorImpl constraintDescription : classMetadata) {
            MetaConstraint metaConstraint = new MetaConstraint(clazz, constraintDescription);
            this.metaConstraintList.add(metaConstraint);
        }
    }

    private <A extends Annotation> List<ConstraintDescriptorImpl> findConstraintAnnotations(A annotation) {
        ArrayList<ConstraintDescriptorImpl> constraintDescriptors = new ArrayList<ConstraintDescriptorImpl>();
        ArrayList<Annotation> constraints = new ArrayList<Annotation>();
        if (this.constraintHelper.isConstraintAnnotation(annotation) || this.constraintHelper.isBuiltinConstraint(annotation)) {
            constraints.add(annotation);
        }
        constraints.addAll(this.constraintHelper.getMultiValueConstraints(annotation));
        for (Annotation constraint : constraints) {
            ConstraintDescriptorImpl constraintDescriptor = this.buildConstraintDescriptor(constraint);
            constraintDescriptors.add(constraintDescriptor);
        }
        return constraintDescriptors;
    }

    private <A extends Annotation> ConstraintDescriptorImpl buildConstraintDescriptor(A annotation) {
        Class[] groups = ReflectionHelper.getAnnotationParameter(annotation, "groups", Class[].class);
        return new ConstraintDescriptorImpl<A>(annotation, groups, this.constraintHelper);
    }

    private List<ConstraintDescriptorImpl> findClassLevelConstraints(Class beanClass) {
        ArrayList<ConstraintDescriptorImpl> metadata = new ArrayList<ConstraintDescriptorImpl>();
        for (Annotation annotation : beanClass.getAnnotations()) {
            metadata.addAll(this.findConstraintAnnotations(annotation));
        }
        for (ConstraintDescriptorImpl constraintDescriptor : metadata) {
            this.beanDescriptor.addConstraintDescriptor(constraintDescriptor);
        }
        return metadata;
    }

    private List<ConstraintDescriptorImpl> findMethodLevelConstraints(Method method) {
        ArrayList<ConstraintDescriptorImpl> metadata = new ArrayList<ConstraintDescriptorImpl>();
        for (Annotation annotation : method.getAnnotations()) {
            metadata.addAll(this.findConstraintAnnotations(annotation));
        }
        String methodName = ReflectionHelper.getPropertyName(method);
        for (ConstraintDescriptorImpl constraintDescriptor : metadata) {
            if (methodName == null) {
                throw new ValidationException("Annotated methods must follow the JavaBeans naming convention. " + method.getName() + "() does not.");
            }
            ElementDescriptorImpl elementDescriptor = (ElementDescriptorImpl)this.propertyDescriptors.get(methodName);
            if (elementDescriptor == null) {
                elementDescriptor = new ElementDescriptorImpl(method.getReturnType(), method.isAnnotationPresent(Valid.class), methodName);
                this.propertyDescriptors.put(methodName, elementDescriptor);
            }
            elementDescriptor.addConstraintDescriptor(constraintDescriptor);
        }
        return metadata;
    }

    private List<ConstraintDescriptorImpl> findFieldLevelConstraints(Field field) {
        ArrayList<ConstraintDescriptorImpl> metadata = new ArrayList<ConstraintDescriptorImpl>();
        for (Annotation annotation : field.getAnnotations()) {
            metadata.addAll(this.findConstraintAnnotations(annotation));
        }
        String fieldName = field.getName();
        for (ConstraintDescriptorImpl constraintDescriptor : metadata) {
            ElementDescriptorImpl elementDescriptor = (ElementDescriptorImpl)this.propertyDescriptors.get(fieldName);
            if (elementDescriptor == null) {
                elementDescriptor = new ElementDescriptorImpl(field.getType(), field.isAnnotationPresent(Valid.class), fieldName);
                this.propertyDescriptors.put(field.getName(), elementDescriptor);
            }
            elementDescriptor.addConstraintDescriptor(constraintDescriptor);
        }
        return metadata;
    }

    @Override
    public Class<T> getBeanClass() {
        return this.beanClass;
    }

    @Override
    public BeanDescriptor getBeanDescriptor() {
        return this.beanDescriptor;
    }

    @Override
    public List<Field> getCascadedFields() {
        return this.cascadedFields;
    }

    @Override
    public List<Method> getCascadedMethods() {
        return this.cascadedMethods;
    }

    @Override
    public List<Member> getCascadedMembers() {
        ArrayList<Member> cascadedMembers = new ArrayList<Member>();
        cascadedMembers.addAll(this.getCascadedFields());
        cascadedMembers.addAll(this.getCascadedMethods());
        return cascadedMembers;
    }

    @Override
    public List<MetaConstraint<T, ?>> geMetaConstraintList() {
        return this.metaConstraintList;
    }

    @Override
    public Map<String, PropertyDescriptor> getPropertyDescriptors() {
        return this.propertyDescriptors;
    }

    public PropertyDescriptor getPropertyDescriptors(String property) {
        return this.propertyDescriptors.get(property);
    }

    @Override
    public List<Class<?>> getDefaultGroupSequence() {
        return this.defaultGroupSequence;
    }
}

