/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.cdi;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AnnotatedCallable;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.ProcessBean;
import javax.enterprise.inject.spi.WithAnnotations;
import javax.enterprise.util.AnnotationLiteral;
import javax.validation.BootstrapConfiguration;
import javax.validation.Configuration;
import javax.validation.Constraint;
import javax.validation.Valid;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.executable.ExecutableType;
import javax.validation.executable.ValidateOnExecution;
import javax.validation.metadata.BeanDescriptor;
import javax.validation.metadata.PropertyDescriptor;
import org.hibernate.validator.cdi.HibernateValidator;
import org.hibernate.validator.internal.cdi.ValidatorBean;
import org.hibernate.validator.internal.cdi.ValidatorFactoryBean;
import org.hibernate.validator.internal.cdi.interceptor.ValidationEnabledAnnotatedType;
import org.hibernate.validator.internal.cdi.interceptor.ValidationInterceptor;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.util.Contracts;
import org.hibernate.validator.internal.util.ExecutableHelper;
import org.hibernate.validator.internal.util.ReflectionHelper;
import org.hibernate.validator.internal.util.classhierarchy.ClassHierarchyHelper;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;

public class ValidationExtension
implements Extension {
    private static final Log log = LoggerFactory.make();
    private static final EnumSet<ExecutableType> ALL_EXECUTABLE_TYPES = EnumSet.of(ExecutableType.CONSTRUCTORS, ExecutableType.NON_GETTER_METHODS, ExecutableType.GETTER_METHODS);
    private static final EnumSet<ExecutableType> DEFAULT_EXECUTABLE_TYPES = EnumSet.of(ExecutableType.CONSTRUCTORS, ExecutableType.NON_GETTER_METHODS);
    private final ExecutableHelper executableHelper;
    private final Validator validator;
    private final Set<ExecutableType> globalExecutableTypes;
    private final boolean isExecutableValidationEnabled;
    private boolean validatorRegisteredUnderDefaultQualifier = false;
    private boolean validatorRegisteredUnderHibernateQualifier = false;

    public ValidationExtension() {
        Configuration config = Validation.byDefaultProvider().configure();
        BootstrapConfiguration bootstrap = config.getBootstrapConfiguration();
        this.globalExecutableTypes = bootstrap.getDefaultValidatedExecutableTypes();
        this.isExecutableValidationEnabled = bootstrap.isExecutableValidationEnabled();
        this.validator = config.buildValidatorFactory().getValidator();
        this.executableHelper = new ExecutableHelper();
    }

    public void beforeBeanDiscovery(@Observes BeforeBeanDiscovery beforeBeanDiscoveryEvent, BeanManager beanManager) {
        Contracts.assertNotNull((Object)beforeBeanDiscoveryEvent, (String)"The BeforeBeanDiscovery event cannot be null");
        Contracts.assertNotNull((Object)beanManager, (String)"The BeanManager cannot be null");
        AnnotatedType annotatedType = beanManager.createAnnotatedType(ValidationInterceptor.class);
        beforeBeanDiscoveryEvent.addAnnotatedType(annotatedType);
    }

    public void afterBeanDiscovery(@Observes AfterBeanDiscovery afterBeanDiscoveryEvent, BeanManager beanManager) {
        Contracts.assertNotNull((Object)afterBeanDiscoveryEvent, (String)"The AfterBeanDiscovery event cannot be null");
        Contracts.assertNotNull((Object)beanManager, (String)"The BeanManager cannot be null");
        Set<Annotation> missingQualifiers = this.determineMissingQualifiers();
        if (missingQualifiers.isEmpty()) {
            return;
        }
        afterBeanDiscoveryEvent.addBean((Bean)new ValidatorFactoryBean(beanManager, missingQualifiers));
        afterBeanDiscoveryEvent.addBean((Bean)new ValidatorBean(beanManager, missingQualifiers));
    }

    public void processBean(@Observes ProcessBean<?> processBeanEvent) {
        Contracts.assertNotNull(processBeanEvent, (String)"The ProcessBean event cannot be null");
        Bean bean = processBeanEvent.getBean();
        if (!bean.getTypes().contains(ValidatorFactory.class) && !bean.getTypes().contains(Validator.class)) {
            return;
        }
        if (bean instanceof ValidatorFactoryBean || bean instanceof ValidatorBean) {
            return;
        }
        for (Annotation annotation : bean.getQualifiers()) {
            if (HibernateValidator.class.equals(annotation.annotationType())) {
                this.validatorRegisteredUnderHibernateQualifier = true;
            }
            if (!Default.class.equals(annotation.annotationType())) continue;
            this.validatorRegisteredUnderDefaultQualifier = true;
        }
    }

    public <T> void processAnnotatedType(@Observes @WithAnnotations(value={Constraint.class, Valid.class, ValidateOnExecution.class}) ProcessAnnotatedType<T> processAnnotatedTypeEvent) {
        Contracts.assertNotNull(processAnnotatedTypeEvent, (String)"The ProcessAnnotatedType event cannot be null");
        if (!this.isExecutableValidationEnabled) {
            return;
        }
        AnnotatedType type = processAnnotatedTypeEvent.getAnnotatedType();
        Class clazz = type.getJavaClass();
        EnumSet<ExecutableType> classLevelExecutableTypes = this.executableTypesDefinedOnType(clazz);
        BeanDescriptor beanDescriptor = this.validator.getConstraintsForClass(clazz);
        Set constrainedCallables = this.determineConstrainedCallables(type, beanDescriptor, classLevelExecutableTypes);
        if (!constrainedCallables.isEmpty()) {
            ValidationEnabledAnnotatedType wrappedType = new ValidationEnabledAnnotatedType(type, constrainedCallables);
            processAnnotatedTypeEvent.setAnnotatedType(wrappedType);
        }
    }

    private <T> Set<AnnotatedCallable<? super T>> determineConstrainedCallables(AnnotatedType<T> type, BeanDescriptor beanDescriptor, EnumSet<ExecutableType> classLevelExecutableTypes) {
        HashSet callables = CollectionHelper.newHashSet();
        this.determineConstrainedConstructors(type, beanDescriptor, classLevelExecutableTypes, callables);
        this.determineConstrainedMethod(type, beanDescriptor, callables);
        return callables;
    }

    private <T> void determineConstrainedMethod(AnnotatedType<T> type, BeanDescriptor beanDescriptor, Set<AnnotatedCallable<? super T>> callables) {
        List overriddenAndImplementedMethods = ClassHierarchyHelper.getAllMethods((Class)type.getJavaClass());
        for (AnnotatedMethod annotatedMethod : type.getMethods()) {
            boolean needsValidation;
            ExecutableType currentExecutableType;
            EnumSet<ExecutableType> memberLevelExecutableType;
            Method method = annotatedMethod.getJavaMember();
            method = this.replaceWithOverriddenOrInterfaceMethod(method, overriddenAndImplementedMethods);
            boolean isGetter = ReflectionHelper.isGetterMethod((Method)method);
            EnumSet<ExecutableType> classLevelExecutableTypes = this.executableTypesDefinedOnType(method.getDeclaringClass());
            if (this.veto(classLevelExecutableTypes, memberLevelExecutableType = this.executableTypesDefinedOnMethod(method, isGetter), currentExecutableType = isGetter ? ExecutableType.GETTER_METHODS : ExecutableType.NON_GETTER_METHODS) || !(needsValidation = isGetter ? this.isGetterConstrained(method, beanDescriptor) : this.isNonGetterConstrained(method, beanDescriptor))) continue;
            callables.add((AnnotatedCallable<T>)annotatedMethod);
        }
    }

    private <T> void determineConstrainedConstructors(AnnotatedType<T> type, BeanDescriptor beanDescriptor, EnumSet<ExecutableType> classLevelExecutableTypes, Set<AnnotatedCallable<? super T>> callables) {
        for (AnnotatedConstructor annotatedConstructor : type.getConstructors()) {
            Constructor constructor = annotatedConstructor.getJavaMember();
            EnumSet<ExecutableType> memberLevelExecutableType = this.executableTypesDefinedOnConstructor(constructor);
            if (this.veto(classLevelExecutableTypes, memberLevelExecutableType, ExecutableType.CONSTRUCTORS) || beanDescriptor.getConstraintsForConstructor((Class[])constructor.getParameterTypes()) == null) continue;
            callables.add((AnnotatedCallable<T>)annotatedConstructor);
        }
    }

    private boolean isNonGetterConstrained(Method method, BeanDescriptor beanDescriptor) {
        return beanDescriptor.getConstraintsForMethod(method.getName(), (Class[])method.getParameterTypes()) != null;
    }

    private boolean isGetterConstrained(Method method, BeanDescriptor beanDescriptor) {
        String propertyName = ReflectionHelper.getPropertyName((Member)method);
        PropertyDescriptor propertyDescriptor = beanDescriptor.getConstraintsForProperty(propertyName);
        return propertyDescriptor != null && propertyDescriptor.findConstraints().declaredOn(new ElementType[]{ElementType.METHOD}).hasConstraints();
    }

    private boolean veto(EnumSet<ExecutableType> classLevelExecutableTypes, EnumSet<ExecutableType> memberLevelExecutableType, ExecutableType currentExecutableType) {
        if (!memberLevelExecutableType.isEmpty()) {
            return !memberLevelExecutableType.contains(currentExecutableType) && !memberLevelExecutableType.contains(ExecutableType.IMPLICIT);
        }
        if (!classLevelExecutableTypes.isEmpty()) {
            return !classLevelExecutableTypes.contains(currentExecutableType) && !classLevelExecutableTypes.contains(ExecutableType.IMPLICIT);
        }
        return !this.globalExecutableTypes.contains(currentExecutableType);
    }

    private Set<Annotation> determineMissingQualifiers() {
        HashSet annotations = CollectionHelper.newHashSet((int)2);
        if (!this.validatorRegisteredUnderDefaultQualifier) {
            annotations.add(new AnnotationLiteral<Default>(){});
        }
        if (!this.validatorRegisteredUnderHibernateQualifier) {
            annotations.add(new AnnotationLiteral<HibernateValidator>(){});
        }
        return annotations;
    }

    private EnumSet<ExecutableType> executableTypesDefinedOnType(Class<?> clazz) {
        ValidateOnExecution validateOnExecutionAnnotation = clazz.getAnnotation(ValidateOnExecution.class);
        EnumSet<ExecutableType> executableTypes = this.commonExecutableTypeChecks(validateOnExecutionAnnotation);
        if (executableTypes.contains(ExecutableType.IMPLICIT)) {
            return DEFAULT_EXECUTABLE_TYPES;
        }
        return executableTypes;
    }

    private EnumSet<ExecutableType> executableTypesDefinedOnMethod(Method method, boolean isGetter) {
        ValidateOnExecution validateOnExecutionAnnotation = method.getAnnotation(ValidateOnExecution.class);
        EnumSet<ExecutableType> executableTypes = this.commonExecutableTypeChecks(validateOnExecutionAnnotation);
        if (executableTypes.contains(ExecutableType.IMPLICIT)) {
            if (isGetter) {
                executableTypes.add(ExecutableType.GETTER_METHODS);
            } else {
                executableTypes.add(ExecutableType.NON_GETTER_METHODS);
            }
        }
        return executableTypes;
    }

    private EnumSet<ExecutableType> executableTypesDefinedOnConstructor(Constructor<?> constructor) {
        ValidateOnExecution validateOnExecutionAnnotation = constructor.getAnnotation(ValidateOnExecution.class);
        EnumSet<ExecutableType> executableTypes = this.commonExecutableTypeChecks(validateOnExecutionAnnotation);
        if (executableTypes.contains(ExecutableType.IMPLICIT)) {
            executableTypes.add(ExecutableType.CONSTRUCTORS);
        }
        return executableTypes;
    }

    private EnumSet<ExecutableType> commonExecutableTypeChecks(ValidateOnExecution validateOnExecutionAnnotation) {
        if (validateOnExecutionAnnotation == null) {
            return EnumSet.noneOf(ExecutableType.class);
        }
        EnumSet<ExecutableType> executableTypes = EnumSet.noneOf(ExecutableType.class);
        if (validateOnExecutionAnnotation.type().length == 0) {
            executableTypes.add(ExecutableType.NONE);
        } else {
            Collections.addAll(executableTypes, validateOnExecutionAnnotation.type());
        }
        if (executableTypes.contains(ExecutableType.IMPLICIT) && executableTypes.size() > 1) {
            throw log.getMixingImplicitWithOtherExecutableTypesException();
        }
        if (executableTypes.contains(ExecutableType.NONE) && executableTypes.size() > 1) {
            executableTypes.remove(ExecutableType.NONE);
        }
        if (executableTypes.contains(ExecutableType.ALL)) {
            executableTypes = ALL_EXECUTABLE_TYPES;
        }
        return executableTypes;
    }

    public Method replaceWithOverriddenOrInterfaceMethod(Method method, List<Method> allMethodsOfType) {
        LinkedList<Method> list = new LinkedList<Method>(allMethodsOfType);
        Iterator<Method> iterator = list.descendingIterator();
        while (iterator.hasNext()) {
            Method overriddenOrInterfaceMethod = iterator.next();
            if (!this.executableHelper.overrides(method, overriddenOrInterfaceMethod)) continue;
            if (method.getAnnotation(ValidateOnExecution.class) != null) {
                throw log.getValidateOnExecutionOnOverriddenOrInterfaceMethodException(method);
            }
            return overriddenOrInterfaceMethod;
        }
        return method;
    }
}

