/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.ap.classchecks;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.ExecutableElement;
import org.hibernate.validator.ap.util.CollectionHelper;

public class MethodInheritanceTree {
    private final MethodNode rootMethodNode;
    private final Map<ExecutableElement, MethodNode> methodNodeMapping;
    private final Set<ExecutableElement> topLevelMethods;
    private final Set<ExecutableElement> overriddenMethods;

    private MethodInheritanceTree(MethodNode rootMethodNode, Map<ExecutableElement, MethodNode> nodeMapping) {
        this.rootMethodNode = rootMethodNode;
        this.methodNodeMapping = Collections.unmodifiableMap(nodeMapping);
        this.topLevelMethods = this.buildTopLevelMethodSet();
        this.overriddenMethods = this.buildOverriddenMethodSet();
    }

    public boolean hasOverriddenMethods() {
        return this.overriddenMethods.size() > 0;
    }

    public Set<ExecutableElement> getAllMethods() {
        return Collections.unmodifiableSet(this.methodNodeMapping.keySet());
    }

    public Set<ExecutableElement> getOverriddenMethods() {
        return this.overriddenMethods;
    }

    public boolean hasParallelDefinitions() {
        return this.topLevelMethods.size() > 1;
    }

    public Set<ExecutableElement> getTopLevelMethods() {
        return this.topLevelMethods;
    }

    private Set<ExecutableElement> buildOverriddenMethodSet() {
        HashSet overriddenMethods = CollectionHelper.newHashSet();
        for (ExecutableElement method : this.methodNodeMapping.keySet()) {
            if (this.rootMethodNode.getMethod().equals(method)) continue;
            overriddenMethods.add(method);
        }
        return Collections.unmodifiableSet(overriddenMethods);
    }

    private Set<ExecutableElement> buildTopLevelMethodSet() {
        HashSet methods = CollectionHelper.newHashSet();
        for (MethodNode methodNode : this.methodNodeMapping.values()) {
            if (methodNode.isOverriding()) continue;
            methods.add(methodNode.getMethod());
        }
        return Collections.unmodifiableSet(methods);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder().append("MethodInheritanceTree [").append("rootMethodNode=").append(this.rootMethodNode).append("]");
        return sb.toString();
    }

    private static class MethodNode {
        private ExecutableElement method;
        private Set<MethodNode> overriddenMethodNodes;

        private MethodNode(ExecutableElement method) {
            this.method = method;
            this.overriddenMethodNodes = CollectionHelper.newHashSet();
        }

        private boolean isOverriding() {
            return !this.overriddenMethodNodes.isEmpty();
        }

        private ExecutableElement getMethod() {
            return this.method;
        }

        private void addOverriddenMethodNode(MethodNode overriddenMethodNode) {
            this.overriddenMethodNodes.add(overriddenMethodNode);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder().append("MethodNode [").append("method=").append(this.method).append("]");
            return sb.toString();
        }
    }

    public static class Builder {
        private final MethodNode rootMethodNode;
        private final Map<ExecutableElement, MethodNode> nodeMapping = CollectionHelper.newHashMap();

        public Builder(ExecutableElement rootMethod) {
            this.rootMethodNode = new MethodNode(rootMethod);
            this.nodeMapping.put(rootMethod, this.rootMethodNode);
        }

        public void addOverriddenMethod(ExecutableElement overridingMethod, ExecutableElement overriddenMethod) {
            MethodNode overriddenMethodNode = new MethodNode(overriddenMethod);
            this.nodeMapping.get(overridingMethod).addOverriddenMethodNode(overriddenMethodNode);
            this.nodeMapping.put(overriddenMethod, overriddenMethodNode);
        }

        public MethodInheritanceTree build() {
            return new MethodInheritanceTree(this.rootMethodNode, this.nodeMapping);
        }
    }
}

