/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.ap.checks;

import java.util.Collections;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.TypeElement;
import org.hibernate.validator.ap.checks.AbstractConstraintCheck;
import org.hibernate.validator.ap.checks.ConstraintCheckIssue;
import org.hibernate.validator.ap.util.AnnotationApiHelper;
import org.hibernate.validator.ap.util.CollectionHelper;
import org.hibernate.validator.ap.util.ConstraintHelper;

public class ConstraintValidatorCheck
extends AbstractConstraintCheck {
    private ConstraintHelper constraintHelper;
    private final AnnotationApiHelper annotationApiHelper;

    public ConstraintValidatorCheck(ConstraintHelper constraintHelper, AnnotationApiHelper annotationApiHelper) {
        this.constraintHelper = constraintHelper;
        this.annotationApiHelper = annotationApiHelper;
    }

    @Override
    public Set<ConstraintCheckIssue> checkAnnotationType(TypeElement element, AnnotationMirror annotation) {
        boolean atLeastOneValidatorGiven;
        AnnotationMirror constraintMirror = this.annotationApiHelper.getMirror(element.getAnnotationMirrors(), "javax.validation.Constraint");
        boolean bl = atLeastOneValidatorGiven = !this.annotationApiHelper.getAnnotationArrayValue(constraintMirror, "validatedBy").isEmpty();
        if (!atLeastOneValidatorGiven && !this.constraintHelper.isComposedConstraint(element)) {
            return CollectionHelper.asSet(ConstraintCheckIssue.error(element, constraintMirror, "CONSTRAINT_TYPE_WITHOUT_VALIDATOR", new Object[0]));
        }
        return Collections.emptySet();
    }
}

