/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.ap.checks.annotationparameters;

import java.util.Collections;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import org.hibernate.validator.ap.checks.ConstraintCheckIssue;
import org.hibernate.validator.ap.checks.annotationparameters.AnnotationParametersAbstractCheck;
import org.hibernate.validator.ap.util.AnnotationApiHelper;
import org.hibernate.validator.ap.util.CollectionHelper;

public class AnnotationParametersDigitsCheck
extends AnnotationParametersAbstractCheck {
    public AnnotationParametersDigitsCheck(AnnotationApiHelper annotationApiHelper) {
        super(annotationApiHelper, "javax.validation.constraints.Digits");
    }

    @Override
    protected Set<ConstraintCheckIssue> doCheck(Element element, AnnotationMirror annotation) {
        Integer integer = (Integer)this.annotationApiHelper.getAnnotationValue(annotation, "integer").getValue();
        Integer fraction = (Integer)this.annotationApiHelper.getAnnotationValue(annotation, "fraction").getValue();
        if (integer < 0 || fraction < 0) {
            return CollectionHelper.asSet(ConstraintCheckIssue.error(element, annotation, "INVALID_DIGITS_ANNOTATION_PARAMETERS", new Object[0]));
        }
        return Collections.emptySet();
    }
}

