/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.ap;

import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.tools.Diagnostic;
import org.hibernate.validator.ap.AbstractElementVisitor;
import org.hibernate.validator.ap.checks.ConstraintCheckFactory;
import org.hibernate.validator.ap.checks.ConstraintChecks;
import org.hibernate.validator.ap.util.AnnotationApiHelper;
import org.hibernate.validator.ap.util.Configuration;
import org.hibernate.validator.ap.util.ConstraintHelper;
import org.hibernate.validator.ap.util.MessagerAdapter;

final class ConstraintAnnotationVisitor
extends AbstractElementVisitor<Void, List<AnnotationMirror>> {
    private final ConstraintCheckFactory constraintCheckFactory;

    public ConstraintAnnotationVisitor(ProcessingEnvironment processingEnvironment, MessagerAdapter messager, Configuration configuration) {
        super(messager, configuration);
        AnnotationApiHelper annotationApiHelper = new AnnotationApiHelper(processingEnvironment.getElementUtils(), processingEnvironment.getTypeUtils());
        ConstraintHelper constraintHelper = new ConstraintHelper(processingEnvironment.getTypeUtils(), annotationApiHelper);
        this.constraintCheckFactory = new ConstraintCheckFactory(processingEnvironment.getTypeUtils(), processingEnvironment.getElementUtils(), constraintHelper, annotationApiHelper, configuration.methodConstraintsSupported());
    }

    @Override
    public Void visitExecutableAsMethod(ExecutableElement method, List<AnnotationMirror> mirrors) {
        this.checkConstraints(method, mirrors);
        return null;
    }

    @Override
    public Void visitVariableAsField(VariableElement annotatedField, List<AnnotationMirror> mirrors) {
        this.checkConstraints(annotatedField, mirrors);
        return null;
    }

    @Override
    public Void visitVariableAsParameter(VariableElement annotatedField, List<AnnotationMirror> mirrors) {
        this.checkConstraints(annotatedField, mirrors);
        return null;
    }

    @Override
    public Void visitTypeAsAnnotationType(TypeElement annotationType, List<AnnotationMirror> mirrors) {
        this.checkConstraints(annotationType, mirrors);
        return null;
    }

    @Override
    public Void visitTypeAsClass(TypeElement e, List<AnnotationMirror> p) {
        this.checkConstraints(e, p);
        return null;
    }

    @Override
    public Void visitTypeAsEnum(TypeElement e, List<AnnotationMirror> p) {
        this.checkConstraints(e, p);
        return null;
    }

    @Override
    public Void visitTypeAsInterface(TypeElement e, List<AnnotationMirror> p) {
        this.checkConstraints(e, p);
        return null;
    }

    private void checkConstraints(Element annotatedElement, List<AnnotationMirror> mirrors) {
        for (AnnotationMirror oneAnnotationMirror : mirrors) {
            try {
                ConstraintChecks constraintChecks = this.constraintCheckFactory.getConstraintChecks(annotatedElement, oneAnnotationMirror);
                this.reportIssues(constraintChecks.execute(annotatedElement, oneAnnotationMirror));
            }
            catch (Exception e) {
                if (!this.verbose) continue;
                this.messager.getDelegate().printMessage(Diagnostic.Kind.NOTE, e.getMessage() != null ? e.getMessage() : e.toString(), annotatedElement, oneAnnotationMirror);
            }
        }
    }
}

