/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.ap.classchecks;

import java.util.Collection;
import java.util.Collections;
import javax.lang.model.element.Element;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.hibernate.validator.ap.classchecks.ClassCheck;
import org.hibernate.validator.ap.classchecks.ParametersMethodOverrideCheck;
import org.hibernate.validator.ap.classchecks.ReturnValueMethodOverrideCheck;
import org.hibernate.validator.ap.util.CollectionHelper;
import org.hibernate.validator.ap.util.ConstraintHelper;

public class ClassCheckFactory {
    private final Collection<ClassCheck> methodChecks = CollectionHelper.newArrayList();

    public ClassCheckFactory(Types typeUtils, Elements elementUtils, ConstraintHelper constraintHelper) {
        this.methodChecks.add(new ReturnValueMethodOverrideCheck(elementUtils, typeUtils, constraintHelper));
        this.methodChecks.add(new ParametersMethodOverrideCheck(elementUtils, typeUtils, constraintHelper));
    }

    public static ClassCheckFactory getInstance(Types typeUtils, Elements elementUtils, ConstraintHelper constraintHelper) {
        return new ClassCheckFactory(typeUtils, elementUtils, constraintHelper);
    }

    public Collection<ClassCheck> getClassChecks(Element element) {
        switch (element.getKind()) {
            case METHOD: {
                return this.methodChecks;
            }
        }
        return Collections.emptySet();
    }
}

