/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.ap.util;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.ResourceBundle;
import javax.annotation.processing.Messager;
import javax.tools.Diagnostic;
import org.hibernate.validator.ap.checks.ConstraintCheckIssue;

public class MessagerAdapter {
    private final ResourceBundle errorMessages;
    private final Messager messager;
    private final Diagnostic.Kind diagnosticKind;

    public MessagerAdapter(Messager messager, Diagnostic.Kind diagnosticKind) {
        this.messager = messager;
        this.diagnosticKind = diagnosticKind;
        this.errorMessages = ResourceBundle.getBundle("org.hibernate.validator.ap.ValidationProcessorMessages");
    }

    public Messager getDelegate() {
        return this.messager;
    }

    public void reportErrors(Collection<ConstraintCheckIssue> errors) {
        for (ConstraintCheckIssue error : errors) {
            this.reportError(error);
        }
    }

    private void reportError(ConstraintCheckIssue error) {
        this.report(error, this.diagnosticKind);
    }

    public void reportWarnings(Collection<ConstraintCheckIssue> warnings) {
        for (ConstraintCheckIssue warning : warnings) {
            this.reportWarning(warning);
        }
    }

    private void reportWarning(ConstraintCheckIssue warning) {
        this.report(warning, Diagnostic.Kind.WARNING);
    }

    private void report(ConstraintCheckIssue issue, Diagnostic.Kind kind) {
        String message = this.errorMessages.getString(issue.getMessageKey());
        if (issue.getMessageParameters() != null) {
            message = MessageFormat.format(message, issue.getMessageParameters());
        }
        this.messager.printMessage(kind, message, issue.getElement(), issue.getAnnotationMirror());
    }
}

