/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.ap.checks.annotationparameters;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import org.hibernate.validator.ap.checks.ConstraintCheckIssue;
import org.hibernate.validator.ap.checks.annotationparameters.AnnotationParametersAbstractCheck;
import org.hibernate.validator.ap.util.AnnotationApiHelper;
import org.hibernate.validator.ap.util.CollectionHelper;
import org.hibernate.validator.ap.util.ConstraintHelper;

public class GroupSequenceCheck
extends AnnotationParametersAbstractCheck {
    private Types typeUtils;
    private final ConstraintHelper constraintHelper;

    public GroupSequenceCheck(AnnotationApiHelper annotationApiHelper, Types typeUtils, ConstraintHelper constraintHelper) {
        super(annotationApiHelper, "javax.validation.GroupSequence");
        this.typeUtils = typeUtils;
        this.constraintHelper = constraintHelper;
    }

    @Override
    protected Set<ConstraintCheckIssue> doCheck(Element element, AnnotationMirror annotation) {
        ConstraintCheckIssue cyclicDefinitionIssue;
        List<? extends AnnotationValue> annotationValue = this.annotationApiHelper.getAnnotationArrayValue(annotation, "value");
        TypeElement annotatedElement = (TypeElement)element;
        boolean isDefaultGroupSequenceRedefinition = false;
        HashSet qualifiedNames = CollectionHelper.newHashSet();
        HashSet<ConstraintCheckIssue> issues = CollectionHelper.newHashSet();
        for (AnnotationValue annotationValue2 : annotationValue) {
            TypeMirror typeMirror = (TypeMirror)annotationValue2.getValue();
            if (this.annotationApiHelper.isClass(typeMirror) && this.redefinesDefaultGroupSequence(annotatedElement, typeMirror)) {
                isDefaultGroupSequenceRedefinition = true;
            } else if (!this.annotationApiHelper.isInterface(typeMirror)) {
                issues.add(ConstraintCheckIssue.error(element, annotation, "INVALID_GROUP_SEQUENCE_VALUE_NOT_INTERFACES", new Object[0]));
                continue;
            }
            String qualifiedName = ((TypeElement)this.typeUtils.asElement(typeMirror)).getQualifiedName().toString();
            if (qualifiedNames.contains(qualifiedName)) {
                issues.add(ConstraintCheckIssue.error(element, annotation, "INVALID_GROUP_SEQUENCE_VALUE_MULTIPLE_DECLARATIONS_OF_THE_SAME_INTERFACE", qualifiedName));
            }
            qualifiedNames.add(qualifiedName);
        }
        if (ElementKind.INTERFACE.equals((Object)annotatedElement.getKind()) && !annotatedElement.getInterfaces().isEmpty()) {
            issues.add(ConstraintCheckIssue.warning(element, annotation, "INVALID_GROUP_SEQUENCE_EXTEND_INTERFACES", new Object[0]));
        }
        if (ElementKind.CLASS.equals((Object)annotatedElement.getKind()) && !isDefaultGroupSequenceRedefinition) {
            issues.add(ConstraintCheckIssue.error(element, annotation, "INVALID_GROUP_SEQUENCE_VALUE_MISSING_HOSTING_BEAN_DECLARATION", new Object[0]));
        }
        if ((cyclicDefinitionIssue = this.checkForCyclicDefinition(CollectionHelper.<TypeMirror>newHashSet(), annotatedElement.asType(), annotatedElement, annotation)) != null) {
            issues.add(cyclicDefinitionIssue);
        }
        return issues;
    }

    private ConstraintCheckIssue checkForCyclicDefinition(Set<TypeMirror> processedTypes, TypeMirror currentTypeMirror, TypeElement originalElement, AnnotationMirror annotation) {
        if (processedTypes.contains(currentTypeMirror)) {
            if (!this.redefinesDefaultGroupSequence(originalElement, currentTypeMirror)) {
                return ConstraintCheckIssue.error(originalElement, annotation, "INVALID_GROUP_SEQUENCE_VALUE_CYCLIC_DEFINITION", new Object[0]);
            }
            return null;
        }
        processedTypes.add(currentTypeMirror);
        AnnotationMirror groupSequenceMirror = this.getGroupSequence(currentTypeMirror);
        List<? extends AnnotationValue> annotationValue = this.annotationApiHelper.getAnnotationArrayValue(groupSequenceMirror, "value");
        if (annotationValue != null) {
            for (AnnotationValue annotationValue2 : annotationValue) {
                TypeMirror groupTypeMirror = (TypeMirror)annotationValue2.getValue();
                ConstraintCheckIssue issue = this.checkForCyclicDefinition(processedTypes, groupTypeMirror, originalElement, annotation);
                if (issue == null) continue;
                return issue;
            }
        }
        return null;
    }

    private AnnotationMirror getGroupSequence(TypeMirror typeMirror) {
        if (TypeKind.DECLARED.equals((Object)typeMirror.getKind())) {
            for (AnnotationMirror annotationMirror : this.typeUtils.asElement(typeMirror).getAnnotationMirrors()) {
                if (!ConstraintHelper.AnnotationType.GROUP_SEQUENCE_ANNOTATION.equals((Object)this.constraintHelper.getAnnotationType(annotationMirror))) continue;
                return annotationMirror;
            }
        }
        return null;
    }

    private boolean redefinesDefaultGroupSequence(TypeElement annotatedElement, TypeMirror typeMirror) {
        return ElementKind.CLASS.equals((Object)annotatedElement.getKind()) && this.typeUtils.isSameType(annotatedElement.asType(), typeMirror);
    }
}

