/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.ap.util;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.SimpleAnnotationValueVisitor6;
import javax.lang.model.util.TypeKindVisitor6;
import javax.lang.model.util.Types;
import org.hibernate.validator.ap.util.AnnotationApiHelper;
import org.hibernate.validator.ap.util.CollectionHelper;

public class ConstraintHelper {
    private Map<Name, Set<TypeMirror>> builtInConstraints;
    private Types typeUtils;
    private AnnotationApiHelper annotationApiHelper;

    public ConstraintHelper(Types typeUtils, AnnotationApiHelper annotationApiHelper) {
        this.typeUtils = typeUtils;
        this.annotationApiHelper = annotationApiHelper;
        this.builtInConstraints = CollectionHelper.newHashMap();
        this.registerAllowedTypesForBuiltInConstraint("javax.validation.constraints.AssertFalse", Boolean.class);
        this.registerAllowedTypesForBuiltInConstraint("javax.validation.constraints.AssertTrue", Boolean.class);
        this.registerAllowedTypesForBuiltInConstraint("javax.validation.constraints.DecimalMax", Number.class, String.class);
        this.registerAllowedTypesForBuiltInConstraint("javax.validation.constraints.DecimalMin", Number.class, String.class);
        this.registerAllowedTypesForBuiltInConstraint("javax.validation.constraints.Digits", Number.class, String.class);
        this.registerAllowedTypesForBuiltInConstraint("javax.validation.constraints.Future", Calendar.class, Date.class);
        this.registerAllowedTypesForBuiltInConstraintByNames("javax.validation.constraints.Future", "org.joda.time.ReadablePartial", "org.joda.time.ReadableInstant");
        this.registerAllowedTypesForBuiltInConstraint("javax.validation.constraints.Max", Number.class, String.class);
        this.registerAllowedTypesForBuiltInConstraint("javax.validation.constraints.Min", Number.class, String.class);
        this.registerAllowedTypesForBuiltInConstraint("javax.validation.constraints.NotNull", Object.class);
        this.registerAllowedTypesForBuiltInConstraint("javax.validation.constraints.Null", Object.class);
        this.registerAllowedTypesForBuiltInConstraint("javax.validation.constraints.Past", Calendar.class, Date.class);
        this.registerAllowedTypesForBuiltInConstraintByNames("javax.validation.constraints.Past", "org.joda.time.ReadablePartial", "org.joda.time.ReadableInstant");
        this.registerAllowedTypesForBuiltInConstraint("javax.validation.constraints.Pattern", String.class);
        this.registerAllowedTypesForBuiltInConstraint("javax.validation.constraints.Size", Object[].class, boolean[].class, byte[].class, char[].class, double[].class, float[].class, int[].class, long[].class, short[].class, Collection.class, Map.class, String.class);
        this.registerAllowedTypesForBuiltInConstraint("org.hibernate.validator.constraints.Email", CharSequence.class);
        this.registerAllowedTypesForBuiltInConstraint("org.hibernate.validator.constraints.Length", CharSequence.class);
        this.registerAllowedTypesForBuiltInConstraint("org.hibernate.validator.constraints.ModCheck", CharSequence.class);
        this.registerAllowedTypesForBuiltInConstraint("org.hibernate.validator.constraints.NotBlank", CharSequence.class);
        this.registerAllowedTypesForBuiltInConstraint("org.hibernate.validator.constraints.SafeHtml", CharSequence.class);
        this.registerAllowedTypesForBuiltInConstraint("org.hibernate.validator.constraints.ScriptAssert", Object.class);
        this.registerAllowedTypesForBuiltInConstraint("org.hibernate.validator.constraints.URL", CharSequence.class);
    }

    public boolean isConstraintAnnotation(Element element) {
        return this.annotationApiHelper.getMirror(element.getAnnotationMirrors(), "javax.validation.Constraint") != null;
    }

    public AnnotationType getAnnotationType(AnnotationMirror annotationMirror) {
        if (this.isConstraintAnnotation(annotationMirror)) {
            return AnnotationType.CONSTRAINT_ANNOTATION;
        }
        if (this.isMultiValuedConstraint(annotationMirror)) {
            return AnnotationType.MULTI_VALUED_CONSTRAINT_ANNOTATION;
        }
        if (this.isGraphValidationAnnotation(annotationMirror)) {
            return AnnotationType.GRAPH_VALIDATION_ANNOTATION;
        }
        if (this.isConstraintMetaAnnotation(annotationMirror)) {
            return AnnotationType.CONSTRAINT_META_ANNOTATION;
        }
        if (this.isGroupSequenceProviderAnnotation(annotationMirror)) {
            return AnnotationType.GROUP_SEQUENCE_PROVIDER_ANNOTATION;
        }
        return AnnotationType.NO_CONSTRAINT_ANNOTATION;
    }

    public List<AnnotationMirror> getPartsOfMultiValuedConstraint(AnnotationMirror annotationMirror) {
        final ArrayList<AnnotationMirror> theValue = CollectionHelper.newArrayList();
        for (AnnotationValue annotationValue : this.annotationApiHelper.getAnnotationArrayValue(annotationMirror, "value")) {
            annotationValue.accept(new SimpleAnnotationValueVisitor6<Void, Void>(){

                @Override
                public Void visitAnnotation(AnnotationMirror a, Void p) {
                    if (ConstraintHelper.this.isConstraintAnnotation(a.getAnnotationType().asElement())) {
                        theValue.add(a);
                    }
                    return null;
                }
            }, null);
        }
        return theValue;
    }

    public ConstraintCheckResult checkConstraint(DeclaredType constraintAnnotationType, TypeMirror typeOfAnnotatedElement) {
        ConstraintCheckResult composingConstraintsCheck = this.checkComposingConstraints(constraintAnnotationType, typeOfAnnotatedElement);
        if (composingConstraintsCheck != ConstraintCheckResult.ALLOWED) {
            return composingConstraintsCheck;
        }
        return this.checkSupportedTypes(constraintAnnotationType, typeOfAnnotatedElement);
    }

    public boolean isComposedConstraint(TypeElement element) {
        return Boolean.TRUE.equals(element.asType().accept(new TypeKindVisitor6<Boolean, Void>(){

            @Override
            public Boolean visitDeclared(DeclaredType constraintValidatorImplementation, Void p) {
                return !ConstraintHelper.this.getComposingConstraints(constraintValidatorImplementation).isEmpty();
            }
        }, null));
    }

    private boolean isConstraintAnnotation(AnnotationMirror annotationMirror) {
        return this.isConstraintAnnotation(annotationMirror.getAnnotationType().asElement());
    }

    private boolean isConstraintMetaAnnotation(AnnotationMirror annotationMirror) {
        return this.getName(annotationMirror.getAnnotationType()).contentEquals("javax.validation.Constraint");
    }

    private boolean isMultiValuedConstraint(AnnotationMirror annotationMirror) {
        List<? extends AnnotationValue> annotationArrayValue = this.annotationApiHelper.getAnnotationArrayValue(annotationMirror, "value");
        if (annotationArrayValue.isEmpty()) {
            return false;
        }
        for (AnnotationValue annotationValue : annotationArrayValue) {
            Boolean isConstraintAnnotation = annotationValue.accept(new SimpleAnnotationValueVisitor6<Boolean, Void>(){

                @Override
                public Boolean visitAnnotation(AnnotationMirror a, Void p) {
                    return ConstraintHelper.this.isConstraintAnnotation(a.getAnnotationType().asElement());
                }
            }, null);
            if (Boolean.TRUE == isConstraintAnnotation) continue;
            return false;
        }
        return true;
    }

    private boolean isGraphValidationAnnotation(AnnotationMirror annotationMirror) {
        return this.getName(annotationMirror.getAnnotationType()).contentEquals("javax.validation.Valid");
    }

    private boolean isGroupSequenceProviderAnnotation(AnnotationMirror annotationMirror) {
        return this.getName(annotationMirror.getAnnotationType()).contentEquals("org.hibernate.validator.group.GroupSequenceProvider");
    }

    private ConstraintCheckResult checkComposingConstraints(DeclaredType constraintAnnotationType, TypeMirror typeOfAnnotatedElement) {
        for (AnnotationMirror oneComposingConstraint : this.getComposingConstraints(constraintAnnotationType)) {
            ConstraintCheckResult annotationCheckResult = this.checkConstraint(oneComposingConstraint.getAnnotationType(), typeOfAnnotatedElement);
            if (annotationCheckResult == ConstraintCheckResult.ALLOWED) continue;
            return annotationCheckResult;
        }
        return ConstraintCheckResult.ALLOWED;
    }

    private ConstraintCheckResult checkSupportedTypes(DeclaredType constraintAnnotationType, TypeMirror typeOfAnnotatedElement) {
        Set<TypeMirror> supportedTypes = this.getSupportedTypes(constraintAnnotationType);
        Set<TypeMirror> assignableTypes = this.getAssignableTypes(supportedTypes, typeOfAnnotatedElement);
        if (assignableTypes.size() > 1) {
            return ConstraintCheckResult.MULTIPLE_VALIDATORS_FOUND;
        }
        if (assignableTypes.size() == 1 || supportedTypes.size() == 0 && !this.getComposingConstraints(constraintAnnotationType).isEmpty()) {
            return ConstraintCheckResult.ALLOWED;
        }
        return ConstraintCheckResult.DISALLOWED;
    }

    private Set<TypeMirror> getSupportedTypes(DeclaredType constraintAnnotationType) {
        if (this.isBuiltInConstraint(constraintAnnotationType)) {
            return this.getSupportedTypesForBuiltInConstraint(constraintAnnotationType);
        }
        return this.getSupportedTypesForCustomConstraint(constraintAnnotationType);
    }

    private Set<TypeMirror> getSupportedTypesForBuiltInConstraint(DeclaredType annotation) {
        Name key = this.getName(annotation);
        Set<TypeMirror> allowedTypes = this.builtInConstraints.get(key);
        if (allowedTypes == null) {
            allowedTypes = CollectionHelper.newHashSet();
            this.builtInConstraints.put(key, allowedTypes);
        }
        return allowedTypes;
    }

    private Set<TypeMirror> getSupportedTypesForCustomConstraint(DeclaredType constraintAnnotationType) {
        AnnotationMirror constraintMetaAnnotation = this.getConstraintMetaAnnotation(constraintAnnotationType);
        List<? extends AnnotationValue> validatorClassReferences = this.getValidatorClassesFromConstraintMetaAnnotation(constraintMetaAnnotation);
        HashSet<TypeMirror> supportedTypes = CollectionHelper.newHashSet();
        for (AnnotationValue annotationValue : validatorClassReferences) {
            TypeMirror supportedType = this.getSupportedType(annotationValue);
            supportedTypes.add(supportedType);
        }
        return supportedTypes;
    }

    private TypeMirror getSupportedType(AnnotationValue oneValidatorClassReference) {
        TypeMirror validatorType = oneValidatorClassReference.accept(new SimpleAnnotationValueVisitor6<TypeMirror, Void>(){

            @Override
            public TypeMirror visitType(TypeMirror t, Void p) {
                return t;
            }
        }, null);
        TypeMirror constraintValidatorImplementation = this.getConstraintValidatorSuperType(validatorType);
        return constraintValidatorImplementation.accept(new TypeKindVisitor6<TypeMirror, Void>(){

            @Override
            public TypeMirror visitDeclared(DeclaredType constraintValidatorImplementation, Void p) {
                return constraintValidatorImplementation.getTypeArguments().get(1);
            }
        }, null);
    }

    private TypeMirror getConstraintValidatorSuperType(TypeMirror type) {
        List<? extends TypeMirror> superTypes = this.typeUtils.directSupertypes(type);
        ArrayList nextSuperTypes = CollectionHelper.newArrayList();
        while (!superTypes.isEmpty()) {
            for (TypeMirror typeMirror : superTypes) {
                if (this.getName(this.typeUtils.asElement(typeMirror)).contentEquals("javax.validation.ConstraintValidator")) {
                    return typeMirror;
                }
                nextSuperTypes.addAll(this.typeUtils.directSupertypes(typeMirror));
            }
            superTypes = nextSuperTypes;
            nextSuperTypes = CollectionHelper.newArrayList();
        }
        throw new IllegalStateException("Expected type " + type + " to implement javax.validation.ConstraintValidator, but it doesn't.");
    }

    private AnnotationMirror getConstraintMetaAnnotation(DeclaredType annotationType) {
        List<? extends AnnotationMirror> annotationMirrors = annotationType.asElement().getAnnotationMirrors();
        AnnotationMirror constraintMetaAnnotation = this.annotationApiHelper.getMirror(annotationMirrors, "javax.validation.Constraint");
        if (constraintMetaAnnotation == null) {
            throw new IllegalArgumentException("Given type " + annotationType + " isn't a constraint annotation type.");
        }
        return constraintMetaAnnotation;
    }

    private List<? extends AnnotationValue> getValidatorClassesFromConstraintMetaAnnotation(AnnotationMirror constraintMetaAnnotation) {
        AnnotationValue validatedBy = this.annotationApiHelper.getAnnotationValue(constraintMetaAnnotation, "validatedBy");
        return validatedBy.accept(new SimpleAnnotationValueVisitor6<List<? extends AnnotationValue>, Void>(){

            @Override
            public List<? extends AnnotationValue> visitArray(List<? extends AnnotationValue> values, Void p) {
                return values;
            }
        }, null);
    }

    private Set<TypeMirror> getAssignableTypes(Set<TypeMirror> types, TypeMirror type) {
        HashSet<TypeMirror> theValue = CollectionHelper.newHashSet();
        for (TypeMirror supportedType : types) {
            if (!this.typeUtils.isAssignable(type, supportedType)) continue;
            theValue.add(supportedType);
        }
        return this.annotationApiHelper.keepLowestTypePerHierarchy(theValue);
    }

    private void registerAllowedTypesForBuiltInConstraint(String annotationType, Class<?> ... allowedTypes) {
        DeclaredType annotation = this.annotationApiHelper.getDeclaredTypeByName(annotationType);
        if (annotation == null) {
            return;
        }
        Set<TypeMirror> allowedTypesForConstraint = this.getSupportedTypesForBuiltInConstraint(annotation);
        for (Class<?> oneAllowedType : allowedTypes) {
            TypeMirror mirrorForType = this.annotationApiHelper.getMirrorForType(oneAllowedType);
            if (mirrorForType == null) continue;
            allowedTypesForConstraint.add(mirrorForType);
        }
    }

    private void registerAllowedTypesForBuiltInConstraintByNames(String annotationType, String ... allowedTypes) {
        DeclaredType annotation = this.annotationApiHelper.getDeclaredTypeByName(annotationType);
        if (annotation == null) {
            return;
        }
        Set<TypeMirror> allowedTypesForConstraint = this.getSupportedTypesForBuiltInConstraint(annotation);
        for (String oneAllowedType : allowedTypes) {
            DeclaredType mirrorForType = this.annotationApiHelper.getDeclaredTypeByName(oneAllowedType);
            if (mirrorForType == null) continue;
            allowedTypesForConstraint.add(mirrorForType);
        }
    }

    private boolean isBuiltInConstraint(DeclaredType constraintAnnotationType) {
        return this.builtInConstraints.containsKey(this.getName(constraintAnnotationType));
    }

    private Name getName(DeclaredType type) {
        return this.getName(type.asElement());
    }

    private Name getName(Element element) {
        if (element.getKind() == ElementKind.CLASS || element.getKind() == ElementKind.INTERFACE || element.getKind() == ElementKind.ANNOTATION_TYPE) {
            return ((TypeElement)element).getQualifiedName();
        }
        return element.getSimpleName();
    }

    private Set<AnnotationMirror> getComposingConstraints(DeclaredType constraintAnnotationType) {
        HashSet<AnnotationMirror> theValue = CollectionHelper.newHashSet();
        List<? extends AnnotationMirror> annotationMirrors = constraintAnnotationType.asElement().getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            if (this.isConstraintAnnotation(annotationMirror.getAnnotationType().asElement())) {
                theValue.add(annotationMirror);
                continue;
            }
            if (!this.isMultiValuedConstraint(annotationMirror)) continue;
            List<? extends AnnotationValue> value = this.annotationApiHelper.getAnnotationArrayValue(annotationMirror, "value");
            for (AnnotationValue annotationValue : value) {
                theValue.add((AnnotationMirror)((Object)annotationValue));
            }
        }
        return theValue;
    }

    public static enum AnnotationType {
        CONSTRAINT_ANNOTATION,
        MULTI_VALUED_CONSTRAINT_ANNOTATION,
        GRAPH_VALIDATION_ANNOTATION,
        CONSTRAINT_META_ANNOTATION,
        GROUP_SEQUENCE_PROVIDER_ANNOTATION,
        NO_CONSTRAINT_ANNOTATION;

    }

    public static enum ConstraintCheckResult {
        ALLOWED,
        DISALLOWED,
        MULTIPLE_VALIDATORS_FOUND;

    }
}

