/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.ap;

import java.util.List;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementKindVisitor6;
import javax.tools.Diagnostic;
import org.hibernate.validator.ap.checks.ConstraintCheckError;
import org.hibernate.validator.ap.checks.ConstraintCheckFactory;
import org.hibernate.validator.ap.checks.ConstraintChecks;
import org.hibernate.validator.ap.util.AnnotationApiHelper;
import org.hibernate.validator.ap.util.Configuration;
import org.hibernate.validator.ap.util.ConstraintHelper;
import org.hibernate.validator.ap.util.MessagerAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ConstraintAnnotationVisitor
extends ElementKindVisitor6<Void, List<AnnotationMirror>> {
    private final MessagerAdapter messager;
    private final ConstraintCheckFactory constraintCheckFactory;
    private final boolean verbose;

    public ConstraintAnnotationVisitor(ProcessingEnvironment processingEnvironment, MessagerAdapter messager, Configuration configuration) {
        this.messager = messager;
        this.verbose = configuration.isVerbose();
        AnnotationApiHelper annotationApiHelper = new AnnotationApiHelper(processingEnvironment.getElementUtils(), processingEnvironment.getTypeUtils());
        ConstraintHelper constraintHelper = new ConstraintHelper(processingEnvironment.getTypeUtils(), annotationApiHelper);
        this.constraintCheckFactory = new ConstraintCheckFactory(processingEnvironment.getTypeUtils(), constraintHelper, annotationApiHelper, configuration.methodConstraintsSupported());
    }

    @Override
    public Void visitExecutableAsMethod(ExecutableElement method, List<AnnotationMirror> mirrors) {
        this.checkConstraints(method, mirrors);
        return null;
    }

    @Override
    public Void visitVariableAsField(VariableElement annotatedField, List<AnnotationMirror> mirrors) {
        this.checkConstraints(annotatedField, mirrors);
        return null;
    }

    @Override
    public Void visitTypeAsAnnotationType(TypeElement annotationType, List<AnnotationMirror> mirrors) {
        this.checkConstraints(annotationType, mirrors);
        return null;
    }

    @Override
    public Void visitTypeAsClass(TypeElement e, List<AnnotationMirror> p) {
        this.checkConstraints(e, p);
        return null;
    }

    @Override
    public Void visitTypeAsEnum(TypeElement e, List<AnnotationMirror> p) {
        this.checkConstraints(e, p);
        return null;
    }

    @Override
    public Void visitTypeAsInterface(TypeElement e, List<AnnotationMirror> p) {
        this.checkConstraints(e, p);
        return null;
    }

    private void checkConstraints(Element annotatedElement, List<AnnotationMirror> mirrors) {
        for (AnnotationMirror oneAnnotationMirror : mirrors) {
            try {
                ConstraintChecks constraintChecks = this.constraintCheckFactory.getConstraintChecks(annotatedElement, oneAnnotationMirror);
                Set<ConstraintCheckError> errors = constraintChecks.execute(annotatedElement, oneAnnotationMirror);
                this.messager.reportErrors(errors);
            }
            catch (Exception e) {
                if (!this.verbose) continue;
                this.messager.getDelegate().printMessage(Diagnostic.Kind.NOTE, e.getMessage(), annotatedElement, oneAnnotationMirror);
            }
        }
    }
}

