/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.ap.util;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.Name;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleAnnotationValueVisitor6;
import javax.lang.model.util.TypeKindVisitor6;
import javax.lang.model.util.Types;
import javax.validation.Constraint;
import javax.validation.ConstraintValidator;
import javax.validation.Valid;
import javax.validation.constraints.AssertFalse;
import javax.validation.constraints.AssertTrue;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Digits;
import javax.validation.constraints.Future;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import javax.validation.constraints.Past;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.hibernate.validator.ap.util.AnnotationApiHelper;
import org.hibernate.validator.ap.util.CollectionHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstraintHelper {
    private final Name CONSTRAINT_ANNOTATION_PACKAGE_NAME;
    private static Map<Name, Set<TypeMirror>> builtInConstraints;
    private Elements elementUtils;
    private Types typeUtils;
    private AnnotationApiHelper annotationApiHelper;

    public ConstraintHelper(Elements elementUtils, Types typeUtils, AnnotationApiHelper annotationApiHelper) {
        this.elementUtils = elementUtils;
        this.typeUtils = typeUtils;
        this.annotationApiHelper = annotationApiHelper;
        this.CONSTRAINT_ANNOTATION_PACKAGE_NAME = elementUtils.getName(Size.class.getPackage().getName());
        builtInConstraints = CollectionHelper.newHashMap();
        this.registerAllowedTypesForBuiltInConstraint(AssertFalse.class, CollectionHelper.asSet(Boolean.class));
        this.registerAllowedTypesForBuiltInConstraint(AssertTrue.class, CollectionHelper.asSet(Boolean.class));
        this.registerAllowedTypesForBuiltInConstraint(DecimalMax.class, CollectionHelper.asSet(Number.class, String.class));
        this.registerAllowedTypesForBuiltInConstraint(DecimalMin.class, CollectionHelper.asSet(Number.class, String.class));
        this.registerAllowedTypesForBuiltInConstraint(Digits.class, CollectionHelper.asSet(Number.class, String.class));
        this.registerAllowedTypesForBuiltInConstraint(Future.class, CollectionHelper.asSet(Calendar.class, Date.class));
        this.registerAllowedTypesForBuiltInConstraint(Max.class, CollectionHelper.asSet(Number.class, String.class));
        this.registerAllowedTypesForBuiltInConstraint(Min.class, CollectionHelper.asSet(Number.class, String.class));
        this.registerAllowedTypesForBuiltInConstraint(NotNull.class, CollectionHelper.asSet(Object.class));
        this.registerAllowedTypesForBuiltInConstraint(Null.class, CollectionHelper.asSet(Object.class));
        this.registerAllowedTypesForBuiltInConstraint(Past.class, CollectionHelper.asSet(Calendar.class, Date.class));
        this.registerAllowedTypesForBuiltInConstraint(Pattern.class, CollectionHelper.asSet(String.class));
        this.registerAllowedTypesForBuiltInConstraint(Size.class, CollectionHelper.asSet(Object[].class, boolean[].class, byte[].class, char[].class, double[].class, float[].class, int[].class, long[].class, short[].class, Collection.class, Map.class, String.class));
    }

    public boolean isConstraintAnnotation(Element element) {
        return element.getAnnotation(Constraint.class) != null;
    }

    public AnnotationType getAnnotationType(AnnotationMirror annotationMirror) {
        if (this.isConstraintAnnotation(annotationMirror)) {
            return AnnotationType.CONSTRAINT_ANNOTATION;
        }
        if (this.isMultiValuedConstraint(annotationMirror)) {
            return AnnotationType.MULTI_VALUED_CONSTRAINT_ANNOTATION;
        }
        if (this.isGraphValidationAnnotation(annotationMirror)) {
            return AnnotationType.GRAPH_VALIDATION_ANNOTATION;
        }
        return AnnotationType.NO_CONSTRAINT_ANNOTATION;
    }

    public List<AnnotationMirror> getPartsOfMultiValuedConstraint(AnnotationMirror annotationMirror) {
        final ArrayList<AnnotationMirror> theValue = CollectionHelper.newArrayList();
        for (AnnotationValue annotationValue : this.annotationApiHelper.getAnnotationArrayValue(annotationMirror, "value")) {
            annotationValue.accept(new SimpleAnnotationValueVisitor6<Void, Void>(){

                @Override
                public Void visitAnnotation(AnnotationMirror a, Void p) {
                    if (ConstraintHelper.this.isConstraintAnnotation(a.getAnnotationType().asElement())) {
                        theValue.add(a);
                    }
                    return null;
                }
            }, null);
        }
        return theValue;
    }

    public ConstraintCheckResult checkConstraint(DeclaredType constraintAnnotationType, TypeMirror typeOfAnnotatedElement) {
        return this.isBuiltInConstraint(constraintAnnotationType) ? this.checkBuiltInConstraint(constraintAnnotationType, typeOfAnnotatedElement) : this.checkCustomConstraint(constraintAnnotationType, typeOfAnnotatedElement);
    }

    private boolean isConstraintAnnotation(AnnotationMirror annotationMirror) {
        return this.isConstraintAnnotation(annotationMirror.getAnnotationType().asElement());
    }

    private boolean isMultiValuedConstraint(AnnotationMirror annotationMirror) {
        List<? extends AnnotationValue> annotationArrayValue = this.annotationApiHelper.getAnnotationArrayValue(annotationMirror, "value");
        if (annotationArrayValue.isEmpty()) {
            return false;
        }
        for (AnnotationValue annotationValue : annotationArrayValue) {
            Boolean isConstraintAnnotation = annotationValue.accept(new SimpleAnnotationValueVisitor6<Boolean, Void>(){

                @Override
                public Boolean visitAnnotation(AnnotationMirror a, Void p) {
                    return ConstraintHelper.this.isConstraintAnnotation(a.getAnnotationType().asElement());
                }
            }, null);
            if (Boolean.TRUE == isConstraintAnnotation) continue;
            return false;
        }
        return true;
    }

    private boolean isGraphValidationAnnotation(AnnotationMirror annotationMirror) {
        return this.typeUtils.isSameType(annotationMirror.getAnnotationType(), this.annotationApiHelper.getMirrorForType(Valid.class));
    }

    private ConstraintCheckResult checkBuiltInConstraint(DeclaredType builtInAnnotationType, TypeMirror typeOfAnnotatedElement) {
        Set<TypeMirror> allowedTypes = this.getAllowedTypesForBuiltInConstraint(builtInAnnotationType);
        for (TypeMirror oneAllowedType : allowedTypes) {
            if (!this.typeUtils.isAssignable(typeOfAnnotatedElement, oneAllowedType)) continue;
            return ConstraintCheckResult.ALLOWED;
        }
        return ConstraintCheckResult.DISALLOWED;
    }

    private Set<TypeMirror> getAllowedTypesForBuiltInConstraint(DeclaredType builtInAnnotationType) {
        Set<TypeMirror> theValue = builtInConstraints.get(builtInAnnotationType.asElement().getSimpleName());
        if (theValue == null) {
            theValue = Collections.emptySet();
        }
        return theValue;
    }

    private ConstraintCheckResult checkCustomConstraint(DeclaredType customAnnotationType, TypeMirror typeOfAnnotatedElement) {
        Set<AnnotationMirror> composingConstraints = this.getComposingConstraints(customAnnotationType);
        boolean isComposedConstraint = !composingConstraints.isEmpty();
        for (AnnotationMirror oneComposingConstraint : composingConstraints) {
            ConstraintCheckResult annotationCheckResult = this.checkConstraint(oneComposingConstraint.getAnnotationType(), typeOfAnnotatedElement);
            if (annotationCheckResult == ConstraintCheckResult.ALLOWED) continue;
            return annotationCheckResult;
        }
        Set<TypeMirror> theValue = this.getSupportedTypes(customAnnotationType, typeOfAnnotatedElement);
        if (theValue.size() > 1) {
            return ConstraintCheckResult.MULTIPLE_VALIDATORS_FOUND;
        }
        if (theValue.size() == 1 || isComposedConstraint) {
            return ConstraintCheckResult.ALLOWED;
        }
        return ConstraintCheckResult.DISALLOWED;
    }

    private Set<TypeMirror> getSupportedTypes(DeclaredType constraintAnnotationType, TypeMirror type) {
        HashSet<TypeMirror> theValue = CollectionHelper.newHashSet();
        AnnotationMirror constraintMetaAnnotation = this.getConstraintMetaAnnotation(constraintAnnotationType);
        List<? extends AnnotationValue> validatorClassReferences = this.getValidatorClassesFromConstraintMetaAnnotation(constraintMetaAnnotation);
        for (AnnotationValue annotationValue : validatorClassReferences) {
            TypeMirror supportedType = this.getSupportedType(annotationValue);
            if (!this.typeUtils.isAssignable(type, supportedType)) continue;
            theValue.add(supportedType);
        }
        return this.annotationApiHelper.keepLowestTypePerHierarchy(theValue);
    }

    private TypeMirror getSupportedType(AnnotationValue oneValidatorClassReference) {
        TypeMirror validatorType = oneValidatorClassReference.accept(new SimpleAnnotationValueVisitor6<TypeMirror, Void>(){

            @Override
            public TypeMirror visitType(TypeMirror t, Void p) {
                return t;
            }
        }, null);
        TypeMirror supportedType = this.getSupportedTypeUsingAnnotationApi(validatorType);
        if (supportedType == null) {
            throw new AssertionError((Object)("Couldn't determine the type supported by validator " + validatorType + "."));
        }
        return supportedType;
    }

    private TypeMirror getSupportedTypeUsingAnnotationApi(TypeMirror validatorType) {
        TypeMirror constraintValidatorImplementation = this.getConstraintValidatorSuperType(validatorType);
        return constraintValidatorImplementation.accept(new TypeKindVisitor6<TypeMirror, Void>(){

            @Override
            public TypeMirror visitDeclared(DeclaredType constraintValidatorImplementation, Void p) {
                return constraintValidatorImplementation.getTypeArguments().get(1);
            }
        }, null);
    }

    private TypeMirror getConstraintValidatorSuperType(TypeMirror type) {
        List<? extends TypeMirror> directSupertypes = this.typeUtils.directSupertypes(type);
        for (TypeMirror typeMirror : directSupertypes) {
            if (!this.typeUtils.asElement(typeMirror).getSimpleName().contentEquals(ConstraintValidator.class.getSimpleName())) continue;
            return typeMirror;
        }
        return null;
    }

    private AnnotationMirror getConstraintMetaAnnotation(DeclaredType annotationType) {
        List<? extends AnnotationMirror> annotationMirrors = annotationType.asElement().getAnnotationMirrors();
        AnnotationMirror constraintMetaAnnotation = this.annotationApiHelper.getMirror(annotationMirrors, Constraint.class);
        if (constraintMetaAnnotation == null) {
            throw new IllegalArgumentException("Given type " + annotationType + " isn't a constraint annotation type.");
        }
        return constraintMetaAnnotation;
    }

    private List<? extends AnnotationValue> getValidatorClassesFromConstraintMetaAnnotation(AnnotationMirror constraintMetaAnnotation) {
        AnnotationValue validatedBy = this.annotationApiHelper.getAnnotationValue(constraintMetaAnnotation, "validatedBy");
        return validatedBy.accept(new SimpleAnnotationValueVisitor6<List<? extends AnnotationValue>, Void>(){

            @Override
            public List<? extends AnnotationValue> visitArray(List<? extends AnnotationValue> values, Void p) {
                return values;
            }
        }, null);
    }

    private void registerAllowedTypesForBuiltInConstraint(Class<? extends Annotation> annotation, Set<Class<?>> allowedTypes) {
        HashSet mirrorsForAllowedTypes = CollectionHelper.newHashSet();
        for (Class<?> oneAllowedType : allowedTypes) {
            if (oneAllowedType.isArray()) {
                mirrorsForAllowedTypes.add(this.typeUtils.getArrayType(this.annotationApiHelper.getMirrorForType(oneAllowedType.getComponentType())));
                continue;
            }
            mirrorsForAllowedTypes.add(this.annotationApiHelper.getMirrorForType(oneAllowedType));
        }
        builtInConstraints.put(this.elementUtils.getName(annotation.getSimpleName()), mirrorsForAllowedTypes);
    }

    private boolean isBuiltInConstraint(DeclaredType constraintAnnotationType) {
        return ((Object)this.CONSTRAINT_ANNOTATION_PACKAGE_NAME).equals(this.elementUtils.getPackageOf(constraintAnnotationType.asElement()).getQualifiedName());
    }

    private Set<AnnotationMirror> getComposingConstraints(DeclaredType constraintAnnotationType) {
        HashSet<AnnotationMirror> theValue = CollectionHelper.newHashSet();
        List<? extends AnnotationMirror> annotationMirrors = constraintAnnotationType.asElement().getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            if (!this.isConstraintAnnotation(annotationMirror.getAnnotationType().asElement())) continue;
            theValue.add(annotationMirror);
        }
        return theValue;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AnnotationType {
        CONSTRAINT_ANNOTATION,
        MULTI_VALUED_CONSTRAINT_ANNOTATION,
        GRAPH_VALIDATION_ANNOTATION,
        NO_CONSTRAINT_ANNOTATION;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ConstraintCheckResult {
        ALLOWED,
        DISALLOWED,
        MULTIPLE_VALIDATORS_FOUND;

    }
}

