/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.ap;

import java.util.List;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.hibernate.validator.ap.ConstraintAnnotationVisitor;
import org.hibernate.validator.ap.util.AnnotationApiHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SupportedAnnotationTypes(value={"*"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
@SupportedOptions(value={"diagnosticKind"})
public class ConstraintValidationProcessor
extends AbstractProcessor {
    private static final boolean ANNOTATIONS_CLAIMED_EXCLUSIVELY = false;

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnvironment) {
        AnnotationApiHelper typeHelper = new AnnotationApiHelper(this.processingEnv.getElementUtils(), this.processingEnv.getTypeUtils());
        ConstraintAnnotationVisitor visitor = new ConstraintAnnotationVisitor(this.processingEnv);
        for (TypeElement typeElement : annotations) {
            Set<? extends Element> elementsWithConstraintAnnotation = roundEnvironment.getElementsAnnotatedWith(typeElement);
            for (Element element : elementsWithConstraintAnnotation) {
                List<AnnotationMirror> mirrorsOfCurrentAnnotation = typeHelper.filterByType(element.getAnnotationMirrors(), typeElement.asType());
                element.accept(visitor, mirrorsOfCurrentAnnotation);
            }
        }
        return false;
    }
}

