/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.ap;

import java.text.MessageFormat;
import java.util.List;
import java.util.ResourceBundle;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementKindVisitor6;
import javax.tools.Diagnostic;
import org.hibernate.validator.ap.util.AnnotationApiHelper;
import org.hibernate.validator.ap.util.ConstraintHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ConstraintAnnotationVisitor
extends ElementKindVisitor6<Void, List<AnnotationMirror>> {
    public static final String DIAGNOSTIC_KIND_PROCESSOR_OPTION_NAME = "diagnosticKind";
    public static final Diagnostic.Kind DEFAULT_DIAGNOSTIC_KIND = Diagnostic.Kind.ERROR;
    private Diagnostic.Kind diagnosticKind;
    private final ProcessingEnvironment processingEnvironment;
    private final ResourceBundle errorMessages;
    private final ConstraintHelper constraintHelper;

    public ConstraintAnnotationVisitor(ProcessingEnvironment processingEnvironment) {
        this.processingEnvironment = processingEnvironment;
        this.errorMessages = ResourceBundle.getBundle("org.hibernate.validator.ap.ValidationProcessorMessages");
        AnnotationApiHelper annotationApiHelper = new AnnotationApiHelper(processingEnvironment.getElementUtils(), processingEnvironment.getTypeUtils());
        this.constraintHelper = new ConstraintHelper(processingEnvironment.getElementUtils(), processingEnvironment.getTypeUtils(), annotationApiHelper);
        this.initializeDiagnosticKind();
    }

    private void initializeDiagnosticKind() {
        String diagnosticKindFromOptions = this.processingEnvironment.getOptions().get(DIAGNOSTIC_KIND_PROCESSOR_OPTION_NAME);
        if (diagnosticKindFromOptions != null) {
            try {
                this.diagnosticKind = Diagnostic.Kind.valueOf(diagnosticKindFromOptions);
            }
            catch (IllegalArgumentException e) {
                this.processingEnvironment.getMessager().printMessage(Diagnostic.Kind.ERROR, MessageFormat.format(this.errorMessages.getString("INVALID_DIAGNOSTIC_KIND_GIVEN"), diagnosticKindFromOptions));
                this.diagnosticKind = DEFAULT_DIAGNOSTIC_KIND;
            }
        } else {
            this.diagnosticKind = DEFAULT_DIAGNOSTIC_KIND;
        }
    }

    @Override
    public Void visitExecutableAsMethod(ExecutableElement method, List<AnnotationMirror> mirrors) {
        block5: for (AnnotationMirror oneAnnotationMirror : mirrors) {
            switch (this.constraintHelper.getAnnotationType(oneAnnotationMirror)) {
                case CONSTRAINT_ANNOTATION: {
                    this.checkConstraintAtMethod(method, oneAnnotationMirror);
                    break;
                }
                case MULTI_VALUED_CONSTRAINT_ANNOTATION: {
                    for (AnnotationMirror onePartOfMultiValuedConstraint : this.constraintHelper.getPartsOfMultiValuedConstraint(oneAnnotationMirror)) {
                        this.checkConstraintAtMethod(method, onePartOfMultiValuedConstraint);
                    }
                    continue block5;
                }
                case GRAPH_VALIDATION_ANNOTATION: {
                    this.checkGraphValidationAnnotationAtMethod(method, oneAnnotationMirror);
                }
            }
        }
        return null;
    }

    @Override
    public Void visitVariableAsField(VariableElement annotatedField, List<AnnotationMirror> mirrors) {
        block5: for (AnnotationMirror oneAnnotationMirror : mirrors) {
            switch (this.constraintHelper.getAnnotationType(oneAnnotationMirror)) {
                case CONSTRAINT_ANNOTATION: {
                    this.checkConstraintAtField(annotatedField, oneAnnotationMirror);
                    break;
                }
                case MULTI_VALUED_CONSTRAINT_ANNOTATION: {
                    for (AnnotationMirror onePartOfMultiValuedConstraint : this.constraintHelper.getPartsOfMultiValuedConstraint(oneAnnotationMirror)) {
                        this.checkConstraintAtField(annotatedField, onePartOfMultiValuedConstraint);
                    }
                    continue block5;
                }
                case GRAPH_VALIDATION_ANNOTATION: {
                    this.checkGraphValidationAnnotationAtField(annotatedField, oneAnnotationMirror);
                }
            }
        }
        return null;
    }

    @Override
    public Void visitTypeAsAnnotationType(TypeElement annotationType, List<AnnotationMirror> mirrors) {
        for (AnnotationMirror oneAnnotationMirror : mirrors) {
            switch (this.constraintHelper.getAnnotationType(oneAnnotationMirror)) {
                case CONSTRAINT_ANNOTATION: {
                    this.checkConstraintAtAnnotationType(annotationType, oneAnnotationMirror);
                    break;
                }
                case MULTI_VALUED_CONSTRAINT_ANNOTATION: {
                    for (AnnotationMirror onePartOfMultiValuedConstraint : this.constraintHelper.getPartsOfMultiValuedConstraint(oneAnnotationMirror)) {
                        this.checkConstraintAtAnnotationType(annotationType, onePartOfMultiValuedConstraint);
                    }
                    break;
                }
            }
        }
        return null;
    }

    @Override
    public Void visitTypeAsClass(TypeElement e, List<AnnotationMirror> p) {
        return this.visitClassOrInterfaceOrEnumType(e, p);
    }

    @Override
    public Void visitTypeAsEnum(TypeElement e, List<AnnotationMirror> p) {
        return this.visitClassOrInterfaceOrEnumType(e, p);
    }

    @Override
    public Void visitTypeAsInterface(TypeElement e, List<AnnotationMirror> p) {
        return this.visitClassOrInterfaceOrEnumType(e, p);
    }

    private Void visitClassOrInterfaceOrEnumType(TypeElement annotatedType, List<AnnotationMirror> mirrors) {
        for (AnnotationMirror oneAnnotationMirror : mirrors) {
            switch (this.constraintHelper.getAnnotationType(oneAnnotationMirror)) {
                case CONSTRAINT_ANNOTATION: {
                    this.checkConstraintAtType(annotatedType, oneAnnotationMirror);
                    break;
                }
                case MULTI_VALUED_CONSTRAINT_ANNOTATION: {
                    for (AnnotationMirror onePartOfMultiValuedConstraint : this.constraintHelper.getPartsOfMultiValuedConstraint(oneAnnotationMirror)) {
                        this.checkConstraintAtType(annotatedType, onePartOfMultiValuedConstraint);
                    }
                    break;
                }
            }
        }
        return null;
    }

    private void checkConstraintAtType(TypeElement annotatedType, AnnotationMirror mirror) {
        if (this.constraintHelper.checkConstraint(mirror.getAnnotationType(), annotatedType.asType()) != ConstraintHelper.ConstraintCheckResult.ALLOWED) {
            this.reportError(annotatedType, mirror, "NOT_SUPPORTED_TYPE", mirror.getAnnotationType().asElement().getSimpleName());
        }
    }

    private void checkConstraintAtField(VariableElement annotatedField, AnnotationMirror annotationMirror) {
        if (this.isStaticElement(annotatedField)) {
            this.reportError(annotatedField, annotationMirror, "STATIC_FIELDS_MAY_NOT_BE_ANNOTATED", new Object[0]);
            return;
        }
        if (this.constraintHelper.checkConstraint(annotationMirror.getAnnotationType(), annotatedField.asType()) != ConstraintHelper.ConstraintCheckResult.ALLOWED) {
            this.reportError(annotatedField, annotationMirror, "NOT_SUPPORTED_TYPE", annotationMirror.getAnnotationType().asElement().getSimpleName());
        }
    }

    private void checkConstraintAtMethod(ExecutableElement method, AnnotationMirror mirror) {
        if (!this.isGetterMethod(method)) {
            this.reportError(method, mirror, "ONLY_GETTERS_MAY_BE_ANNOTATED", new Object[0]);
            return;
        }
        if (this.isStaticElement(method)) {
            this.reportError(method, mirror, "STATIC_METHODS_MAY_NOT_BE_ANNOTATED", new Object[0]);
            return;
        }
        if (this.constraintHelper.checkConstraint(mirror.getAnnotationType(), method.getReturnType()) != ConstraintHelper.ConstraintCheckResult.ALLOWED) {
            this.reportError(method, mirror, "NOT_SUPPORTED_RETURN_TYPE", mirror.getAnnotationType().asElement().getSimpleName());
        }
    }

    private void checkConstraintAtAnnotationType(TypeElement annotationType, AnnotationMirror annotationMirror) {
        if (!this.constraintHelper.isConstraintAnnotation(annotationType)) {
            this.reportError(annotationType, annotationMirror, "ONLY_CONSTRAINT_ANNOTATIONS_MAY_BE_ANNOTATED", new Object[0]);
        }
    }

    private void checkGraphValidationAnnotationAtField(VariableElement annotatedField, AnnotationMirror annotationMirror) {
        if (this.isStaticElement(annotatedField)) {
            this.reportError(annotatedField, annotationMirror, "STATIC_FIELDS_MAY_NOT_BE_ANNOTATED", new Object[0]);
            return;
        }
        if (this.isPrimitiveType(annotatedField.asType())) {
            this.reportError(annotatedField, annotationMirror, "ATVALID_NOT_ALLOWED_AT_PRIMITIVE_FIELD", new Object[0]);
        }
    }

    private void checkGraphValidationAnnotationAtMethod(ExecutableElement method, AnnotationMirror annotationMirror) {
        if (!this.isGetterMethod(method)) {
            this.reportError(method, annotationMirror, "ONLY_GETTERS_MAY_BE_ANNOTATED", new Object[0]);
            return;
        }
        if (this.isStaticElement(method)) {
            this.reportError(method, annotationMirror, "STATIC_METHODS_MAY_NOT_BE_ANNOTATED", new Object[0]);
            return;
        }
        if (this.isPrimitiveType(method.getReturnType())) {
            this.reportError(method, annotationMirror, "ATVALID_NOT_ALLOWED_AT_METHOD_RETURNING_PRIMITIVE_TYPE", new Object[0]);
        }
    }

    private boolean isGetterMethod(ExecutableElement method) {
        return this.isJavaBeanGetterName(method.getSimpleName().toString()) && !this.hasParameters(method) && this.hasReturnValue(method);
    }

    private boolean hasReturnValue(ExecutableElement method) {
        return method.getReturnType().getKind() != TypeKind.VOID;
    }

    private boolean hasParameters(ExecutableElement method) {
        return !method.getParameters().isEmpty();
    }

    private boolean isJavaBeanGetterName(String methodName) {
        return methodName.startsWith("is") || methodName.startsWith("has") || methodName.startsWith("get");
    }

    private boolean isStaticElement(Element element) {
        return element.getModifiers().contains((Object)Modifier.STATIC);
    }

    private boolean isPrimitiveType(TypeMirror typeMirror) {
        return typeMirror.getKind().isPrimitive();
    }

    private void reportError(Element element, AnnotationMirror annotationMirror, String messageKey, Object ... messageParameters) {
        String message = messageParameters == null ? this.errorMessages.getString(messageKey) : MessageFormat.format(this.errorMessages.getString(messageKey), messageParameters);
        this.processingEnvironment.getMessager().printMessage(this.diagnosticKind, message, element, annotationMirror);
    }
}

