/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.internal.metadata;

import java.io.File;
import java.util.Map;
import java.util.Properties;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.registry.BootstrapServiceRegistry;
import org.hibernate.boot.registry.BootstrapServiceRegistryBuilder;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.tool.api.metadata.MetadataDescriptor;

public class NativeMetadataDescriptor
implements MetadataDescriptor {
    private Properties properties = new Properties();
    private MetadataSources metadataSources = null;
    private StandardServiceRegistryBuilder ssrb = null;

    public NativeMetadataDescriptor(File cfgXmlFile, File[] mappingFiles, Properties properties) {
        BootstrapServiceRegistry bsr = new BootstrapServiceRegistryBuilder().build();
        this.ssrb = new StandardServiceRegistryBuilder(bsr);
        if (cfgXmlFile != null) {
            this.ssrb.configure(cfgXmlFile);
        }
        if (properties != null) {
            this.properties.putAll((Map<?, ?>)properties);
        }
        this.ssrb.applySettings((Map)this.getProperties());
        this.metadataSources = new MetadataSources((ServiceRegistry)bsr);
        if (mappingFiles != null) {
            for (File file : mappingFiles) {
                if (file.getName().endsWith(".jar")) {
                    this.metadataSources.addJar(file);
                    continue;
                }
                this.metadataSources.addFile(file);
            }
        }
    }

    @Override
    public Properties getProperties() {
        Properties result = new Properties();
        result.putAll((Map<?, ?>)this.properties);
        return result;
    }

    @Override
    public Metadata createMetadata() {
        return this.metadataSources.buildMetadata(this.ssrb.build());
    }
}

