/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.reveng;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.collections4.MultiValuedMap;
import org.apache.commons.collections4.multimap.HashSetValuedHashMap;
import org.dom4j.Element;
import org.hibernate.cfg.reveng.SimpleMetaAttribute;
import org.hibernate.mapping.MetaAttribute;
import org.hibernate.tool.hbm2x.MetaAttributeHelper;

public class MetaAttributeBinder {
    public static MultiValuedMap<String, SimpleMetaAttribute> mergeMetaMaps(MultiValuedMap<String, SimpleMetaAttribute> specific, MultiValuedMap<String, SimpleMetaAttribute> general) {
        HashSetValuedHashMap result = new HashSetValuedHashMap();
        MetaAttributeHelper.copyMultiMap((MultiValuedMap<String, SimpleMetaAttribute>)result, specific);
        if (general != null) {
            for (String key : general.keySet()) {
                if (specific.containsKey((Object)key)) continue;
                Collection ml = general.get((Object)key);
                for (SimpleMetaAttribute element : ml) {
                    if (!element.inheritable) continue;
                    result.put((Object)key, (Object)element);
                }
            }
        }
        return result;
    }

    public static MetaAttribute toRealMetaAttribute(String name, Collection<SimpleMetaAttribute> values) {
        MetaAttribute attribute = new MetaAttribute(name);
        for (SimpleMetaAttribute element : values) {
            attribute.addValue(element.value);
        }
        return attribute;
    }

    public static MultiValuedMap<String, SimpleMetaAttribute> loadAndMergeMetaMap(Element classElement, MultiValuedMap<String, SimpleMetaAttribute> inheritedMeta) {
        return MetaAttributeBinder.mergeMetaMaps(MetaAttributeBinder.loadMetaMap(classElement), inheritedMeta);
    }

    protected static MultiValuedMap<String, SimpleMetaAttribute> loadMetaMap(Element element) {
        HashSetValuedHashMap result = new HashSetValuedHashMap();
        ArrayList<Element> metaAttributeList = new ArrayList<Element>();
        for (Object obj : element.elements("meta")) {
            metaAttributeList.add((Element)obj);
        }
        for (Element metaAttrib : metaAttributeList) {
            String attribute = metaAttrib.attributeValue("attribute");
            String value = metaAttrib.getText();
            String inheritStr = metaAttrib.attributeValue("inherit");
            boolean inherit = true;
            if (inheritStr != null) {
                inherit = Boolean.valueOf(inheritStr);
            }
            SimpleMetaAttribute ma = new SimpleMetaAttribute(value, inherit);
            result.put((Object)attribute, (Object)ma);
        }
        return result;
    }
}

