/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.util.Map;
import org.dom4j.Element;
import org.hibernate.MappingException;
import org.hibernate.SessionFactory;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.internal.ClassLoaderAccessImpl;
import org.hibernate.boot.internal.InFlightMetadataCollectorImpl;
import org.hibernate.boot.internal.MetadataBuilderImpl;
import org.hibernate.boot.internal.MetadataBuildingContextRootImpl;
import org.hibernate.boot.model.TypeContributions;
import org.hibernate.boot.model.TypeContributor;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.spi.BasicTypeRegistration;
import org.hibernate.boot.spi.ClassLoaderAccess;
import org.hibernate.boot.spi.InFlightMetadataCollector;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.boot.spi.MetadataBuildingOptions;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.JDBCBinder;
import org.hibernate.cfg.reveng.DefaultReverseEngineeringStrategy;
import org.hibernate.cfg.reveng.ReverseEngineeringStrategy;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.id.factory.IdentifierGeneratorFactory;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.type.BasicType;
import org.hibernate.type.BasicTypeRegistry;
import org.hibernate.type.Type;
import org.hibernate.type.TypeFactory;
import org.hibernate.type.TypeResolver;
import org.hibernate.usertype.CompositeUserType;
import org.hibernate.usertype.UserType;
import org.jboss.logging.Logger;

public class JDBCMetaDataConfiguration
extends Configuration {
    private static final Logger log = Logger.getLogger(JDBCMetaDataConfiguration.class);
    private ReverseEngineeringStrategy revEngStrategy = new DefaultReverseEngineeringStrategy();
    private StandardServiceRegistry serviceRegistry = null;
    private InFlightMetadataCollectorImpl metadataCollector;
    private ClassLoaderAccess classLoaderAccess = null;
    private MetadataBuildingOptions metadataBuildingOptions = null;
    private MetadataBuildingContext metadataBuildingContext = null;
    private Metadata metadata = null;
    private boolean ignoreconfigxmlmapppings = true;
    private boolean preferBasicCompositeIds = true;

    public Metadata getMetadata() {
        if (this.metadata == null) {
            this.metadata = this.getMetadataCollector().buildMetadataInstance(this.getMetadataBuildingContext());
        }
        return this.metadata;
    }

    private MetadataBuildingOptions getMetadataBuildingOptions() {
        if (this.metadataBuildingOptions == null) {
            this.metadataBuildingOptions = new MetadataBuilderImpl.MetadataBuildingOptionsImpl(this.getServiceRegistry());
        }
        return this.metadataBuildingOptions;
    }

    private ClassLoaderAccess getClassLoaderAccess() {
        if (this.classLoaderAccess == null) {
            MetadataBuildingOptions options = this.getMetadataBuildingOptions();
            ClassLoaderService classLoaderService = (ClassLoaderService)options.getServiceRegistry().getService(ClassLoaderService.class);
            this.classLoaderAccess = new ClassLoaderAccessImpl(options.getTempClassLoader(), classLoaderService);
        }
        return this.classLoaderAccess;
    }

    private InFlightMetadataCollectorImpl getMetadataCollector() {
        if (this.metadataCollector == null) {
            MetadataBuildingOptions options = this.getMetadataBuildingOptions();
            BasicTypeRegistry basicTypeRegistry = JDBCMetaDataConfiguration.handleTypes(options);
            this.metadataCollector = new InFlightMetadataCollectorImpl(options, new TypeResolver(basicTypeRegistry, new TypeFactory()));
        }
        return this.metadataCollector;
    }

    private MetadataBuildingContext getMetadataBuildingContext() {
        if (this.metadataBuildingContext == null) {
            this.metadataBuildingContext = new MetadataBuildingContextRootImpl(this.getMetadataBuildingOptions(), this.getClassLoaderAccess(), (InFlightMetadataCollector)this.getMetadataCollector());
        }
        return this.metadataBuildingContext;
    }

    public StandardServiceRegistry getServiceRegistry() {
        if (this.serviceRegistry == null) {
            this.serviceRegistry = new StandardServiceRegistryBuilder().applySettings((Map)this.getProperties()).build();
        }
        return this.serviceRegistry;
    }

    public void readFromJDBC() {
        JDBCBinder binder = new JDBCBinder((ServiceRegistry)this.getServiceRegistry(), this.getProperties(), this.getMetadataBuildingContext(), this.getReverseEngineeringStrategy(), this.preferBasicCompositeIds());
        binder.readFromDatabase(null, null, JDBCMetaDataConfiguration.buildMapping(this.getMetadata()));
    }

    public SessionFactory buildSessionFactory() {
        return this.getMetadata().buildSessionFactory();
    }

    private static Mapping buildMapping(final Metadata metadata) {
        return new Mapping(){

            public Type getIdentifierType(String persistentClass) throws MappingException {
                PersistentClass pc = metadata.getEntityBinding(persistentClass);
                if (pc == null) {
                    throw new MappingException("persistent class not known: " + persistentClass);
                }
                return pc.getIdentifier().getType();
            }

            public String getIdentifierPropertyName(String persistentClass) throws MappingException {
                PersistentClass pc = metadata.getEntityBinding(persistentClass);
                if (pc == null) {
                    throw new MappingException("persistent class not known: " + persistentClass);
                }
                if (!pc.hasIdentifierProperty()) {
                    return null;
                }
                return pc.getIdentifierProperty().getName();
            }

            public Type getReferencedPropertyType(String persistentClass, String propertyName) throws MappingException {
                PersistentClass pc = metadata.getEntityBinding(persistentClass);
                if (pc == null) {
                    throw new MappingException("persistent class not known: " + persistentClass);
                }
                Property prop = pc.getProperty(propertyName);
                if (prop == null) {
                    throw new MappingException("property not known: " + persistentClass + '.' + propertyName);
                }
                return prop.getType();
            }

            public IdentifierGeneratorFactory getIdentifierGeneratorFactory() {
                return null;
            }
        };
    }

    public boolean preferBasicCompositeIds() {
        return this.preferBasicCompositeIds;
    }

    public void setPreferBasicCompositeIds(boolean flag) {
        this.preferBasicCompositeIds = flag;
    }

    protected void parseMappingElement(Element subelement, String name) {
        if (this.ignoreconfigxmlmapppings) {
            log.info((Object)("Ignoring " + name + " mapping"));
        }
    }

    public void setReverseEngineeringStrategy(ReverseEngineeringStrategy reverseEngineeringStrategy) {
        this.revEngStrategy = reverseEngineeringStrategy;
    }

    public ReverseEngineeringStrategy getReverseEngineeringStrategy() {
        return this.revEngStrategy;
    }

    private static BasicTypeRegistry handleTypes(MetadataBuildingOptions options) {
        ClassLoaderService classLoaderService = (ClassLoaderService)options.getServiceRegistry().getService(ClassLoaderService.class);
        final BasicTypeRegistry basicTypeRegistry = new BasicTypeRegistry();
        TypeContributions typeContributions = new TypeContributions(){

            public void contributeType(BasicType type) {
                basicTypeRegistry.register(type);
            }

            public void contributeType(BasicType type, String ... keys) {
                basicTypeRegistry.register(type, keys);
            }

            public void contributeType(UserType type, String ... keys) {
                basicTypeRegistry.register(type, keys);
            }

            public void contributeType(CompositeUserType type, String ... keys) {
                basicTypeRegistry.register(type, keys);
            }
        };
        Dialect dialect = ((JdbcServices)options.getServiceRegistry().getService(JdbcServices.class)).getDialect();
        dialect.contributeTypes(typeContributions, (ServiceRegistry)options.getServiceRegistry());
        for (TypeContributor contributor : classLoaderService.loadJavaServices(TypeContributor.class)) {
            contributor.contribute(typeContributions, (ServiceRegistry)options.getServiceRegistry());
        }
        for (BasicTypeRegistration basicTypeRegistration : options.getBasicTypeRegistrations()) {
            basicTypeRegistry.register(basicTypeRegistration.getBasicType(), basicTypeRegistration.getRegistrationKeys());
        }
        return basicTypeRegistry;
    }
}

