/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.jdbc.leak;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.MySQL5Dialect;
import org.hibernate.testing.jdbc.leak.IdleConnectionCounter;

public class MySQLIdleConnectionCounter
implements IdleConnectionCounter {
    public static final IdleConnectionCounter INSTANCE = new MySQLIdleConnectionCounter();

    @Override
    public boolean appliesTo(Class<? extends Dialect> dialect) {
        return MySQL5Dialect.class.isAssignableFrom(dialect);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public int count(Connection connection) {
        try (Statement statement = connection.createStatement();){
            int n;
            block15: {
                ResultSet resultSet = statement.executeQuery("SHOW PROCESSLIST");
                try {
                    int count = 0;
                    while (resultSet.next()) {
                        String state = resultSet.getString("command");
                        if (!"sleep".equalsIgnoreCase(state)) continue;
                        ++count;
                    }
                    n = count;
                    if (resultSet == null) break block15;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return n;
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
    }
}

