/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.orm.domain.gambit;

import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import org.hibernate.annotations.LazyCollection;
import org.hibernate.annotations.LazyCollectionOption;
import org.hibernate.annotations.SortComparator;
import org.hibernate.annotations.SortNatural;
import org.hibernate.testing.orm.domain.gambit.EnumValue;
import org.hibernate.testing.orm.domain.gambit.EnumValueConverter;
import org.hibernate.testing.orm.domain.gambit.SimpleBasicSortComparator;
import org.hibernate.testing.orm.domain.gambit.SimpleComponent;
import org.hibernate.testing.orm.domain.gambit.SimpleEntity;

@Entity
@Table(name="entity_containing_sets")
public class EntityOfSets {
    @Id
    private Integer id;
    private String name;
    @ElementCollection
    @CollectionTable(name="EntityOfSet_basic1")
    @Column(name="basic_val")
    private Set<String> setOfBasics;
    @ElementCollection
    @CollectionTable(name="EntityOfSet_basic2")
    @Column(name="basic_val")
    private SortedSet<String> sortedSetOfBasicsWithSortNaturalByDefault;
    @ElementCollection
    @CollectionTable(name="EntityOfSet_basic3")
    @SortNatural
    @Column(name="basic_val")
    private SortedSet<String> sortedSetOfBasics;
    @ElementCollection
    @CollectionTable(name="EntityOfSet_basic4")
    @SortComparator(value=SimpleBasicSortComparator.class)
    @Column(name="basic_val")
    private SortedSet<String> sortedSetOfBasicsWithComparator;
    @ElementCollection
    @CollectionTable(name="EntityOfSet_basic5")
    @OrderBy(value="")
    @Column(name="basic_val")
    private Set<String> orderedSetOfBasics;
    @ElementCollection
    @Enumerated(value=EnumType.STRING)
    @CollectionTable(name="EntityOfSet_enum1")
    @Column(name="enum_val")
    private Set<EnumValue> setOfEnums;
    @ElementCollection
    @Convert(converter=EnumValueConverter.class)
    @CollectionTable(name="EntityOfSet_enum2")
    @Column(name="enum_val")
    private Set<EnumValue> setOfConvertedEnums;
    @ElementCollection
    @CollectionTable(name="EntityOfSet_comp1")
    private Set<SimpleComponent> setOfComponents;
    @ElementCollection
    @LazyCollection(value=LazyCollectionOption.EXTRA)
    @CollectionTable(name="EntityOfSet_comp2")
    private Set<SimpleComponent> extraLazySetOfComponents;
    @OneToMany
    @CollectionTable(name="EntityOfSet_o2m")
    private Set<SimpleEntity> setOfOneToMany;
    @ManyToMany
    @CollectionTable(name="EntityOfSet_m2m")
    private Set<SimpleEntity> setOfManyToMany;

    public EntityOfSets() {
    }

    public EntityOfSets(Integer id, String name) {
        this.id = id;
        this.name = name;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Set<String> getSetOfBasics() {
        return this.setOfBasics;
    }

    public void setSetOfBasics(Set<String> setOfBasics) {
        this.setOfBasics = setOfBasics;
    }

    public void addBasic(String value) {
        if (this.setOfBasics == null) {
            this.setOfBasics = new HashSet<String>();
        }
        this.setOfBasics.add(value);
    }

    public Set<String> getOrderedSetOfBasics() {
        return this.orderedSetOfBasics;
    }

    public void setOrderedSetOfBasics(Set<String> orderedSetOfBasics) {
        this.orderedSetOfBasics = orderedSetOfBasics;
    }

    public void addOrderedBasic(String value) {
        if (this.orderedSetOfBasics == null) {
            this.orderedSetOfBasics = new TreeSet<String>();
        }
        this.orderedSetOfBasics.add(value);
    }

    public SortedSet<String> getSortedSetOfBasics() {
        return this.sortedSetOfBasics;
    }

    public void setSortedSetOfBasics(SortedSet<String> sortedSetOfBasics) {
        this.sortedSetOfBasics = sortedSetOfBasics;
    }

    public void addSortedBasic(String value) {
        if (this.sortedSetOfBasics == null) {
            this.sortedSetOfBasics = new TreeSet<String>();
        }
        this.sortedSetOfBasics.add(value);
    }

    public SortedSet<String> getSortedSetOfBasicsWithComparator() {
        return this.sortedSetOfBasicsWithComparator;
    }

    public void setSortedSetOfBasicsWithComparator(SortedSet<String> sortedSetOfBasicsWithComparator) {
        this.sortedSetOfBasicsWithComparator = sortedSetOfBasicsWithComparator;
    }

    public void addSortedBasicWithComparator(String value) {
        if (this.sortedSetOfBasicsWithComparator == null) {
            this.sortedSetOfBasicsWithComparator = new TreeSet<String>();
        }
        this.sortedSetOfBasicsWithComparator.add(value);
    }

    public SortedSet<String> getSortedSetOfBasicsWithSortNaturalByDefault() {
        return this.sortedSetOfBasicsWithSortNaturalByDefault;
    }

    public void setSortedSetOfBasicsWithSortNaturalByDefault(SortedSet<String> sortedSetOfBasicsWithSortNaturalByDefault) {
        this.sortedSetOfBasicsWithSortNaturalByDefault = sortedSetOfBasicsWithSortNaturalByDefault;
    }

    public void addSortedBasicWithSortNaturalByDefault(String value) {
        if (this.sortedSetOfBasicsWithSortNaturalByDefault == null) {
            this.sortedSetOfBasicsWithSortNaturalByDefault = new TreeSet<String>();
        }
        this.sortedSetOfBasicsWithSortNaturalByDefault.add(value);
    }

    public Set<EnumValue> getSetOfConvertedEnums() {
        return this.setOfConvertedEnums;
    }

    public void setSetOfConvertedEnums(Set<EnumValue> setOfConvertedEnums) {
        this.setOfConvertedEnums = setOfConvertedEnums;
    }

    public void addConvertedEnum(EnumValue value) {
        if (this.setOfConvertedEnums == null) {
            this.setOfConvertedEnums = new HashSet<EnumValue>();
        }
        this.setOfConvertedEnums.add(value);
    }

    public Set<EnumValue> getSetOfEnums() {
        return this.setOfEnums;
    }

    public void setSetOfEnums(Set<EnumValue> setOfEnums) {
        this.setOfEnums = setOfEnums;
    }

    public void addEnum(EnumValue value) {
        if (this.setOfEnums == null) {
            this.setOfEnums = new HashSet<EnumValue>();
        }
        this.setOfEnums.add(value);
    }

    public Set<SimpleComponent> getSetOfComponents() {
        return this.setOfComponents;
    }

    public void setSetOfComponents(Set<SimpleComponent> setOfComponents) {
        this.setOfComponents = setOfComponents;
    }

    public void addComponent(SimpleComponent value) {
        if (this.setOfComponents == null) {
            this.setOfComponents = new HashSet<SimpleComponent>();
        }
        this.setOfComponents.add(value);
    }

    public Set<SimpleComponent> getExtraLazySetOfComponents() {
        return this.extraLazySetOfComponents;
    }

    public void setExtraLazySetOfComponents(Set<SimpleComponent> extraLazySetOfComponents) {
        this.extraLazySetOfComponents = extraLazySetOfComponents;
    }

    public void addExtraLazyComponent(SimpleComponent value) {
        if (this.extraLazySetOfComponents == null) {
            this.extraLazySetOfComponents = new HashSet<SimpleComponent>();
        }
        this.extraLazySetOfComponents.add(value);
    }

    public Set<SimpleEntity> getSetOfOneToMany() {
        return this.setOfOneToMany;
    }

    public void setSetOfOneToMany(Set<SimpleEntity> setOfOneToMany) {
        this.setOfOneToMany = setOfOneToMany;
    }

    public void addOneToMany(SimpleEntity value) {
        if (this.setOfOneToMany == null) {
            this.setOfOneToMany = new HashSet<SimpleEntity>();
        }
        this.setOfOneToMany.add(value);
    }

    public Set<SimpleEntity> getSetOfManyToMany() {
        return this.setOfManyToMany;
    }

    public void setSetOfManyToMany(Set<SimpleEntity> setOfManyToMany) {
        this.setOfManyToMany = setOfManyToMany;
    }

    public void addManyToMany(SimpleEntity value) {
        if (this.setOfManyToMany == null) {
            this.setOfManyToMany = new HashSet<SimpleEntity>();
        }
        this.setOfManyToMany.add(value);
    }
}

