/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.bytecode.enhancement;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Arrays;
import org.hibernate.LockMode;
import org.hibernate.engine.internal.MutableEntityEntryFactory;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.SelfDirtinessTracker;
import org.hibernate.engine.spi.Status;
import org.hibernate.testing.junit4.BaseUnitTestCase;
import org.junit.Assert;

public abstract class EnhancerTestUtils
extends BaseUnitTestCase {
    public static Object getFieldByReflection(Object entity, String fieldName) {
        try {
            Field field = entity.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            return field.get(entity);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            Assert.fail((String)("Fail to get field '" + fieldName + "' in entity " + entity + ": " + e.getMessage()));
            return null;
        }
    }

    public static void clearDirtyTracking(Object entityInstance) {
        ((SelfDirtinessTracker)entityInstance).$$_hibernate_clearDirtyAttributes();
    }

    public static void checkDirtyTracking(Object entityInstance, String ... dirtyFields) {
        SelfDirtinessTracker selfDirtinessTracker = (SelfDirtinessTracker)entityInstance;
        Assert.assertEquals((Object)(dirtyFields.length > 0 ? 1 : 0), (Object)selfDirtinessTracker.$$_hibernate_hasDirtyAttributes());
        String[] tracked = selfDirtinessTracker.$$_hibernate_getDirtyAttributes();
        Assert.assertEquals((long)dirtyFields.length, (long)tracked.length);
        Assert.assertTrue((boolean)Arrays.asList(tracked).containsAll(Arrays.asList(dirtyFields)));
    }

    public static EntityEntry makeEntityEntry() {
        return MutableEntityEntryFactory.INSTANCE.createEntityEntry(Status.MANAGED, null, null, (Serializable)Integer.valueOf(1), null, LockMode.NONE, false, null, false, null);
    }
}

