/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.cache;

import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.CacheDataDescription;
import org.hibernate.cache.spi.NaturalIdRegion;
import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.cache.spi.access.NaturalIdRegionAccessStrategy;
import org.hibernate.testing.cache.BaseTransactionalDataRegion;
import org.hibernate.testing.cache.CachingRegionFactory;
import org.hibernate.testing.cache.NonstrictReadWriteNaturalIdRegionAccessStrategy;
import org.hibernate.testing.cache.ReadOnlyNaturalIdRegionAccessStrategy;
import org.hibernate.testing.cache.ReadWriteNaturalIdRegionAccessStrategy;
import org.hibernate.testing.cache.TransactionalNaturalIdRegionAccessStrategy;
import org.jboss.logging.Logger;

class NaturalIdRegionImpl
extends BaseTransactionalDataRegion
implements NaturalIdRegion {
    private static final Logger LOG = Logger.getLogger((String)NaturalIdRegionImpl.class.getName());
    private final SessionFactoryOptions settings;

    NaturalIdRegionImpl(CachingRegionFactory cachingRegionFactory, String name, CacheDataDescription metadata, SessionFactoryOptions settings) {
        super(cachingRegionFactory, name, metadata);
        this.settings = settings;
    }

    public SessionFactoryOptions getSettings() {
        return this.settings;
    }

    public NaturalIdRegionAccessStrategy buildAccessStrategy(AccessType accessType) throws CacheException {
        switch (accessType) {
            case READ_ONLY: {
                if (this.getCacheDataDescription().isMutable()) {
                    LOG.warnf("read-only cache configured for mutable collection [ %s ]", (Object)this.getName());
                }
                return new ReadOnlyNaturalIdRegionAccessStrategy(this);
            }
            case READ_WRITE: {
                return new ReadWriteNaturalIdRegionAccessStrategy(this);
            }
            case NONSTRICT_READ_WRITE: {
                return new NonstrictReadWriteNaturalIdRegionAccessStrategy(this);
            }
            case TRANSACTIONAL: {
                return new TransactionalNaturalIdRegionAccessStrategy(this);
            }
        }
        throw new IllegalArgumentException("unrecognized access strategy type [" + accessType + "]");
    }
}

