/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.cache;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.Region;
import org.hibernate.testing.cache.CachingRegionFactory;
import org.hibernate.testing.cache.Timestamper;

public class BaseRegion
implements Region {
    private final CachingRegionFactory cachingRegionFactory;
    private final String name;
    protected final Map cache = new ConcurrentHashMap();
    private static int timeout = 245760000;

    BaseRegion(CachingRegionFactory cachingRegionFactory, String name) {
        this.cachingRegionFactory = cachingRegionFactory;
        this.name = name;
    }

    public CachingRegionFactory getRegionFactory() {
        return this.cachingRegionFactory;
    }

    public String getName() {
        return this.name;
    }

    public boolean contains(Object key) {
        return key != null ? this.cache.containsKey(key) : false;
    }

    public void destroy() throws CacheException {
        this.cache.clear();
    }

    public long getSizeInMemory() {
        return -1L;
    }

    public long getElementCountInMemory() {
        return this.cache.size();
    }

    public long getElementCountOnDisk() {
        return 0L;
    }

    public Map toMap() {
        return Collections.unmodifiableMap(this.cache);
    }

    public long nextTimestamp() {
        return Timestamper.next();
    }

    public int getTimeout() {
        return timeout;
    }

    public Map getDataMap() {
        return this.cache;
    }
}

