/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.jdbc;

import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.testing.jdbc.PreparedStatementObserver;

public class BasicPreparedStatementObserver
implements PreparedStatementObserver {
    private final Map<PreparedStatement, String> sqlByPreparedStatement = new LinkedHashMap<PreparedStatement, String>();

    @Override
    public void preparedStatementCreated(PreparedStatement preparedStatement, String sql) {
        this.sqlByPreparedStatement.put(preparedStatement, sql);
    }

    @Override
    public void preparedStatementMethodInvoked(PreparedStatement preparedStatement, Method method, Object[] args, Object invocationReturnValue) {
    }

    @Override
    public PreparedStatement getPreparedStatement(String sql) {
        List<PreparedStatement> preparedStatements = this.getPreparedStatements(sql);
        if (preparedStatements.isEmpty()) {
            throw new IllegalArgumentException("There is no PreparedStatement for this SQL statement " + sql);
        }
        if (preparedStatements.size() > 1) {
            throw new IllegalArgumentException("There are " + preparedStatements.size() + " PreparedStatements for this SQL statement " + sql);
        }
        return preparedStatements.get(0);
    }

    @Override
    public List<PreparedStatement> getPreparedStatements(String sql) {
        ArrayList<PreparedStatement> preparedStatements = new ArrayList<PreparedStatement>();
        for (Map.Entry<PreparedStatement, String> entry : this.sqlByPreparedStatement.entrySet()) {
            if (!entry.getValue().equals(sql)) continue;
            preparedStatements.add(entry.getKey());
        }
        return preparedStatements;
    }

    @Override
    public List<PreparedStatement> getPreparedStatements() {
        return new ArrayList<PreparedStatement>(this.sqlByPreparedStatement.keySet());
    }

    @Override
    public void connectionProviderStopped() {
        this.clear();
    }

    @Override
    public void clear() {
        this.sqlByPreparedStatement.clear();
    }
}

