/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.junit4;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.sql.Types;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;

public final class ExtraAssertions {
    private static Map<Integer, String> jdbcTypeCodeMap;

    private ExtraAssertions() {
    }

    public static void assertClassAssignability(Class expected, Class actual) {
        if (!expected.isAssignableFrom(actual)) {
            Assert.fail((String)("Expected class [" + expected.getName() + "] was not assignable from actual [" + actual.getName() + "]"));
        }
    }

    public static <T> T assertTyping(Class<T> expectedType, Object value) {
        if (!expectedType.isInstance(value)) {
            Assert.fail((String)String.format("Expecting value of type [%s], but found [%s]", expectedType.getName(), value == null ? "<null>" : value));
        }
        return (T)value;
    }

    public static void assertJdbcTypeCode(int expected, int actual) {
        if (expected != actual) {
            String message = String.format("JDBC type codes did not match...\nExpected: %s (%s)\nActual  : %s (%s)", ExtraAssertions.jdbcTypeCodeMap().get(expected), expected, ExtraAssertions.jdbcTypeCodeMap().get(actual), actual);
            Assert.fail((String)message);
        }
    }

    private static synchronized Map<Integer, String> jdbcTypeCodeMap() {
        if (jdbcTypeCodeMap == null) {
            jdbcTypeCodeMap = ExtraAssertions.generateJdbcTypeCache();
        }
        return jdbcTypeCodeMap;
    }

    private static Map generateJdbcTypeCache() {
        Field[] fields = Types.class.getFields();
        HashMap<Object, String> cache = new HashMap<Object, String>((int)((double)fields.length * 0.75) + 1);
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            if (!Modifier.isStatic(field.getModifiers())) continue;
            try {
                cache.put(field.get(null), field.getName());
                continue;
            }
            catch (Throwable ignore) {
                // empty catch block
            }
        }
        return cache;
    }
}

