/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.dialect.sqlserver;

import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.codec.db.sqlserver.Decoders;
import org.geolatte.geom.codec.db.sqlserver.Encoders;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.sql.BasicBinder;
import org.hibernate.type.descriptor.sql.BasicExtractor;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptor;

public class SqlServer2008GeometryTypeDescriptor
implements SqlTypeDescriptor {
    public static final SqlServer2008GeometryTypeDescriptor INSTANCE = new SqlServer2008GeometryTypeDescriptor();

    public int getSqlType() {
        return 2003;
    }

    public boolean canBeRemapped() {
        return false;
    }

    public <X> ValueBinder<X> getBinder(JavaTypeDescriptor<X> javaTypeDescriptor) {
        return new BasicBinder<X>(javaTypeDescriptor, this){

            protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                Geometry geometry = (Geometry)this.getJavaDescriptor().unwrap(value, Geometry.class, options);
                byte[] bytes = Encoders.encode((Geometry)geometry);
                st.setObject(index, bytes);
            }

            protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                Geometry geometry = (Geometry)this.getJavaDescriptor().unwrap(value, Geometry.class, options);
                byte[] bytes = Encoders.encode((Geometry)geometry);
                st.setObject(name, (Object)bytes);
            }
        };
    }

    public <X> ValueExtractor<X> getExtractor(JavaTypeDescriptor<X> javaTypeDescriptor) {
        return new BasicExtractor<X>(javaTypeDescriptor, this){

            protected X doExtract(ResultSet rs, String name, WrapperOptions options) throws SQLException {
                return this.getJavaDescriptor().wrap((Object)SqlServer2008GeometryTypeDescriptor.this.toGeometry(rs.getObject(name)), options);
            }

            protected X doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
                return this.getJavaDescriptor().wrap((Object)SqlServer2008GeometryTypeDescriptor.this.toGeometry(statement.getObject(index)), options);
            }

            protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                return this.getJavaDescriptor().wrap((Object)SqlServer2008GeometryTypeDescriptor.this.toGeometry(statement.getObject(name)), options);
            }
        };
    }

    private Geometry toGeometry(Object obj) {
        byte[] raw = null;
        if (obj == null) {
            return null;
        }
        if (obj instanceof byte[]) {
            raw = (byte[])obj;
        } else if (obj instanceof Blob) {
            raw = this.toByteArray((Blob)obj);
        } else {
            throw new IllegalArgumentException("Expected byte array or BLOB");
        }
        return Decoders.decode((byte[])raw);
    }

    private byte[] toByteArray(Blob blob) {
        try {
            return blob.getBytes(1L, (int)blob.length());
        }
        catch (SQLException e) {
            throw new RuntimeException("Error on transforming blob into array.", e);
        }
    }
}

