/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.dialect.mysql;

import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.boot.model.TypeContributions;
import org.hibernate.dialect.MySQL8Dialect;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.spatial.SpatialDialect;
import org.hibernate.spatial.SpatialFunction;
import org.hibernate.spatial.dialect.mysql.MySQL8SpatialFunctions;
import org.hibernate.spatial.dialect.mysql.MySQLGeometryTypeDescriptor;
import org.hibernate.spatial.dialect.mysql.MySQLSpatialDialect;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptor;

public class MySQL8SpatialDialect
extends MySQL8Dialect
implements SpatialDialect {
    private MySQLSpatialDialect dialectDelegate = new MySQLSpatialDialect();
    private MySQL8SpatialFunctions spatialFunctions = new MySQL8SpatialFunctions();

    public MySQL8SpatialDialect() {
        this.registerColumnType(MySQLGeometryTypeDescriptor.INSTANCE.getSqlType(), "GEOMETRY");
        for (Map.Entry<String, SQLFunction> entry : this.spatialFunctions) {
            this.registerFunction(entry.getKey(), entry.getValue());
        }
    }

    public void contributeTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        this.dialectDelegate.contributeTypes(typeContributions, serviceRegistry);
    }

    @Override
    public String getSpatialRelateSQL(String columnName, int spatialRelation) {
        switch (spatialRelation) {
            case 4: {
                return " ST_within(" + columnName + ",?)";
            }
            case 6: {
                return " ST_contains(" + columnName + ", ?)";
            }
            case 3: {
                return " ST_crosses(" + columnName + ", ?)";
            }
            case 5: {
                return " ST_overlaps(" + columnName + ", ?)";
            }
            case 1: {
                return " ST_disjoint(" + columnName + ", ?)";
            }
            case 7: {
                return " ST_intersects(" + columnName + ", ?)";
            }
            case 2: {
                return " ST_touches(" + columnName + ", ?)";
            }
            case 0: {
                return " ST_equals(" + columnName + ", ?)";
            }
        }
        throw new IllegalArgumentException("Spatial relation is not known by this dialect");
    }

    public String getTypeName(int code, long length, int precision, int scale) throws HibernateException {
        return this.dialectDelegate.getTypeName(code, length, precision, scale);
    }

    public SqlTypeDescriptor remapSqlTypeDescriptor(SqlTypeDescriptor sqlTypeDescriptor) {
        return this.dialectDelegate.remapSqlTypeDescriptor(sqlTypeDescriptor);
    }

    @Override
    public String getSpatialFilterExpression(String columnName) {
        return this.dialectDelegate.getSpatialFilterExpression(columnName);
    }

    @Override
    public String getSpatialAggregateSQL(String columnName, int aggregation) {
        return this.dialectDelegate.getSpatialAggregateSQL(columnName, aggregation);
    }

    @Override
    public String getDWithinSQL(String columnName) {
        return this.dialectDelegate.getDWithinSQL(columnName);
    }

    @Override
    public String getHavingSridSQL(String columnName) {
        return " (ST_SRID(" + columnName + ") = ?) ";
    }

    @Override
    public String getIsEmptySQL(String columnName, boolean isEmpty) {
        String emptyExpr = " ST_IsEmpty(" + columnName + ") ";
        return isEmpty ? emptyExpr : "( NOT " + emptyExpr + ")";
    }

    @Override
    public boolean supportsFiltering() {
        return true;
    }

    @Override
    public boolean supports(SpatialFunction function) {
        return this.spatialFunctions.get(function.toString()) != null;
    }
}

