/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.criterion;

import com.vividsolutions.jts.geom.Geometry;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.criterion.CriteriaQuery;
import org.hibernate.criterion.Criterion;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.TypedValue;
import org.hibernate.spatial.SpatialDialect;

public class SpatialRelateExpression
implements Criterion {
    private static final long serialVersionUID = 1L;
    private String propertyName;
    private Geometry value;
    private int spatialRelation = -1;

    public SpatialRelateExpression(String propertyName, Geometry value, int spatialRelation) {
        this.propertyName = propertyName;
        this.spatialRelation = spatialRelation;
        this.value = value;
    }

    public TypedValue[] getTypedValues(Criteria criteria, CriteriaQuery criteriaQuery) throws HibernateException {
        return new TypedValue[]{criteriaQuery.getTypedValue(criteria, this.propertyName, (Object)this.value)};
    }

    public String toSqlString(Criteria criteria, CriteriaQuery criteriaQuery) throws HibernateException {
        SessionFactoryImplementor factory = criteriaQuery.getFactory();
        String[] columns = criteriaQuery.getColumnsUsingProjection(criteria, this.propertyName);
        Dialect dialect = factory.getDialect();
        if (dialect instanceof SpatialDialect) {
            SpatialDialect seDialect = (SpatialDialect)dialect;
            return seDialect.getSpatialRelateSQL(columns[0], this.spatialRelation);
        }
        throw new IllegalStateException("Dialect must be spatially enabled dialect");
    }
}

