/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.dialect.oracle;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Struct;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.codec.db.oracle.Decoders;
import org.geolatte.geom.codec.db.oracle.SDOGeometry;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.sql.BasicExtractor;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptor;

public class SDOGeometryValueExtractor<X>
extends BasicExtractor<X> {
    public SDOGeometryValueExtractor(JavaTypeDescriptor<X> javaDescriptor, SqlTypeDescriptor sqlTypeDescriptor) {
        super(javaDescriptor, sqlTypeDescriptor);
    }

    protected X doExtract(ResultSet rs, String name, WrapperOptions options) throws SQLException {
        Object geomObj = rs.getObject(name);
        return (X)this.getJavaDescriptor().wrap((Object)this.convert(geomObj), options);
    }

    protected X doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
        Object geomObj = statement.getObject(index);
        return (X)this.getJavaDescriptor().wrap((Object)this.convert(geomObj), options);
    }

    protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
        Object geomObj = statement.getObject(name);
        return (X)this.getJavaDescriptor().wrap((Object)this.convert(geomObj), options);
    }

    public Geometry convert(Object struct) {
        if (struct == null) {
            return null;
        }
        SDOGeometry sdogeom = SDOGeometry.load((Struct)((Struct)struct));
        return this.toGeomerty(sdogeom);
    }

    private Geometry toGeomerty(SDOGeometry sdoGeom) {
        return Decoders.decode((SDOGeometry)sdoGeom);
    }
}

