/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.dialect.hana;

import org.hibernate.boot.model.TypeContributions;
import org.hibernate.dialect.HANAColumnStoreDialect;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.spatial.GeolatteGeometryType;
import org.hibernate.spatial.JTSGeometryType;
import org.hibernate.spatial.SpatialDialect;
import org.hibernate.spatial.SpatialFunction;
import org.hibernate.spatial.dialect.hana.HANAGeometryTypeDescriptor;
import org.hibernate.spatial.dialect.hana.HANAPointTypeDescriptor;
import org.hibernate.spatial.dialect.hana.HANASpatialAggregate;
import org.hibernate.spatial.dialect.hana.HANASpatialFunction;
import org.hibernate.type.BasicType;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;

public class HANASpatialDialect
extends HANAColumnStoreDialect
implements SpatialDialect {
    private static final long serialVersionUID = -432631517465714911L;
    private static final String DETERMINE_CRS_ID_FROM_DATABASE_PARAMETER_NAME = "hibernate.spatial.dialect.hana.determine_crs_id_from_database";

    public HANASpatialDialect() {
        this.registerColumnType(HANAGeometryTypeDescriptor.INSTANCE.getSqlType(), "ST_GEOMETRY");
        this.registerColumnType(HANAPointTypeDescriptor.INSTANCE.getSqlType(), "ST_POINT");
        this.registerFunction(SpatialFunction.asbinary.name(), (SQLFunction)new HANASpatialFunction("ST_AsBinary", (Type)StandardBasicTypes.MATERIALIZED_BLOB, false));
        this.registerFunction(SpatialFunction.astext.name(), (SQLFunction)new HANASpatialFunction("ST_AsText", (Type)StandardBasicTypes.MATERIALIZED_CLOB, false));
        this.registerFunction(SpatialFunction.boundary.name(), (SQLFunction)new HANASpatialFunction("ST_Boundary", false));
        this.registerFunction(SpatialFunction.buffer.name(), (SQLFunction)new HANASpatialFunction("ST_Buffer", false));
        this.registerFunction(SpatialFunction.contains.name(), (SQLFunction)new HANASpatialFunction("ST_Contains", (Type)StandardBasicTypes.NUMERIC_BOOLEAN, true));
        this.registerFunction(SpatialFunction.convexhull.name(), (SQLFunction)new HANASpatialFunction("ST_ConvexHull", false));
        this.registerFunction(SpatialFunction.crosses.name(), (SQLFunction)new HANASpatialFunction("ST_Crosses", (Type)StandardBasicTypes.NUMERIC_BOOLEAN, true));
        this.registerFunction(SpatialFunction.difference.name(), (SQLFunction)new HANASpatialFunction("ST_Difference", true));
        this.registerFunction(SpatialFunction.dimension.name(), (SQLFunction)new HANASpatialFunction("ST_Dimension ", (Type)StandardBasicTypes.INTEGER, false));
        this.registerFunction(SpatialFunction.disjoint.name(), (SQLFunction)new HANASpatialFunction("ST_Disjoint", (Type)StandardBasicTypes.NUMERIC_BOOLEAN, true));
        this.registerFunction(SpatialFunction.distance.name(), (SQLFunction)new HANASpatialFunction("ST_Distance", (Type)StandardBasicTypes.DOUBLE, true));
        this.registerFunction(SpatialFunction.dwithin.name(), (SQLFunction)new HANASpatialFunction("ST_WithinDistance", (Type)StandardBasicTypes.NUMERIC_BOOLEAN, true));
        this.registerFunction(SpatialFunction.envelope.name(), (SQLFunction)new HANASpatialFunction("ST_Envelope", true));
        this.registerFunction(SpatialFunction.equals.name(), (SQLFunction)new HANASpatialFunction("ST_Equals", (Type)StandardBasicTypes.NUMERIC_BOOLEAN, true));
        this.registerFunction(SpatialFunction.extent.name(), (SQLFunction)new HANASpatialAggregate("ST_EnvelopeAggr"));
        this.registerFunction(SpatialFunction.geometrytype.name(), (SQLFunction)new HANASpatialFunction("ST_GeometryType", (Type)StandardBasicTypes.STRING, false));
        this.registerFunction(SpatialFunction.geomunion.name(), (SQLFunction)new HANASpatialFunction("ST_Union", true));
        this.registerFunction(SpatialFunction.intersection.name(), (SQLFunction)new HANASpatialFunction("ST_Intersection", true));
        this.registerFunction(SpatialFunction.intersects.name(), (SQLFunction)new HANASpatialFunction("ST_Intersects", (Type)StandardBasicTypes.NUMERIC_BOOLEAN, true));
        this.registerFunction(SpatialFunction.isempty.name(), (SQLFunction)new HANASpatialFunction("ST_IsEmpty", (Type)StandardBasicTypes.NUMERIC_BOOLEAN, false));
        this.registerFunction(SpatialFunction.issimple.name(), (SQLFunction)new HANASpatialFunction("ST_IsSimple", (Type)StandardBasicTypes.NUMERIC_BOOLEAN, false));
        this.registerFunction(SpatialFunction.overlaps.name(), (SQLFunction)new HANASpatialFunction("ST_Overlaps", (Type)StandardBasicTypes.NUMERIC_BOOLEAN, true));
        this.registerFunction(SpatialFunction.relate.name(), (SQLFunction)new HANASpatialFunction("ST_Relate", (Type)StandardBasicTypes.NUMERIC_BOOLEAN, true));
        this.registerFunction(SpatialFunction.srid.name(), (SQLFunction)new HANASpatialFunction("ST_SRID", (Type)StandardBasicTypes.INTEGER, false));
        this.registerFunction(SpatialFunction.symdifference.name(), (SQLFunction)new HANASpatialFunction("ST_SymDifference", true));
        this.registerFunction(SpatialFunction.touches.name(), (SQLFunction)new HANASpatialFunction("ST_Touches", (Type)StandardBasicTypes.NUMERIC_BOOLEAN, true));
        this.registerFunction(SpatialFunction.transform.name(), (SQLFunction)new HANASpatialFunction("ST_Transform", false));
        this.registerFunction(SpatialFunction.within.name(), (SQLFunction)new HANASpatialFunction("ST_Within", (Type)StandardBasicTypes.NUMERIC_BOOLEAN, true));
    }

    @Override
    public String getSpatialRelateSQL(String columnName, int spatialRelation) {
        switch (spatialRelation) {
            case 4: {
                return columnName + ".ST_Within(ST_GeomFromEWKB(?)) = 1";
            }
            case 6: {
                return columnName + ".ST_Contains(ST_GeomFromEWKB(?)) = 1";
            }
            case 3: {
                return columnName + ".ST_Crosses(ST_GeomFromEWKB(?)) = 1";
            }
            case 5: {
                return columnName + ".ST_Overlaps(ST_GeomFromEWKB(?)) = 1";
            }
            case 1: {
                return columnName + ".ST_Disjoint(ST_GeomFromEWKB(?)) = 1";
            }
            case 7: {
                return columnName + ".ST_Intersects(ST_GeomFromEWKB(?)) = 1";
            }
            case 2: {
                return columnName + ".ST_Touches(ST_GeomFromEWKB(?)) = 1";
            }
            case 0: {
                return columnName + ".ST_Equals(ST_GeomFromEWKB(?)) = 1";
            }
            case 8: {
                return columnName + ".ST_IntersectsFilter(ST_GeomFromEWKB(?)) = 1";
            }
        }
        throw new IllegalArgumentException("Spatial relation is not known by this dialect");
    }

    public void contributeTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        super.contributeTypes(typeContributions, serviceRegistry);
        ConfigurationService configurationService = (ConfigurationService)serviceRegistry.getService(ConfigurationService.class);
        boolean determineCrsIdFromDatabase = (Boolean)configurationService.getSetting(DETERMINE_CRS_ID_FROM_DATABASE_PARAMETER_NAME, (ConfigurationService.Converter)new ConfigurationService.Converter<Boolean>(){

            public Boolean convert(Object value) {
                return Boolean.valueOf(value.toString());
            }
        }, (Object)Boolean.FALSE);
        if (determineCrsIdFromDatabase) {
            typeContributions.contributeType((BasicType)new GeolatteGeometryType(HANAGeometryTypeDescriptor.CRS_LOADING_INSTANCE));
            typeContributions.contributeType((BasicType)new JTSGeometryType(HANAGeometryTypeDescriptor.CRS_LOADING_INSTANCE));
        } else {
            typeContributions.contributeType((BasicType)new GeolatteGeometryType(HANAGeometryTypeDescriptor.INSTANCE));
            typeContributions.contributeType((BasicType)new JTSGeometryType(HANAGeometryTypeDescriptor.INSTANCE));
        }
    }

    @Override
    public String getSpatialFilterExpression(String columnName) {
        return columnName + ".ST_IntersectsFilter(ST_GeomFromEWKB(?)) = 1";
    }

    @Override
    public String getSpatialAggregateSQL(String columnName, int aggregation) {
        switch (aggregation) {
            case 1: {
                return "ST_EnvelopeAggr(" + columnName + ")";
            }
        }
        throw new IllegalArgumentException("The aggregate type [" + aggregation + "] is not known by this dialect");
    }

    @Override
    public String getDWithinSQL(String columnName) {
        return columnName + ".ST_WithinDistance(ST_GeomFromEWKB(?), ?) = 1";
    }

    @Override
    public String getHavingSridSQL(String columnName) {
        return columnName + ".ST_SRID() = ?";
    }

    @Override
    public String getIsEmptySQL(String columnName, boolean isEmpty) {
        return columnName + ".ST_IsEmpty() = " + (isEmpty ? 1 : 0);
    }

    @Override
    public boolean supportsFiltering() {
        return true;
    }

    @Override
    public boolean supports(SpatialFunction function) {
        switch (function) {
            case asbinary: {
                return true;
            }
            case astext: {
                return true;
            }
            case boundary: {
                return true;
            }
            case buffer: {
                return true;
            }
            case contains: {
                return true;
            }
            case convexhull: {
                return true;
            }
            case crosses: {
                return true;
            }
            case difference: {
                return true;
            }
            case dimension: {
                return true;
            }
            case disjoint: {
                return true;
            }
            case distance: {
                return true;
            }
            case dwithin: {
                return true;
            }
            case envelope: {
                return true;
            }
            case equals: {
                return true;
            }
            case extent: {
                return true;
            }
            case geometrytype: {
                return true;
            }
            case geomunion: {
                return true;
            }
            case intersection: {
                return true;
            }
            case intersects: {
                return true;
            }
            case isempty: {
                return true;
            }
            case issimple: {
                return true;
            }
            case overlaps: {
                return true;
            }
            case relate: {
                return true;
            }
            case srid: {
                return true;
            }
            case symdifference: {
                return true;
            }
            case touches: {
                return true;
            }
            case transform: {
                return true;
            }
            case within: {
                return true;
            }
        }
        return false;
    }
}

