/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.hcore.impl;

import java.util.Objects;
import org.hibernate.SessionFactory;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.config.spi.StandardConverters;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.exception.AssertionFailure;
import org.hibernate.search.jmx.IndexControlMBean;
import org.hibernate.search.orm.jmx.impl.IndexControl;
import org.hibernate.search.util.StringHelper;
import org.hibernate.search.util.jmx.impl.JMXRegistrar;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

final class JMXHook {
    private static final Log log = LoggerFactory.make();
    private final String indexControlMBeanName;
    private final boolean indexControlMBeanEnabled;
    private boolean registeredIfEnabled;

    JMXHook(ConfigurationService configurationService) {
        Boolean enableJMX = (Boolean)configurationService.getSetting("hibernate.search.jmx_enabled", StandardConverters.BOOLEAN, (Object)Boolean.FALSE);
        this.indexControlMBeanName = enableJMX != false ? JMXHook.extractMBeanName(configurationService) : null;
        this.indexControlMBeanEnabled = enableJMX != false && this.indexControlMBeanName != null;
    }

    public synchronized void registerIfEnabled(ExtendedSearchIntegrator extendedIntegrator, SessionFactory factory) {
        Objects.requireNonNull(extendedIntegrator);
        Objects.requireNonNull(factory);
        if (this.registeredIfEnabled) {
            throw new AssertionFailure("Unexpected state");
        }
        if (this.indexControlMBeanEnabled) {
            JMXHook.enableIndexControlBean(this.indexControlMBeanName, extendedIntegrator, factory);
        }
        this.registeredIfEnabled = true;
    }

    public synchronized void unRegisterIfRegistered() {
        if (!this.registeredIfEnabled) {
            throw new AssertionFailure("Unexpected state");
        }
        if (this.registeredIfEnabled) {
            JMXRegistrar.unRegisterMBean((String)this.indexControlMBeanName);
        }
        this.registeredIfEnabled = false;
    }

    private static String extractMBeanName(ConfigurationService configurationService) {
        if (StringHelper.isEmpty((String)((String)configurationService.getSetting("hibernate.session_factory_name", StandardConverters.STRING)))) {
            log.debug((Object)"In order to bind the IndexControlMBean the Hibernate SessionFactory has to be available via JNDI");
            return null;
        }
        String mbeanNameSuffix = (String)configurationService.getSetting("hibernate.search.jmx_bean_suffix", StandardConverters.STRING);
        String objectName = JMXRegistrar.buildMBeanName((String)"org.hibernate.search.jmx:type=IndexControlMBean", (String)mbeanNameSuffix);
        return objectName;
    }

    private static String enableIndexControlBean(String objectName, ExtendedSearchIntegrator extendedIntegrator, SessionFactory factory) {
        if (JMXRegistrar.isNameRegistered((String)objectName)) {
            JMXRegistrar.unRegisterMBean((String)objectName);
        }
        IndexControl indexCtrlBean = new IndexControl(extendedIntegrator, factory);
        JMXRegistrar.registerMBean((Object)indexCtrlBean, IndexControlMBean.class, (String)objectName);
        return objectName;
    }
}

