/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.jmx;

import java.util.Properties;
import javax.naming.InitialContext;
import org.hibernate.CacheMode;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.SearchException;
import org.hibernate.search.jmx.IndexControlMBean;
import org.hibernate.search.util.impl.ClassLoaderHelper;
import org.hibernate.search.util.impl.JNDIHelper;

public class IndexControl
implements IndexControlMBean {
    private final Properties jndiProperties;
    private final String sessionFactoryJndiName;
    private int batchSize = 25;
    private int numberOfObjectLoadingThreads = 2;
    private int numberOfFetchingThreads = 4;

    public IndexControl(Properties props) {
        this.sessionFactoryJndiName = props.getProperty("hibernate.session_factory_name");
        this.jndiProperties = JNDIHelper.getJndiProperties((Properties)props, (String)"hibernate.jndi.");
    }

    @Override
    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    @Override
    public int getBatchSize() {
        return this.batchSize;
    }

    @Override
    public void setNumberOfObjectLoadingThreads(int numberOfThreads) {
        this.numberOfObjectLoadingThreads = numberOfThreads;
    }

    @Override
    public int getNumberOfObjectLoadingThreads() {
        return this.numberOfObjectLoadingThreads;
    }

    @Override
    public void setNumberOfFetchingThreads(int numberOfThreads) {
        this.numberOfFetchingThreads = numberOfThreads;
    }

    @Override
    public int getNumberOfFetchingThreads() {
        return this.numberOfFetchingThreads;
    }

    @Override
    public void index(String entity) {
        Class<?> clazz = this.getEntityClass(entity);
        SessionFactory factory = this.getSessionFactory();
        Session session = factory.openSession();
        FullTextSession fulltextSession = Search.getFullTextSession(session);
        try {
            fulltextSession.createIndexer(clazz).batchSizeToLoadObjects(this.batchSize).cacheMode(CacheMode.NORMAL).threadsToLoadObjects(this.numberOfObjectLoadingThreads).threadsForSubsequentFetching(this.numberOfFetchingThreads).startAndWait();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SearchException("Unable to complete indexing");
        }
        session.close();
    }

    @Override
    public void optimize(String entity) {
        Class<?> clazz = this.getEntityClass(entity);
        SessionFactory factory = this.getSessionFactory();
        Session session = factory.openSession();
        FullTextSession fullTextSession = Search.getFullTextSession(session);
        fullTextSession.beginTransaction();
        fullTextSession.getSearchFactory().optimize(clazz);
        fullTextSession.getTransaction().commit();
        session.close();
    }

    @Override
    public void purge(String entity) {
        Class<?> clazz = this.getEntityClass(entity);
        SessionFactory factory = this.getSessionFactory();
        Session session = factory.openSession();
        FullTextSession fullTextSession = Search.getFullTextSession(session);
        fullTextSession.beginTransaction();
        fullTextSession.purgeAll(clazz);
        fullTextSession.getTransaction().commit();
        session.close();
    }

    private Class<?> getEntityClass(String entity) {
        Class clazz;
        try {
            clazz = ClassLoaderHelper.classForName((String)entity, (ClassLoader)IndexControl.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(entity + "not a indexed entity");
        }
        return clazz;
    }

    private SessionFactory getSessionFactory() {
        try {
            InitialContext initialContext = this.jndiProperties.isEmpty() ? new InitialContext() : new InitialContext(this.jndiProperties);
            return (SessionFactory)initialContext.lookup(this.sessionFactoryJndiName);
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("In order for this operation to work the SessionFactory must be bound to JNDI");
        }
    }
}

