/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.impl;

import java.io.Serializable;
import java.sql.Connection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.CacheMode;
import org.hibernate.Criteria;
import org.hibernate.Filter;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.IdentifierLoadAccess;
import org.hibernate.Interceptor;
import org.hibernate.LobHelper;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.NaturalIdLoadAccess;
import org.hibernate.Query;
import org.hibernate.ReplicationMode;
import org.hibernate.SQLQuery;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.SharedSessionBuilder;
import org.hibernate.SimpleNaturalIdLoadAccess;
import org.hibernate.Transaction;
import org.hibernate.TypeHelper;
import org.hibernate.UnknownProfileException;
import org.hibernate.cache.spi.CacheKey;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.jdbc.LobCreationContext;
import org.hibernate.engine.jdbc.spi.JdbcConnectionAccess;
import org.hibernate.engine.query.spi.ParameterMetadata;
import org.hibernate.engine.query.spi.sql.NativeSQLQuerySpecification;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.NonFlushedChanges;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.QueryParameters;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.transaction.spi.TransactionCoordinator;
import org.hibernate.event.spi.EventSource;
import org.hibernate.internal.CriteriaImpl;
import org.hibernate.jdbc.ReturningWork;
import org.hibernate.loader.custom.CustomQuery;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.MassIndexer;
import org.hibernate.search.SearchFactory;
import org.hibernate.search.backend.TransactionContext;
import org.hibernate.search.backend.impl.EventSourceTransactionContext;
import org.hibernate.search.backend.spi.Work;
import org.hibernate.search.backend.spi.WorkType;
import org.hibernate.search.engine.spi.SearchFactoryImplementor;
import org.hibernate.search.impl.FullTextSharedSessionBuilderDelegator;
import org.hibernate.search.impl.MassIndexerImpl;
import org.hibernate.search.query.hibernate.impl.FullTextQueryImpl;
import org.hibernate.search.util.impl.ContextHelper;
import org.hibernate.search.util.impl.HibernateHelper;
import org.hibernate.stat.SessionStatistics;
import org.hibernate.type.Type;

public class FullTextSessionImpl
implements FullTextSession,
SessionImplementor {
    private final Session session;
    private final SessionImplementor sessionImplementor;
    private transient SearchFactoryImplementor searchFactory;
    private final TransactionContext transactionContext;

    public FullTextSessionImpl(Session session) {
        if (session == null) {
            throw new IllegalArgumentException("Unable to create a FullTextSession from an null Session object");
        }
        this.session = session;
        this.transactionContext = new EventSourceTransactionContext((EventSource)session);
        this.sessionImplementor = (SessionImplementor)session;
    }

    @Override
    public FullTextQuery createFullTextQuery(org.apache.lucene.search.Query luceneQuery, Class<?> ... entities) {
        return new FullTextQueryImpl(luceneQuery, entities, this.sessionImplementor, new ParameterMetadata(null, null));
    }

    @Override
    public <T> void purgeAll(Class<T> entityType) {
        this.purge(entityType, null);
    }

    @Override
    public void flushToIndexes() {
        SearchFactoryImplementor searchFactoryImplementor = this.getSearchFactoryImplementor();
        searchFactoryImplementor.getWorker().flushWorks(this.transactionContext);
    }

    @Override
    public <T> void purge(Class<T> entityType, Serializable id) {
        if (entityType == null) {
            return;
        }
        Set targetedClasses = this.getSearchFactoryImplementor().getIndexedTypesPolymorphic(new Class[]{entityType});
        if (targetedClasses.isEmpty()) {
            String msg = entityType.getName() + " is not an indexed entity or a subclass of an indexed entity";
            throw new IllegalArgumentException(msg);
        }
        for (Class clazz : targetedClasses) {
            if (id == null) {
                this.createAndPerformWork(clazz, null, WorkType.PURGE_ALL);
                continue;
            }
            this.createAndPerformWork(clazz, id, WorkType.PURGE);
        }
    }

    private <T> void createAndPerformWork(Class<T> clazz, Serializable id, WorkType workType) {
        Work work = new Work(clazz, id, workType);
        this.getSearchFactoryImplementor().getWorker().performWork(work, this.transactionContext);
    }

    @Override
    public <T> void index(T entity) {
        if (entity == null) {
            throw new IllegalArgumentException("Entity to index should not be null");
        }
        Class<T> clazz = HibernateHelper.getClass(entity);
        SearchFactoryImplementor searchFactoryImplementor = this.getSearchFactoryImplementor();
        if (searchFactoryImplementor.getIndexBindingForEntity(clazz) == null) {
            String msg = "Entity to index is not an @Indexed entity: " + entity.getClass().getName();
            throw new IllegalArgumentException(msg);
        }
        Serializable id = this.session.getIdentifier(entity);
        Work work = new Work(entity, id, WorkType.INDEX);
        searchFactoryImplementor.getWorker().performWork(work, this.transactionContext);
    }

    @Override
    public MassIndexer createIndexer(Class<?> ... types) {
        if (types.length == 0) {
            return new MassIndexerImpl(this.getSearchFactoryImplementor(), this.getSessionFactory(), Object.class);
        }
        return new MassIndexerImpl(this.getSearchFactoryImplementor(), this.getSessionFactory(), types);
    }

    @Override
    public SearchFactory getSearchFactory() {
        return this.getSearchFactoryImplementor();
    }

    private SearchFactoryImplementor getSearchFactoryImplementor() {
        if (this.searchFactory == null) {
            this.searchFactory = ContextHelper.getSearchFactory(this.session);
        }
        return this.searchFactory;
    }

    public String getTenantIdentifier() {
        return this.session.getTenantIdentifier();
    }

    public Transaction beginTransaction() throws HibernateException {
        return this.session.beginTransaction();
    }

    public void cancelQuery() throws HibernateException {
        this.session.cancelQuery();
    }

    public void clear() {
        this.session.clear();
    }

    public Connection close() throws HibernateException {
        return this.session.close();
    }

    public boolean contains(Object object) {
        return this.session.contains(object);
    }

    public Criteria createCriteria(String entityName) {
        return this.session.createCriteria(entityName);
    }

    public Criteria createCriteria(String entityName, String alias) {
        return this.session.createCriteria(entityName, alias);
    }

    public Criteria createCriteria(Class persistentClass) {
        return this.session.createCriteria(persistentClass);
    }

    public Criteria createCriteria(Class persistentClass, String alias) {
        return this.session.createCriteria(persistentClass, alias);
    }

    public Query createFilter(Object collection, String queryString) throws HibernateException {
        return this.session.createFilter(collection, queryString);
    }

    public Query createQuery(String queryString) throws HibernateException {
        return this.session.createQuery(queryString);
    }

    public SQLQuery createSQLQuery(String queryString) throws HibernateException {
        return this.session.createSQLQuery(queryString);
    }

    public void delete(String entityName, Object object) throws HibernateException {
        this.session.delete(entityName, object);
    }

    public void delete(Object object) throws HibernateException {
        this.session.delete(object);
    }

    public void disableFilter(String filterName) {
        this.session.disableFilter(filterName);
    }

    public Connection disconnect() throws HibernateException {
        return this.session.disconnect();
    }

    public Filter enableFilter(String filterName) {
        return this.session.enableFilter(filterName);
    }

    public void evict(Object object) throws HibernateException {
        this.session.evict(object);
    }

    public SharedSessionBuilder sessionWithOptions() {
        return new FullTextSharedSessionBuilderDelegator(this.session.sessionWithOptions());
    }

    public void flush() throws HibernateException {
        this.session.flush();
    }

    public Object get(Class clazz, Serializable id) throws HibernateException {
        return this.session.get(clazz, id);
    }

    public Object get(Class clazz, Serializable id, LockMode lockMode) throws HibernateException {
        return this.session.get(clazz, id, lockMode);
    }

    public Object get(Class clazz, Serializable id, LockOptions lockOptions) throws HibernateException {
        return this.session.get(clazz, id, lockOptions);
    }

    public Object get(String entityName, Serializable id) throws HibernateException {
        return this.session.get(entityName, id);
    }

    public Object get(String entityName, Serializable id, LockMode lockMode) throws HibernateException {
        return this.session.get(entityName, id, lockMode);
    }

    public Object get(String entityName, Serializable id, LockOptions lockOptions) throws HibernateException {
        return this.session.get(entityName, id, lockOptions);
    }

    public CacheMode getCacheMode() {
        return this.session.getCacheMode();
    }

    public LockMode getCurrentLockMode(Object object) throws HibernateException {
        return this.session.getCurrentLockMode(object);
    }

    public Filter getEnabledFilter(String filterName) {
        return this.session.getEnabledFilter(filterName);
    }

    public JdbcConnectionAccess getJdbcConnectionAccess() {
        return this.sessionImplementor.getJdbcConnectionAccess();
    }

    public EntityKey generateEntityKey(Serializable id, EntityPersister persister) {
        return this.sessionImplementor.generateEntityKey(id, persister);
    }

    public CacheKey generateCacheKey(Serializable id, Type type, String entityOrRoleName) {
        return this.sessionImplementor.generateCacheKey(id, type, entityOrRoleName);
    }

    public Interceptor getInterceptor() {
        return this.sessionImplementor.getInterceptor();
    }

    public void setAutoClear(boolean enabled) {
        this.sessionImplementor.setAutoClear(enabled);
    }

    public void disableTransactionAutoJoin() {
        this.sessionImplementor.disableTransactionAutoJoin();
    }

    public boolean isTransactionInProgress() {
        return this.sessionImplementor.isTransactionInProgress();
    }

    public void initializeCollection(PersistentCollection collection, boolean writing) throws HibernateException {
        this.sessionImplementor.initializeCollection(collection, writing);
    }

    public Object internalLoad(String entityName, Serializable id, boolean eager, boolean nullable) throws HibernateException {
        return this.sessionImplementor.internalLoad(entityName, id, eager, nullable);
    }

    public Object immediateLoad(String entityName, Serializable id) throws HibernateException {
        return this.sessionImplementor.immediateLoad(entityName, id);
    }

    public long getTimestamp() {
        return this.sessionImplementor.getTimestamp();
    }

    public SessionFactoryImplementor getFactory() {
        return this.sessionImplementor.getFactory();
    }

    public List list(String query, QueryParameters queryParameters) throws HibernateException {
        return this.sessionImplementor.list(query, queryParameters);
    }

    public Iterator iterate(String query, QueryParameters queryParameters) throws HibernateException {
        return this.sessionImplementor.iterate(query, queryParameters);
    }

    public ScrollableResults scroll(String query, QueryParameters queryParameters) throws HibernateException {
        return this.sessionImplementor.scroll(query, queryParameters);
    }

    public ScrollableResults scroll(CriteriaImpl criteria, ScrollMode scrollMode) {
        return this.sessionImplementor.scroll(criteria, scrollMode);
    }

    public List list(CriteriaImpl criteria) {
        return this.sessionImplementor.list(criteria);
    }

    public List listFilter(Object collection, String filter, QueryParameters queryParameters) throws HibernateException {
        return this.sessionImplementor.listFilter(collection, filter, queryParameters);
    }

    public Iterator iterateFilter(Object collection, String filter, QueryParameters queryParameters) throws HibernateException {
        return this.sessionImplementor.iterateFilter(collection, filter, queryParameters);
    }

    public EntityPersister getEntityPersister(String entityName, Object object) throws HibernateException {
        return this.sessionImplementor.getEntityPersister(entityName, object);
    }

    public Object getEntityUsingInterceptor(EntityKey key) throws HibernateException {
        return this.sessionImplementor.getEntityUsingInterceptor(key);
    }

    public Serializable getContextEntityIdentifier(Object object) {
        return this.sessionImplementor.getContextEntityIdentifier(object);
    }

    public String bestGuessEntityName(Object object) {
        return this.sessionImplementor.bestGuessEntityName(object);
    }

    public String guessEntityName(Object entity) throws HibernateException {
        return this.sessionImplementor.guessEntityName(entity);
    }

    public Object instantiate(String entityName, Serializable id) throws HibernateException {
        return this.sessionImplementor.instantiate(entityName, id);
    }

    public List listCustomQuery(CustomQuery customQuery, QueryParameters queryParameters) throws HibernateException {
        return this.sessionImplementor.listCustomQuery(customQuery, queryParameters);
    }

    public ScrollableResults scrollCustomQuery(CustomQuery customQuery, QueryParameters queryParameters) throws HibernateException {
        return this.sessionImplementor.scrollCustomQuery(customQuery, queryParameters);
    }

    public List list(NativeSQLQuerySpecification spec, QueryParameters queryParameters) throws HibernateException {
        return this.sessionImplementor.list(spec, queryParameters);
    }

    public ScrollableResults scroll(NativeSQLQuerySpecification spec, QueryParameters queryParameters) throws HibernateException {
        return this.sessionImplementor.scroll(spec, queryParameters);
    }

    public Object getFilterParameterValue(String filterParameterName) {
        return this.sessionImplementor.getFilterParameterValue(filterParameterName);
    }

    public Type getFilterParameterType(String filterParameterName) {
        return this.sessionImplementor.getFilterParameterType(filterParameterName);
    }

    public Map getEnabledFilters() {
        return this.sessionImplementor.getEnabledFilters();
    }

    public int getDontFlushFromFind() {
        return this.sessionImplementor.getDontFlushFromFind();
    }

    public PersistenceContext getPersistenceContext() {
        return this.sessionImplementor.getPersistenceContext();
    }

    public int executeUpdate(String query, QueryParameters queryParameters) throws HibernateException {
        return this.sessionImplementor.executeUpdate(query, queryParameters);
    }

    public int executeNativeUpdate(NativeSQLQuerySpecification specification, QueryParameters queryParameters) throws HibernateException {
        return this.sessionImplementor.executeNativeUpdate(specification, queryParameters);
    }

    public NonFlushedChanges getNonFlushedChanges() throws HibernateException {
        return this.sessionImplementor.getNonFlushedChanges();
    }

    public void applyNonFlushedChanges(NonFlushedChanges nonFlushedChanges) throws HibernateException {
        this.sessionImplementor.applyNonFlushedChanges(nonFlushedChanges);
    }

    public String getEntityName(Object object) throws HibernateException {
        return this.session.getEntityName(object);
    }

    public FlushMode getFlushMode() {
        return this.session.getFlushMode();
    }

    public Serializable getIdentifier(Object object) throws HibernateException {
        return this.session.getIdentifier(object);
    }

    public Query getNamedQuery(String queryName) throws HibernateException {
        return this.session.getNamedQuery(queryName);
    }

    public Query getNamedSQLQuery(String name) {
        return this.sessionImplementor.getNamedSQLQuery(name);
    }

    public boolean isEventSource() {
        return this.sessionImplementor.isEventSource();
    }

    public void afterScrollOperation() {
        this.sessionImplementor.afterScrollOperation();
    }

    public void setFetchProfile(String name) {
        this.sessionImplementor.setFetchProfile(name);
    }

    public TransactionCoordinator getTransactionCoordinator() {
        return this.sessionImplementor.getTransactionCoordinator();
    }

    public String getFetchProfile() {
        return this.sessionImplementor.getFetchProfile();
    }

    public boolean isClosed() {
        return this.sessionImplementor.isClosed();
    }

    public LoadQueryInfluencers getLoadQueryInfluencers() {
        return this.sessionImplementor.getLoadQueryInfluencers();
    }

    public SessionFactory getSessionFactory() {
        return this.session.getSessionFactory();
    }

    public SessionStatistics getStatistics() {
        return this.session.getStatistics();
    }

    public boolean isReadOnly(Object entityOrProxy) {
        return this.session.isReadOnly(entityOrProxy);
    }

    public Transaction getTransaction() {
        return this.session.getTransaction();
    }

    public boolean isConnected() {
        return this.session.isConnected();
    }

    public boolean isDirty() throws HibernateException {
        return this.session.isDirty();
    }

    public boolean isDefaultReadOnly() {
        return this.session.isDefaultReadOnly();
    }

    public boolean isOpen() {
        return this.session.isOpen();
    }

    public Object load(String entityName, Serializable id) throws HibernateException {
        return this.session.load(entityName, id);
    }

    public Object load(String entityName, Serializable id, LockMode lockMode) throws HibernateException {
        return this.session.load(entityName, id, lockMode);
    }

    public Object load(String entityName, Serializable id, LockOptions lockOptions) throws HibernateException {
        return this.session.load(entityName, id, lockOptions);
    }

    public void load(Object object, Serializable id) throws HibernateException {
        this.session.load(object, id);
    }

    public Object load(Class theClass, Serializable id) throws HibernateException {
        return this.session.load(theClass, id);
    }

    public Object load(Class theClass, Serializable id, LockMode lockMode) throws HibernateException {
        return this.session.load(theClass, id, lockMode);
    }

    public Object load(Class theClass, Serializable id, LockOptions lockOptions) throws HibernateException {
        return this.session.load(theClass, id, lockOptions);
    }

    public void lock(String entityName, Object object, LockMode lockMode) throws HibernateException {
        this.session.lock(entityName, object, lockMode);
    }

    public Session.LockRequest buildLockRequest(LockOptions lockOptions) {
        return this.session.buildLockRequest(lockOptions);
    }

    public void lock(Object object, LockMode lockMode) throws HibernateException {
        this.session.lock(object, lockMode);
    }

    public Object merge(String entityName, Object object) throws HibernateException {
        return this.session.merge(entityName, object);
    }

    public Object merge(Object object) throws HibernateException {
        return this.session.merge(object);
    }

    public void persist(String entityName, Object object) throws HibernateException {
        this.session.persist(entityName, object);
    }

    public void persist(Object object) throws HibernateException {
        this.session.persist(object);
    }

    public void reconnect(Connection connection) throws HibernateException {
        this.session.reconnect(connection);
    }

    public void refresh(Object object) throws HibernateException {
        this.session.refresh(object);
    }

    public void refresh(String entityName, Object object) throws HibernateException {
        this.session.refresh(entityName, object);
    }

    public void refresh(Object object, LockMode lockMode) throws HibernateException {
        this.session.refresh(object, lockMode);
    }

    public void refresh(Object object, LockOptions lockOptions) throws HibernateException {
        this.session.refresh(object, lockOptions);
    }

    public void refresh(String entityName, Object object, LockOptions lockOptions) throws HibernateException {
        this.session.refresh(entityName, object, lockOptions);
    }

    public void replicate(String entityName, Object object, ReplicationMode replicationMode) throws HibernateException {
        this.session.replicate(entityName, object, replicationMode);
    }

    public void replicate(Object object, ReplicationMode replicationMode) throws HibernateException {
        this.session.replicate(object, replicationMode);
    }

    public Serializable save(String entityName, Object object) throws HibernateException {
        return this.session.save(entityName, object);
    }

    public Serializable save(Object object) throws HibernateException {
        return this.session.save(object);
    }

    public void saveOrUpdate(String entityName, Object object) throws HibernateException {
        this.session.saveOrUpdate(entityName, object);
    }

    public void saveOrUpdate(Object object) throws HibernateException {
        this.session.saveOrUpdate(object);
    }

    public void setCacheMode(CacheMode cacheMode) {
        this.session.setCacheMode(cacheMode);
    }

    public void setDefaultReadOnly(boolean readOnly) {
        this.session.setDefaultReadOnly(readOnly);
    }

    public void setFlushMode(FlushMode flushMode) {
        this.session.setFlushMode(flushMode);
    }

    public Connection connection() {
        return this.sessionImplementor.connection();
    }

    public void setReadOnly(Object entity, boolean readOnly) {
        this.session.setReadOnly(entity, readOnly);
    }

    public void doWork(org.hibernate.jdbc.Work work) throws HibernateException {
        this.session.doWork(work);
    }

    public <T> T doReturningWork(ReturningWork<T> work) throws HibernateException {
        return (T)this.session.doReturningWork(work);
    }

    public void update(String entityName, Object object) throws HibernateException {
        this.session.update(entityName, object);
    }

    public void update(Object object) throws HibernateException {
        this.session.update(object);
    }

    public boolean isFetchProfileEnabled(String name) throws UnknownProfileException {
        return this.session.isFetchProfileEnabled(name);
    }

    public void enableFetchProfile(String name) throws UnknownProfileException {
        this.session.enableFetchProfile(name);
    }

    public void disableFetchProfile(String name) throws UnknownProfileException {
        this.session.disableFetchProfile(name);
    }

    public TypeHelper getTypeHelper() {
        return this.session.getTypeHelper();
    }

    public LobHelper getLobHelper() {
        return this.session.getLobHelper();
    }

    public <T> T execute(LobCreationContext.Callback<T> callback) {
        return (T)this.sessionImplementor.execute(callback);
    }

    public IdentifierLoadAccess byId(String entityName) {
        return this.session.byId(entityName);
    }

    public IdentifierLoadAccess byId(Class entityClass) {
        return this.session.byId(entityClass);
    }

    public NaturalIdLoadAccess byNaturalId(String entityName) {
        return this.session.byNaturalId(entityName);
    }

    public NaturalIdLoadAccess byNaturalId(Class entityClass) {
        return this.session.byNaturalId(entityClass);
    }

    public SimpleNaturalIdLoadAccess bySimpleNaturalId(String entityName) {
        return this.session.bySimpleNaturalId(entityName);
    }

    public SimpleNaturalIdLoadAccess bySimpleNaturalId(Class entityClass) {
        return this.session.bySimpleNaturalId(entityClass);
    }
}

