/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.indexes.impl;

import java.util.Collection;
import java.util.HashSet;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.lucene.search.similarities.ClassicSimilarity;
import org.apache.lucene.search.similarities.Similarity;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.java.JavaReflectionManager;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.backend.spi.BackendQueueProcessor;
import org.hibernate.search.cfg.spi.IndexManagerFactory;
import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.engine.impl.MutableEntityIndexBinding;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.engine.service.classloading.spi.ClassLoadingException;
import org.hibernate.search.engine.service.spi.ServiceManager;
import org.hibernate.search.engine.service.spi.ServiceReference;
import org.hibernate.search.exception.AssertionFailure;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.indexes.impl.DynamicShardingEntityIndexBinder;
import org.hibernate.search.indexes.impl.EntityIndexBinder;
import org.hibernate.search.indexes.impl.IndexManagerGroupHolder;
import org.hibernate.search.indexes.impl.NonDynamicShardingEntityIndexBinder;
import org.hibernate.search.indexes.impl.NotShardedEntityIndexBinder;
import org.hibernate.search.indexes.interceptor.EntityIndexingInterceptor;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.indexes.spi.IndexManagerType;
import org.hibernate.search.spi.IndexedTypeIdentifier;
import org.hibernate.search.spi.WorkerBuildContext;
import org.hibernate.search.store.IndexShardingStrategy;
import org.hibernate.search.store.ShardIdentifierProvider;
import org.hibernate.search.store.impl.IdHashShardingStrategy;
import org.hibernate.search.util.StringHelper;
import org.hibernate.search.util.configuration.impl.ConfigurationParseHelper;
import org.hibernate.search.util.configuration.impl.MaskedProperty;
import org.hibernate.search.util.impl.ClassLoaderHelper;
import org.hibernate.search.util.impl.Closer;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class IndexManagerHolder {
    private static final Log log = LoggerFactory.make();
    static final String SHARDING_STRATEGY = "sharding_strategy";
    private static final String NBR_OF_SHARDS = "sharding_strategy.nbr_of_shards";
    private static final Similarity DEFAULT_SIMILARITY = new ClassicSimilarity();
    private static final String DEFAULT_INDEX_MANAGER_KEY = "__DEFAULT__";
    private final ConcurrentMap<String, IndexManagerType> indexManagerImplementationsRegistry = new ConcurrentHashMap<String, IndexManagerType>();
    private final ConcurrentMap<String, IndexManager> indexManagersRegistry = new ConcurrentHashMap<String, IndexManager>();
    private final ConcurrentMap<String, BackendQueueProcessor> backendQueueProcessorRegistry = new ConcurrentHashMap<String, BackendQueueProcessor>();
    private final ConcurrentMap<String, IndexManagerGroupHolder> groupHolderRegistry = new ConcurrentHashMap<String, IndexManagerGroupHolder>();
    private final ConcurrentMap<String, IndexManagerGroupHolder> groupHolderByIndexManagerNameRegistry = new ConcurrentHashMap<String, IndexManagerGroupHolder>();
    private ExtendedSearchIntegrator integrator;

    public synchronized MutableEntityIndexBinding buildEntityIndexBinding(XClass entity, IndexedTypeIdentifier mappedClassId, SearchConfiguration cfg, WorkerBuildContext buildContext) {
        String indexName = IndexManagerHolder.getIndexName(entity, cfg);
        IndexManagerGroupHolder groupHolder = this.getOrCreateGroupHolder(indexName, cfg, buildContext);
        EntityIndexingInterceptor interceptor = this.createEntityIndexingInterceptor(entity);
        return groupHolder.bind(mappedClassId, interceptor, buildContext);
    }

    private synchronized IndexManagerGroupHolder getOrCreateGroupHolder(String indexNameBase, SearchConfiguration cfg, WorkerBuildContext buildContext) {
        IndexManagerGroupHolder holder = (IndexManagerGroupHolder)this.groupHolderRegistry.get(indexNameBase);
        if (holder != null) {
            return holder;
        }
        Properties[] properties = IndexManagerHolder.getIndexProperties(cfg, indexNameBase);
        Similarity similarity = this.createSimilarity(indexNameBase, cfg, properties[0], buildContext);
        boolean isDynamicSharding = this.isShardingDynamic(properties[0], buildContext);
        IndexManagerType indexManagerType = this.getIndexManagerType(indexNameBase, properties, cfg, buildContext);
        EntityIndexBinder entityIndexBinder = null;
        entityIndexBinder = isDynamicSharding ? this.createDynamicShardingEntityIndexBinder(properties, buildContext) : this.createNonDynamicShardingEntityIndexBinder(properties, buildContext);
        holder = new IndexManagerGroupHolder(this, indexNameBase, similarity, indexManagerType, entityIndexBinder);
        this.groupHolderRegistry.put(indexNameBase, holder);
        return holder;
    }

    public Collection<IndexManager> getIndexManagers() {
        return this.indexManagersRegistry.values();
    }

    public void setActiveSearchIntegrator(ExtendedSearchIntegrator integrator) {
        this.integrator = integrator;
        SearchException exception = null;
        for (IndexManager indexManager : this.getIndexManagers()) {
            try {
                indexManager.setSearchFactory(integrator);
            }
            catch (SearchException e) {
                if (exception == null) {
                    exception = e;
                    continue;
                }
                exception.addSuppressed(e);
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    ExtendedSearchIntegrator getActiveSearchIntegrator() {
        return this.integrator;
    }

    void register(String indexName, IndexManagerGroupHolder groupHolder) {
        this.groupHolderByIndexManagerNameRegistry.put(indexName, groupHolder);
    }

    void register(String indexName, IndexManager indexManager, BackendQueueProcessor backendQueueProcessor) {
        this.indexManagersRegistry.put(indexName, indexManager);
        this.backendQueueProcessorRegistry.put(indexName, backendQueueProcessor);
    }

    public synchronized void stop() {
        try (Closer closer = new Closer();){
            closer.pushAll(BackendQueueProcessor::close, this.backendQueueProcessorRegistry.values());
            this.backendQueueProcessorRegistry.clear();
            closer.pushAll(IndexManagerGroupHolder::close, this.groupHolderRegistry.values());
            this.groupHolderRegistry.clear();
            this.groupHolderByIndexManagerNameRegistry.clear();
            this.indexManagersRegistry.clear();
            this.indexManagerImplementationsRegistry.clear();
        }
    }

    public IndexManager getIndexManager(String targetIndexName) {
        if (targetIndexName == null) {
            throw log.nullIsInvalidIndexName();
        }
        return (IndexManager)this.indexManagersRegistry.get(targetIndexName);
    }

    public BackendQueueProcessor getBackendQueueProcessor(String indexName) {
        if (indexName == null) {
            throw log.nullIsInvalidIndexName();
        }
        return (BackendQueueProcessor)this.backendQueueProcessorRegistry.get(indexName);
    }

    public IndexManagerGroupHolder getGroupHolderByIndexManager(IndexManager indexManager) {
        String indexName = indexManager.getIndexName();
        IndexManagerGroupHolder groupHolder = (IndexManagerGroupHolder)this.groupHolderByIndexManagerNameRegistry.get(indexName);
        if (groupHolder == null) {
            throw new AssertionFailure("An index manager was not properly registered in the IndexManagerHolder: " + indexName);
        }
        return groupHolder;
    }

    private Class<? extends EntityIndexingInterceptor> getInterceptorClassFromHierarchy(XClass entity, Indexed indexedAnnotation) {
        Class<? extends EntityIndexingInterceptor> result = indexedAnnotation.interceptor();
        XClass superEntity = entity;
        while (result == EntityIndexingInterceptor.class) {
            if ((superEntity = superEntity.getSuperclass()) == null) {
                return result;
            }
            Indexed indexAnnForSuperclass = (Indexed)superEntity.getAnnotation(Indexed.class);
            result = indexAnnForSuperclass != null ? indexAnnForSuperclass.interceptor() : result;
        }
        return result;
    }

    private static String getIndexName(XClass clazz, SearchConfiguration cfg) {
        ReflectionManager reflectionManager = cfg.getReflectionManager();
        if (reflectionManager == null) {
            reflectionManager = new JavaReflectionManager();
        }
        Class<?> aClass = cfg.getClassMapping(clazz.getName());
        XClass rootIndex = null;
        do {
            XClass currentClazz;
            Indexed indexAnn;
            if ((indexAnn = (Indexed)(currentClazz = reflectionManager.toXClass(aClass)).getAnnotation(Indexed.class)) == null) continue;
            if (indexAnn.index().length() != 0) {
                return indexAnn.index();
            }
            rootIndex = currentClazz;
        } while ((aClass = aClass.getSuperclass()) != null);
        if (rootIndex != null) {
            return rootIndex.getName();
        }
        throw new SearchException("Trying to extract the index name from a non @Indexed class: " + clazz.getName());
    }

    private static Properties[] getIndexProperties(SearchConfiguration cfg, String indexName) {
        MaskedProperty globalProperties;
        MaskedProperty rootCfg = new MaskedProperty(cfg.getProperties(), "hibernate.search");
        MaskedProperty directoryLocalProperties = new MaskedProperty(rootCfg, indexName, globalProperties = new MaskedProperty(rootCfg, "default"));
        String shardsCountValue = ((Properties)directoryLocalProperties).getProperty(NBR_OF_SHARDS);
        if (shardsCountValue == null) {
            return new Properties[]{directoryLocalProperties};
        }
        int shardsCount = ConfigurationParseHelper.parseInt(shardsCountValue, "'" + shardsCountValue + "' is not a valid value for " + NBR_OF_SHARDS);
        if (shardsCount <= 0) {
            throw log.getInvalidShardCountException(shardsCount);
        }
        Properties[] shardLocalProperties = new Properties[shardsCount];
        for (int i = 0; i < shardsCount; ++i) {
            shardLocalProperties[i] = new MaskedProperty(directoryLocalProperties, Integer.toString(i), directoryLocalProperties);
        }
        return shardLocalProperties;
    }

    private EntityIndexBinder createDynamicShardingEntityIndexBinder(Properties[] indexProperty, WorkerBuildContext buildContext) {
        String shardIdentityProviderName = indexProperty[0].getProperty(SHARDING_STRATEGY);
        ServiceManager serviceManager = buildContext.getServiceManager();
        Class<ShardIdentifierProvider> shardIdentifierProviderClass = ClassLoaderHelper.classForName(ShardIdentifierProvider.class, shardIdentityProviderName, "ShardIdentifierProvider", serviceManager);
        return new DynamicShardingEntityIndexBinder(shardIdentifierProviderClass, indexProperty[0]);
    }

    private EntityIndexingInterceptor createEntityIndexingInterceptor(XClass entity) {
        Indexed indexedAnnotation = (Indexed)entity.getAnnotation(Indexed.class);
        EntityIndexingInterceptor interceptor = null;
        if (indexedAnnotation != null) {
            Class<? extends EntityIndexingInterceptor> interceptorClass = this.getInterceptorClassFromHierarchy(entity, indexedAnnotation);
            interceptor = interceptorClass == EntityIndexingInterceptor.class ? null : ClassLoaderHelper.instanceFromClass(EntityIndexingInterceptor.class, interceptorClass, "IndexingActionInterceptor for " + entity.getName());
        }
        return interceptor;
    }

    private Similarity createSimilarity(String directoryProviderName, SearchConfiguration searchConfiguration, Properties indexProperties, WorkerBuildContext buildContext) {
        Similarity configLevelSimilarity = this.getConfiguredPerIndexSimilarity(directoryProviderName, indexProperties, buildContext);
        if (configLevelSimilarity != null) {
            return configLevelSimilarity;
        }
        return this.getDefaultSimilarity(searchConfiguration, buildContext);
    }

    private Similarity getDefaultSimilarity(SearchConfiguration searchConfiguration, WorkerBuildContext buildContext) {
        String defaultSimilarityClassName = searchConfiguration.getProperty("hibernate.search.similarity");
        if (StringHelper.isEmpty(defaultSimilarityClassName)) {
            return DEFAULT_SIMILARITY;
        }
        ServiceManager serviceManager = buildContext.getServiceManager();
        return ClassLoaderHelper.instanceFromName(Similarity.class, defaultSimilarityClassName, "default similarity", serviceManager);
    }

    private Similarity getConfiguredPerIndexSimilarity(String directoryProviderName, Properties indexProperties, WorkerBuildContext buildContext) {
        Similarity configLevelSimilarity = null;
        String similarityClassName = indexProperties.getProperty("similarity");
        if (similarityClassName != null) {
            ServiceManager serviceManager = buildContext.getServiceManager();
            configLevelSimilarity = ClassLoaderHelper.instanceFromName(Similarity.class, similarityClassName, "Similarity class for index " + directoryProviderName, serviceManager);
        }
        return configLevelSimilarity;
    }

    private EntityIndexBinder createNonDynamicShardingEntityIndexBinder(Properties[] indexProps, WorkerBuildContext buildContext) {
        Class shardingStrategyClass;
        String shardingStrategyName = indexProps[0].getProperty(SHARDING_STRATEGY);
        if (shardingStrategyName == null) {
            if (indexProps.length == 1) {
                return new NotShardedEntityIndexBinder(indexProps[0]);
            }
            shardingStrategyClass = IdHashShardingStrategy.class;
        } else {
            ServiceManager serviceManager = buildContext.getServiceManager();
            shardingStrategyClass = ClassLoaderHelper.classForName(IndexShardingStrategy.class, shardingStrategyName, "IndexShardingStrategy", serviceManager);
        }
        return new NonDynamicShardingEntityIndexBinder(shardingStrategyClass, indexProps);
    }

    private boolean isShardingDynamic(Properties indexProperty, WorkerBuildContext buildContext) {
        Class shardingStrategy;
        boolean isShardingDynamic = false;
        String shardingStrategyName = indexProperty.getProperty(SHARDING_STRATEGY);
        if (shardingStrategyName == null) {
            return isShardingDynamic;
        }
        try {
            shardingStrategy = ClassLoaderHelper.classForName(shardingStrategyName, buildContext.getServiceManager());
        }
        catch (ClassLoadingException e) {
            throw log.getUnableToLoadShardingStrategyClassException(shardingStrategyName);
        }
        if (ShardIdentifierProvider.class.isAssignableFrom(shardingStrategy)) {
            isShardingDynamic = true;
        }
        return isShardingDynamic;
    }

    public synchronized IndexManagerType getIndexManagerType(String indexName, Properties[] indexProperties, SearchConfiguration cfg, WorkerBuildContext buildContext) {
        IndexManagerType indexManagerType;
        String indexManagerImplementationKey;
        ServiceManager serviceManager = buildContext.getServiceManager();
        String indexManagerImplementationName = indexProperties[0].getProperty("indexmanager");
        String string = indexManagerImplementationKey = StringHelper.isEmpty(indexManagerImplementationName) ? DEFAULT_INDEX_MANAGER_KEY : indexManagerImplementationName;
        if (this.indexManagerImplementationsRegistry.containsKey(indexManagerImplementationKey)) {
            return (IndexManagerType)this.indexManagerImplementationsRegistry.get(indexManagerImplementationKey);
        }
        try (ServiceReference<IndexManagerFactory> indexManagerFactoryRef = serviceManager.requestReference(IndexManagerFactory.class);){
            IndexManagerFactory indexManagerFactory = indexManagerFactoryRef.get();
            indexManagerType = indexManagerFactory.createIndexManagerByName(indexManagerImplementationName).getIndexManagerType();
        }
        this.indexManagerImplementationsRegistry.put(indexManagerImplementationKey, indexManagerType);
        return indexManagerType;
    }

    public Collection<IndexManagerType> getIndexManagerTypes() {
        return new HashSet<IndexManagerType>(this.indexManagerImplementationsRegistry.values());
    }
}

