/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.metadata.impl;

import java.util.Map;
import org.hibernate.annotations.common.reflection.XMember;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.engine.metadata.impl.BackReference;
import org.hibernate.search.engine.metadata.impl.PropertyMetadata;
import org.hibernate.search.engine.metadata.impl.TypeMetadata;
import org.hibernate.search.util.impl.ReflectionHelper;

public class EmbeddedTypeMetadata
extends TypeMetadata {
    private final BackReference<PropertyMetadata> sourceProperty;
    private final String embeddedFieldPrefix;
    private final Container embeddedContainer;
    private final String embeddedNullFieldName;
    private final String embeddedNullToken;
    private final FieldBridge embeddedNullFieldBridge;

    private EmbeddedTypeMetadata(Builder builder) {
        super(builder);
        this.sourceProperty = builder.sourceProperty;
        this.embeddedFieldPrefix = builder.embeddedFieldPrefix;
        this.embeddedContainer = builder.embeddedContainer;
        this.embeddedNullFieldName = builder.embeddedNullFieldName;
        this.embeddedNullToken = builder.embeddedNullToken;
        this.embeddedNullFieldBridge = builder.embeddedNullFieldBridge;
    }

    public PropertyMetadata getSourceProperty() {
        return this.sourceProperty.get();
    }

    public String getEmbeddedPropertyName() {
        return this.getSourceProperty().getPropertyAccessorName();
    }

    public String getEmbeddedFieldPrefix() {
        return this.embeddedFieldPrefix;
    }

    public XMember getEmbeddedGetter() {
        return this.getSourceProperty().getPropertyAccessor();
    }

    public Container getEmbeddedContainer() {
        return this.embeddedContainer;
    }

    public String getEmbeddedNullFieldName() {
        return this.embeddedNullFieldName;
    }

    public String getEmbeddedNullToken() {
        return this.embeddedNullToken;
    }

    public FieldBridge getEmbeddedNullFieldBridge() {
        return this.embeddedNullFieldBridge;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("EmbeddedTypeMetadata{");
        sb.append("embeddedPropertyName='").append(this.getEmbeddedPropertyName()).append('\'');
        sb.append(", sourceProperty='").append(this.sourceProperty).append('\'');
        sb.append(", embeddedFieldPrefix='").append(this.embeddedFieldPrefix).append('\'');
        sb.append(", embeddedGetter=").append(this.getEmbeddedGetter());
        sb.append(", embeddedContainer=").append((Object)this.embeddedContainer);
        sb.append(", embeddedNullFieldPath='").append(this.embeddedNullFieldName).append('\'');
        sb.append(", embeddedNullToken='").append(this.embeddedNullToken).append('\'');
        sb.append(", embeddedNullFieldBridge=").append(this.embeddedNullFieldBridge);
        sb.append('}');
        return sb.toString();
    }

    public static enum Container {
        OBJECT,
        COLLECTION,
        MAP,
        ARRAY;

    }

    public static class Builder
    extends TypeMetadata.Builder {
        private final BackReference<PropertyMetadata> sourceProperty;
        private final String embeddedFieldPrefix;
        private final Container embeddedContainer;
        private String embeddedNullToken;
        private String embeddedNullFieldName;
        private FieldBridge embeddedNullFieldBridge;

        public Builder(TypeMetadata.Builder parentTypeBuilder, Class<?> indexedType, BackReference<PropertyMetadata> sourceProperty, XMember embeddedGetter, String embeddedFieldPrefix) {
            super(indexedType, parentTypeBuilder);
            this.sourceProperty = sourceProperty;
            ReflectionHelper.setAccessible(embeddedGetter);
            this.embeddedFieldPrefix = embeddedFieldPrefix;
            this.embeddedContainer = this.determineContainerType(embeddedGetter);
        }

        public Builder indexNullToken(String embeddedNullToken, String embeddedNullFieldName, FieldBridge embeddedNullFieldBridge) {
            this.embeddedNullToken = embeddedNullToken;
            this.embeddedNullFieldName = embeddedNullFieldName;
            this.embeddedNullFieldBridge = embeddedNullFieldBridge;
            return this;
        }

        public Container getEmbeddedContainerType() {
            return this.embeddedContainer;
        }

        @Override
        public EmbeddedTypeMetadata build() {
            EmbeddedTypeMetadata result = new EmbeddedTypeMetadata(this);
            this.resultReference.initialize(result);
            return result;
        }

        private Container determineContainerType(XMember member) {
            if (member.isArray()) {
                return Container.ARRAY;
            }
            if (member.isCollection()) {
                if (Map.class.equals((Object)member.getCollectionClass())) {
                    return Container.MAP;
                }
                return Container.COLLECTION;
            }
            return Container.OBJECT;
        }
    }
}

