/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.jcache.access;

import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.jcache.JCacheRegion;
import org.hibernate.cache.jcache.JCacheTransactionalDataRegion;
import org.hibernate.cache.spi.access.RegionAccessStrategy;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.engine.spi.SharedSessionContractImplementor;

abstract class JCacheRegionAccessStrategy<R extends JCacheTransactionalDataRegion>
implements RegionAccessStrategy {
    private final R region;

    public JCacheRegionAccessStrategy(R region) {
        if (region == null) {
            throw new NullPointerException("Requires a non-null JCacheTransactionalDataRegion");
        }
        this.region = region;
    }

    public Object get(SharedSessionContractImplementor session, Object key, long txTimestamp) throws CacheException {
        return ((JCacheTransactionalDataRegion)this.region).get(key);
    }

    public boolean putFromLoad(SharedSessionContractImplementor session, Object key, Object value, long txTimestamp, Object version) throws CacheException {
        SessionFactoryOptions options = ((JCacheTransactionalDataRegion)this.region).getSessionFactoryOptions();
        boolean minimalPutOverride = options != null && options.isMinimalPutsEnabled();
        return this.putFromLoad(session, key, value, txTimestamp, version, minimalPutOverride);
    }

    public boolean putFromLoad(SharedSessionContractImplementor session, Object key, Object value, long txTimestamp, Object version, boolean minimalPutOverride) throws CacheException {
        if (minimalPutOverride && ((JCacheRegion)this.region).contains(key)) {
            return false;
        }
        ((JCacheTransactionalDataRegion)this.region).put(key, value);
        return true;
    }

    public SoftLock lockItem(SharedSessionContractImplementor session, Object key, Object version) throws CacheException {
        return null;
    }

    public SoftLock lockRegion() throws CacheException {
        return null;
    }

    public void unlockItem(SharedSessionContractImplementor session, Object key, SoftLock lock) throws CacheException {
        this.evict(key);
    }

    public void unlockRegion(SoftLock lock) throws CacheException {
        this.evictAll();
    }

    public void remove(SharedSessionContractImplementor session, Object key) throws CacheException {
    }

    public void removeAll() throws CacheException {
        this.evictAll();
    }

    public void evict(Object key) throws CacheException {
        ((JCacheTransactionalDataRegion)this.region).remove(key);
    }

    public void evictAll() throws CacheException {
        ((JCacheTransactionalDataRegion)this.region).clear();
    }

    public R getRegion() {
        return this.region;
    }
}

