/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.jcache;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.spi.CachingProvider;
import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.jcache.JCacheCollectionRegion;
import org.hibernate.cache.jcache.JCacheEntityRegion;
import org.hibernate.cache.jcache.JCacheMessageLogger;
import org.hibernate.cache.jcache.JCacheNaturalIdRegion;
import org.hibernate.cache.jcache.JCacheQueryResultsRegion;
import org.hibernate.cache.jcache.JCacheTimestampsRegion;
import org.hibernate.cache.jcache.time.Timestamper;
import org.hibernate.cache.spi.CacheDataDescription;
import org.hibernate.cache.spi.CollectionRegion;
import org.hibernate.cache.spi.EntityRegion;
import org.hibernate.cache.spi.NaturalIdRegion;
import org.hibernate.cache.spi.QueryResultsRegion;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.cache.spi.TimestampsRegion;
import org.hibernate.cache.spi.access.AccessType;
import org.jboss.logging.Logger;

public class JCacheRegionFactory
implements RegionFactory {
    private static final String PROP_PREFIX = "hibernate.javax.cache";
    public static final String PROVIDER = "hibernate.javax.cache.provider";
    public static final String CONFIG_URI = "hibernate.javax.cache.uri";
    private static final JCacheMessageLogger LOG = (JCacheMessageLogger)Logger.getMessageLogger(JCacheMessageLogger.class, (String)JCacheRegionFactory.class.getName());
    private final AtomicBoolean started = new AtomicBoolean(false);
    private volatile CacheManager cacheManager;
    private SessionFactoryOptions options;

    static long nextTS() {
        return Timestamper.next();
    }

    static int timeOut() {
        return (int)TimeUnit.SECONDS.toMillis(60L) * 4096;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(SessionFactoryOptions options, Properties properties) throws CacheException {
        if (this.started.compareAndSet(false, true)) {
            JCacheRegionFactory jCacheRegionFactory = this;
            synchronized (jCacheRegionFactory) {
                this.options = options;
                try {
                    this.cacheManager = this.getCacheManager(properties);
                }
                finally {
                    if (this.cacheManager == null) {
                        this.started.set(false);
                    }
                }
            }
        }
        LOG.attemptToRestartAlreadyStartedJCacheProvider();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (this.started.compareAndSet(true, false)) {
            JCacheRegionFactory jCacheRegionFactory = this;
            synchronized (jCacheRegionFactory) {
                this.cacheManager.close();
                this.cacheManager = null;
            }
        } else {
            LOG.attemptToRestopAlreadyStoppedJCacheProvider();
        }
    }

    public boolean isMinimalPutsEnabledByDefault() {
        return true;
    }

    public AccessType getDefaultAccessType() {
        return AccessType.READ_WRITE;
    }

    public long nextTimestamp() {
        return JCacheRegionFactory.nextTS();
    }

    public EntityRegion buildEntityRegion(String regionName, Properties properties, CacheDataDescription metadata) throws CacheException {
        Cache<Object, Object> cache = this.getOrCreateCache(regionName, properties, metadata);
        return new JCacheEntityRegion(cache, metadata, this.options);
    }

    public NaturalIdRegion buildNaturalIdRegion(String regionName, Properties properties, CacheDataDescription metadata) throws CacheException {
        Cache<Object, Object> cache = this.getOrCreateCache(regionName, properties, metadata);
        return new JCacheNaturalIdRegion(cache, metadata, this.options);
    }

    public CollectionRegion buildCollectionRegion(String regionName, Properties properties, CacheDataDescription metadata) throws CacheException {
        Cache<Object, Object> cache = this.getOrCreateCache(regionName, properties, metadata);
        return new JCacheCollectionRegion(cache, metadata, this.options);
    }

    public QueryResultsRegion buildQueryResultsRegion(String regionName, Properties properties) throws CacheException {
        Cache<Object, Object> cache = this.getOrCreateCache(regionName, properties, null);
        return new JCacheQueryResultsRegion(cache);
    }

    public TimestampsRegion buildTimestampsRegion(String regionName, Properties properties) throws CacheException {
        Cache<Object, Object> cache = this.getOrCreateCache(regionName, properties, null);
        return new JCacheTimestampsRegion(cache);
    }

    boolean isStarted() {
        return this.started.get() && this.cacheManager != null;
    }

    protected SessionFactoryOptions getOptions() {
        return this.options;
    }

    protected CachingProvider getCachingProvider(Properties properties) {
        String provider = this.getProp(properties, PROVIDER);
        CachingProvider cachingProvider = provider != null ? Caching.getCachingProvider((String)provider) : Caching.getCachingProvider();
        return cachingProvider;
    }

    protected CacheManager getCacheManager(Properties properties) {
        CacheManager cacheManager;
        CachingProvider cachingProvider = this.getCachingProvider(properties);
        String cacheManagerUri = this.getProp(properties, CONFIG_URI);
        if (cacheManagerUri != null) {
            URI uri;
            try {
                uri = new URI(cacheManagerUri);
            }
            catch (URISyntaxException e) {
                throw new CacheException("Couldn't create URI from " + cacheManagerUri, (Throwable)e);
            }
            cacheManager = cachingProvider.getCacheManager(uri, cachingProvider.getDefaultClassLoader());
        } else {
            cacheManager = cachingProvider.getCacheManager();
        }
        return cacheManager;
    }

    protected Cache<Object, Object> getOrCreateCache(String regionName, Properties properties, CacheDataDescription metadata) {
        this.checkStatus();
        Cache cache = this.cacheManager.getCache(regionName);
        if (cache == null) {
            try {
                return this.createCache(regionName, properties, metadata);
            }
            catch (CacheException e) {
                Cache existing = this.cacheManager.getCache(regionName);
                if (existing != null) {
                    return existing;
                }
                throw e;
            }
        }
        return cache;
    }

    protected Cache<Object, Object> createCache(String regionName, Properties properties, CacheDataDescription metadata) {
        return this.cacheManager.createCache(regionName, this.newDefaultConfig(properties, metadata));
    }

    protected Configuration<Object, Object> newDefaultConfig(Properties properties, CacheDataDescription metadata) {
        return new MutableConfiguration();
    }

    protected CacheManager getCacheManager() {
        return this.cacheManager;
    }

    protected String getProp(Properties properties, String prop) {
        return properties != null ? properties.getProperty(prop) : null;
    }

    protected void checkStatus() {
        if (!this.isStarted()) {
            throw new IllegalStateException("JCacheRegionFactory not yet started!");
        }
    }
}

