/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.jcache;

import javax.cache.Cache;
import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.jcache.JCacheTransactionalDataRegion;
import org.hibernate.cache.jcache.access.NonStrictCollectionRegionAccessStrategy;
import org.hibernate.cache.jcache.access.ReadOnlyCollectionRegionAccessStrategy;
import org.hibernate.cache.jcache.access.ReadWriteCollectionRegionAccessStrategy;
import org.hibernate.cache.spi.CacheDataDescription;
import org.hibernate.cache.spi.CollectionRegion;
import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.cache.spi.access.CollectionRegionAccessStrategy;

public class JCacheCollectionRegion
extends JCacheTransactionalDataRegion
implements CollectionRegion {
    public JCacheCollectionRegion(Cache<Object, Object> cache, CacheDataDescription metadata, SessionFactoryOptions options) {
        super(cache, metadata, options);
    }

    public CollectionRegionAccessStrategy buildAccessStrategy(AccessType accessType) throws CacheException {
        switch (accessType) {
            case READ_ONLY: {
                return new ReadOnlyCollectionRegionAccessStrategy(this);
            }
            case NONSTRICT_READ_WRITE: {
                return new NonStrictCollectionRegionAccessStrategy(this);
            }
            case READ_WRITE: {
                return new ReadWriteCollectionRegionAccessStrategy(this);
            }
            case TRANSACTIONAL: {
                throw new UnsupportedOperationException("Implement me!");
            }
        }
        throw new UnsupportedOperationException("Unknown AccessType: " + accessType.name());
    }
}

