/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.jbc.timestamp;

import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.transaction.Transaction;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.TimestampsRegion;
import org.hibernate.cache.jbc.TransactionalDataRegionAdapter;
import org.hibernate.cache.jbc.util.CacheHelper;
import org.jboss.cache.Cache;
import org.jboss.cache.Fqn;
import org.jboss.cache.config.Option;
import org.jboss.cache.notifications.annotation.CacheListener;
import org.jboss.cache.notifications.annotation.NodeModified;
import org.jboss.cache.notifications.annotation.NodeRemoved;
import org.jboss.cache.notifications.event.NodeInvalidatedEvent;
import org.jboss.cache.notifications.event.NodeModifiedEvent;
import org.jboss.cache.notifications.event.NodeRemovedEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@CacheListener
public class TimestampsRegionImpl
extends TransactionalDataRegionAdapter
implements TimestampsRegion {
    public static final String TYPE = "TS";
    private Map localCache = new ConcurrentHashMap();

    public TimestampsRegionImpl(Cache jbcCache, String regionName, String regionPrefix, Properties properties) {
        super(jbcCache, regionName, regionPrefix, null);
        jbcCache.addCacheListener((Object)this);
        this.populateLocalCache();
    }

    @Override
    protected Fqn<String> createRegionFqn(String regionName, String regionPrefix) {
        return TimestampsRegionImpl.getTypeFirstRegionFqn(regionName, regionPrefix, TYPE);
    }

    public void evict(Object key) throws CacheException {
        this.ensureRegionRootExists();
        Option opt = this.getNonLockingDataVersionOption(true);
        CacheHelper.removeNode(this.getCacheInstance(), this.getRegionFqn(), key, opt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evictAll() throws CacheException {
        Transaction tx = this.suspend();
        try {
            this.ensureRegionRootExists();
            Option opt = this.getNonLockingDataVersionOption(true);
            CacheHelper.sendEvictAllNotification(this.jbcCache, this.regionFqn, this.getMemberId(), opt);
        }
        finally {
            this.resume(tx);
        }
    }

    public Object get(Object key) throws CacheException {
        Object value = this.localCache.get(key);
        if (value == null && this.checkValid()) {
            this.ensureRegionRootExists();
            value = this.suspendAndGet(key, null, false);
            if (value != null) {
                this.localCache.put(key, value);
            }
        }
        return value;
    }

    public void put(Object key, Object value) throws CacheException {
        this.ensureRegionRootExists();
        Transaction tx = this.suspend();
        try {
            Option opt = this.getNonLockingDataVersionOption(false);
            opt.setForceAsynchronous(true);
            CacheHelper.put(this.getCacheInstance(), this.getRegionFqn(), key, value, opt);
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
        finally {
            this.resume(tx);
        }
    }

    @Override
    public void destroy() throws CacheException {
        this.localCache.clear();
        this.getCacheInstance().removeCacheListener((Object)this);
        super.destroy();
    }

    @Override
    @NodeModified
    public void nodeModified(NodeModifiedEvent event) {
        if (!this.handleEvictAllModification(event) && !event.isPre()) {
            Fqn fqn = event.getFqn();
            Fqn regFqn = this.getRegionFqn();
            if (fqn.size() == regFqn.size() + 1 && fqn.isChildOf(regFqn)) {
                Object key = fqn.get(regFqn.size());
                this.localCache.put(key, event.getData().get("item"));
            }
        }
    }

    @NodeRemoved
    public void nodeRemoved(NodeRemovedEvent event) {
        if (event.isPre()) {
            return;
        }
        Fqn fqn = event.getFqn();
        Fqn regFqn = this.getRegionFqn();
        if (fqn.size() == regFqn.size() + 1 && fqn.isChildOf(regFqn)) {
            Object key = fqn.get(regFqn.size());
            this.localCache.remove(key);
        } else if (fqn.equals((Object)regFqn)) {
            this.localCache.clear();
        }
    }

    @Override
    protected boolean handleEvictAllInvalidation(NodeInvalidatedEvent event) {
        boolean result = super.handleEvictAllInvalidation(event);
        if (result) {
            this.localCache.clear();
        }
        return result;
    }

    @Override
    protected boolean handleEvictAllModification(NodeModifiedEvent event) {
        boolean result = super.handleEvictAllModification(event);
        if (result) {
            this.localCache.clear();
        }
        return result;
    }

    private void populateLocalCache() {
        Set children = CacheHelper.getChildrenNames(this.getCacheInstance(), this.getRegionFqn());
        for (Object key : children) {
            this.get(key);
        }
    }
}

